/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.misure.model.fasce.CalendarioFasce;
import biz.elabor.misure.model.fasce.FasciaOraria;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.springframework.web.multipart.MultipartFile;

public class AcquisizioneFasce {
    private static final int INDEX_MESE = 0;
    private static final int INDEX_ORA = 1;
    private static final int START = 2;
    private static final int LINES_COUNT = 288;
    private static final String NAME = "fascia oraria";
    private CalendarioFasce calendario;

    public AcquisizioneFasce(String id, int anno) {
        this.calendario = new CalendarioFasce(id, anno);
    }

    public CalendarioFasce getCalendario() {
        return this.calendario;
    }

    public void acquisisci(MultipartFile file) throws IOException, InvalidFileFormat, InvalidValueException {
        CsvReader csvReader = new CsvReader(";");
        InputStream inputStream = file.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        csvReader.setReader(reader);
        csvReader.getNextRow();
        while (csvReader.hasNext()) {
            String[] data = csvReader.getNextRow();
            if (data[0].length() == 0) break;
            int lineNumber = csvReader.getLineNumber();
            this.parse(data, lineNumber);
        }
        int lineNumber = csvReader.getLineNumber();
        csvReader.close();
        if (lineNumber < 289) {
            throw new InvalidFileFormat("file.invalidlinenumber");
        }
    }

    private void parse(String[] data, int nRow) throws InvalidValueException {
        int numMese = Integer.valueOf(data[0]);
        Month mese = Month.valueOf(numMese);
        int ora = Integer.parseInt(data[1]);
        int anno = this.calendario.getAnno();
        int numGiorni = CalendarTools.getDaysOfMonth(anno, mese);
        int index = 2;
        while (index < 2 + numGiorni) {
            int fasciaInt;
            String value;
            try {
                value = data[index];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new InvalidValueException(NAME, "mancante", nRow);
            }
            try {
                fasciaInt = Integer.parseInt(value);
            }
            catch (NumberFormatException e3) {
                throw new InvalidValueException(NAME, value, nRow);
            }
            int giorno = index - 2 + 1;
            if (fasciaInt <= 0 || fasciaInt > FasciaOraria.values().length) {
                throw new InvalidValueException(NAME, String.valueOf(fasciaInt), nRow);
            }
            FasciaOraria fascia = FasciaOraria.values()[fasciaInt - 1];
            this.calendario.setFascia(mese, giorno, ora, fascia);
            ++index;
        }
    }
}

