/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.tariffe;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.tariffe.AbstractTariffa;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.PrezzoExtractor;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.tools.MathUtils;

public class TariffaMonoraria
extends AbstractTariffa {
    private double totale = 0.0;
    private double qtMisura = 0.0;
    private double qtMisuraEffettiva = 0.0;

    public TariffaMonoraria(Date date, double coeffUM, double qtconfla, double[] prezziDefault, double emtaruni, double emspread, double emspreneg, PrezzoExtractor extractor) {
        super(date, coeffUM, qtconfla, prezziDefault, emtaruni, emspread, emspreneg, extractor);
    }

    public void add(CurvaIndiciGiornaliera curva, RilGiorno rilGiorno) throws InvalidCurvaRilevazioniException {
        if (rilGiorno == null) {
            Date data = curva.getData();
            throw new InvalidCurvaRilevazioniException(data);
        }
        Date dataMisura = rilGiorno.getDate();
        Iterator cIterator = curva.iterator();
        Iterator rIterator = rilGiorno.iterator();
        while (cIterator.hasNext() && rIterator.hasNext()) {
            double attiva = 0.0;
            double ka = 1.0;
            int index = 0;
            while (index < 4) {
                RilQuarto rQuarto = (RilQuarto)rIterator.next();
                ka = rQuarto.getKa();
                attiva += MisureHelper.getAttiva(rQuarto) * ka;
                ++index;
            }
            IndiceOrario cOra = (IndiceOrario)cIterator.next();
            double prezzoOrario = cOra.getPrezzo();
            double prezzoReale = MathUtils.round(prezzoOrario * this.coeffUM, 8);
            double spread = this.extractor.getEmspread(this.emspread, this.emspreneg);
            double prezzoEfficace = this.extractor.getPrezzo(prezzoReale, this.emtaruni, spread, attiva, this.qtconfla);
            int ora = cOra.getOra();
            double attivaEfficace = this.extractor.getConsumoEfficace(attiva, this.qtconfla, this.emtaruni, this.emspreneg);
            double costoOra = MathUtils.round(prezzoEfficace * attivaEfficace, 8);
            DettaglioTariffa dettaglio = new DettaglioTariffa(dataMisura, ora, ka, attiva, prezzoEfficace, null, this.qtconfla, attivaEfficace, costoOra, prezzoReale);
            this.addDettaglio(dettaglio);
        }
    }

    public void addDettaglio(DettaglioTariffa dettaglio) {
        this.totale += dettaglio.getCostoOra();
        this.qtMisura += dettaglio.getAttiva();
        this.qtMisuraEffettiva += dettaglio.getAttivaEffettiva();
        this.dettagli.add(dettaglio);
    }

    @Override
    public double getValue(FasciaOraria fascia) {
        return this.qtMisura == 0.0 ? 0.0 : (this.extractor.isFlat() ? this.prezziDefault[fascia.ordinal()] : MathUtils.round(this.totale / this.qtMisura, 8));
    }

    @Override
    public double getQtMisura() {
        return this.extractor.getQtMisura(this.qtMisuraEffettiva, this.qtMisura);
    }

    @Override
    public double getQtMisura(FasciaOraria fascia) {
        return this.getQtMisura();
    }

    @Override
    public double getQtMisuraEffettiva() {
        return this.qtMisuraEffettiva;
    }

    @Override
    public double getQtMisuraEffettiva(FasciaOraria fascia) {
        return this.getQtMisuraEffettiva();
    }

    @Override
    public List<DettaglioTariffa> getDettagli() {
        return this.dettagli;
    }

    @Override
    public double getTotale(FasciaOraria fascia) {
        return this.totale;
    }

    @Override
    public double getPrezzoMedioPonderatoNetto(FasciaOraria fascia) {
        return this.getValue(fascia);
    }
}

