/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.statopod.AbstractNoncommercialeStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.util.Date;

public class SnfStatoPod
extends AbstractNoncommercialeStatoPod {
    private String servizio;
    private String pod;
    private String cf;
    private String piva;
    private String pivaDistributore;
    private String pivaReseller;
    private String pivaDispatcher;
    private String codiceDispacciamento;
    private String stato;
    private String flagResidente;
    private Date dataMovimento;
    private final int numeroProgressivo;
    private Date dataAttivazione;
    private Date dataCessazione;
    private String cdunipre;
    private String cdFlusso;
    private String tabellaRiferimento;
    private String chiaveTabellaRiferimento;
    private String toponimo;
    private String via;
    private String civico;
    private String comuneCatastale;
    private String cap;
    private boolean flagOrario;
    private String cdtardis;
    private int tensione;
    private String livelloTensione;
    private double potenzaContr;
    private double potenzaDisp;
    private boolean flmisCon;
    private boolean flmisRea;
    private boolean flmisPot;
    private double inmisCon;
    private double inmisRea;
    private double inmisPot;
    private double nuLetA01;
    private double nuLetA02;
    private double nuLetA03;
    private double nuLetR01;
    private double nuLetR02;
    private double nuLetR03;
    private double nuLetP01;
    private double nuLetP02;
    private double nuLetP03;
    private String nuMatrA;
    private String nuMatrR;
    private String nuMatrP;
    private String modContatoreA;
    private String modContatoreR;
    private String modContatoreP;
    private String modContatoreBio;
    private boolean flazzconA;
    private boolean flazzconR;
    private boolean flazzconP;
    private int nuCifreA;
    private int nuCifreR;
    private int nuCifreP;
    private int nnFascia;
    private String statoRic;
    private String servizioTutela;
    private final Date dataPrestazione;

    public SnfStatoPod(Prestazione prestazione, SnfD65 snf, StatoPod riferimento, int numeroProgressivo, String pivaDistributore, String pivaDispatcher, String codContrDisp, int tensione, double potenzaContr, double potenzaDisp, String cdtardis, String servizioTutela, String flagResidente) {
        super(riferimento, riferimento.getCpGestore(), riferimento.getCpUtente(), flagResidente);
        String cdConMag = "CE";
        this.servizio = riferimento.getServizio();
        this.pod = snf.getCodicePod();
        this.cf = riferimento.getCf();
        this.piva = riferimento.getPiva();
        this.pivaDistributore = pivaDistributore;
        this.pivaReseller = riferimento.getPivaReseller();
        this.pivaDispatcher = pivaDispatcher;
        this.codiceDispacciamento = codContrDisp;
        this.stato = prestazione.getStato();
        this.flagResidente = riferimento.getFlagResidente();
        this.dataMovimento = snf.getDataMovimento();
        this.numeroProgressivo = numeroProgressivo;
        this.dataAttivazione = riferimento.getDataAttivazione();
        this.dataCessazione = null;
        this.cdunipre = prestazione.getPrestazione();
        this.cdFlusso = snf.getCodiceFlusso();
        this.tabellaRiferimento = snf.getTabella();
        this.chiaveTabellaRiferimento = snf.getId().iterator().next();
        this.toponimo = riferimento.getToponimo();
        this.via = riferimento.getVia();
        this.civico = riferimento.getCivico();
        this.comuneCatastale = riferimento.getComuneCatastale();
        this.cap = riferimento.getCap();
        this.flagOrario = false;
        this.cdtardis = cdtardis;
        this.tensione = tensione;
        this.livelloTensione = this.tensione < 1000 ? "0" : "1";
        this.potenzaContr = potenzaContr;
        this.potenzaDisp = potenzaDisp;
        this.flmisCon = true;
        this.flmisRea = false;
        this.flmisPot = false;
        this.nnFascia = snf.getTrattamento().getFasce();
        this.nuLetA01 = 0.0;
        this.nuLetA02 = 0.0;
        this.nuLetA03 = 0.0;
        this.nuLetR01 = 0.0;
        this.nuLetR02 = 0.0;
        this.nuLetR03 = 0.0;
        this.nuLetP01 = 0.0;
        this.nuLetP02 = 0.0;
        this.nuLetP03 = 0.0;
        this.nuMatrA = "FITTIZIA";
        this.nuMatrR = null;
        this.nuMatrP = null;
        this.modContatoreA = cdConMag;
        this.modContatoreR = null;
        this.modContatoreP = null;
        this.modContatoreBio = null;
        this.flazzconA = false;
        this.flazzconR = false;
        this.flazzconP = false;
        this.nuCifreA = 0;
        this.nuCifreR = 0;
        this.nuCifreP = 0;
        this.inmisCon = StatoPodHelper.getDoubleNullable(snf.getKa());
        this.inmisRea = StatoPodHelper.getDoubleNullable(snf.getKr());
        this.inmisPot = StatoPodHelper.getDoubleNullable(snf.getKp());
        this.statoRic = prestazione.getStatoRichiesta();
        this.servizioTutela = servizioTutela;
        this.dataPrestazione = riferimento.getDataPrestazione();
    }

    @Override
    public Date getDataPrestazione() {
        return this.dataPrestazione;
    }

    @Override
    public String getStatoRic() {
        return this.statoRic;
    }

    @Override
    public String getStato() {
        return this.stato;
    }

    @Override
    public Date getDataCessazione() {
        return this.dataCessazione;
    }

    @Override
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    @Override
    public String getServizio() {
        return this.servizio;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getCf() {
        return this.cf;
    }

    @Override
    public String getPiva() {
        return this.piva;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public String getPivaReseller() {
        return this.pivaReseller;
    }

    @Override
    public String getPivaDispatcher() {
        return this.pivaDispatcher;
    }

    @Override
    public String getCodiceDispacciamento() {
        return this.codiceDispacciamento;
    }

    @Override
    public String getFlagResidente() {
        return this.flagResidente;
    }

    @Override
    public int getNuprogre() {
        return this.numeroProgressivo;
    }

    @Override
    public Date getDataAttivazione() {
        return this.dataAttivazione;
    }

    @Override
    public String getCdunipre() {
        return this.cdunipre;
    }

    @Override
    public String getCdFlusso() {
        return this.cdFlusso;
    }

    @Override
    public String getTabellaRiferimento() {
        return this.tabellaRiferimento;
    }

    @Override
    public String getChiaveTabellaRiferimento() {
        return this.chiaveTabellaRiferimento;
    }

    @Override
    public String getToponimo() {
        return this.toponimo;
    }

    @Override
    public String getVia() {
        return this.via;
    }

    @Override
    public String getCivico() {
        return this.civico;
    }

    @Override
    public String getComuneCatastale() {
        return this.comuneCatastale;
    }

    @Override
    public String getCap() {
        return this.cap;
    }

    @Override
    public boolean getFlagOrario() {
        return this.flagOrario;
    }

    @Override
    public String getCdtardis() {
        return this.cdtardis;
    }

    @Override
    public int getTensione() {
        return this.tensione;
    }

    @Override
    public String getLivelloTensione() {
        return this.livelloTensione;
    }

    @Override
    public double getPotenzaContr() {
        return this.potenzaContr;
    }

    @Override
    public double getPotenzaDisp() {
        return this.potenzaDisp;
    }

    @Override
    public boolean getFlmisCon() {
        return this.flmisCon;
    }

    @Override
    public boolean getFlmisRea() {
        return this.flmisRea;
    }

    @Override
    public boolean getFlmisPot() {
        return this.flmisPot;
    }

    @Override
    public double getNuLetA01() {
        return this.nuLetA01;
    }

    @Override
    public double getNuLetA02() {
        return this.nuLetA02;
    }

    @Override
    public double getNuLetA03() {
        return this.nuLetA03;
    }

    @Override
    public double getNuLetR01() {
        return this.nuLetR01;
    }

    @Override
    public double getNuLetR02() {
        return this.nuLetR02;
    }

    @Override
    public double getNuLetR03() {
        return this.nuLetR03;
    }

    @Override
    public double getNuLetP01() {
        return this.nuLetP01;
    }

    @Override
    public double getNuLetP02() {
        return this.nuLetP02;
    }

    @Override
    public double getNuLetP03() {
        return this.nuLetP03;
    }

    @Override
    public double getInmisCon() {
        return this.inmisCon;
    }

    @Override
    public double getInmisRea() {
        return this.inmisRea;
    }

    @Override
    public double getInmisPot() {
        return this.inmisPot;
    }

    @Override
    public String getNuMatrA() {
        return this.nuMatrA;
    }

    @Override
    public String getNuMatrR() {
        return this.nuMatrR;
    }

    @Override
    public String getNuMatrP() {
        return this.nuMatrP;
    }

    @Override
    public String getModContatoreA() {
        return this.modContatoreA;
    }

    @Override
    public String getModContatoreR() {
        return this.modContatoreR;
    }

    @Override
    public String getModContatoreP() {
        return this.modContatoreP;
    }

    @Override
    public String getModContatoreBio() {
        return this.modContatoreBio;
    }

    @Override
    public boolean isFlazzconA() {
        return this.flazzconA;
    }

    @Override
    public boolean isFlazzconR() {
        return this.flazzconR;
    }

    @Override
    public boolean isFlazzconP() {
        return this.flazzconP;
    }

    @Override
    public int getNuCifreA() {
        return this.nuCifreA;
    }

    @Override
    public int getNuCifreR() {
        return this.nuCifreR;
    }

    @Override
    public int getNuCifreP() {
        return this.nuCifreP;
    }

    @Override
    public int getNnFascia() {
        return this.nnFascia;
    }

    @Override
    public boolean isPraticaAnnullata() {
        return false;
    }

    @Override
    public String getServizioTutela() {
        return this.servizioTutela;
    }
}

