/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.statopod.SegnalePrestazione;
import org.homelinux.elabor.structures.KeyRecord;

public class Prestazione
implements KeyRecord<String> {
    private final String servizio;
    private final String prestazione;
    private final String flusso;
    private final int codiceSegnale;
    private final String stato;
    private final String statoRichiesta;
    private final int sequenza;
    private final String statoRicMovRif;
    private final boolean importDispatcher;

    public Prestazione(String servizio, String prestazione, String flusso, int sequenza, int codiceSegnale, String stato, String statoRichiesta, String statoRicMovRif, boolean importDispatcher) {
        this.servizio = servizio;
        this.prestazione = prestazione;
        this.flusso = flusso;
        this.sequenza = sequenza;
        this.codiceSegnale = codiceSegnale;
        this.stato = stato;
        this.statoRichiesta = statoRichiesta;
        this.statoRicMovRif = statoRicMovRif == null ? "" : statoRicMovRif;
        this.importDispatcher = importDispatcher;
    }

    public static String getKey(String servizio, String prestazione, String flusso) {
        String flussoStd = flusso.toUpperCase();
        if (!flussoStd.equals("F2G") && flussoStd.endsWith("2G")) {
            flussoStd = flussoStd.substring(0, flussoStd.length() - 2);
        }
        return String.valueOf(servizio.toUpperCase()) + "|" + prestazione.toUpperCase() + "|" + flussoStd;
    }

    @Override
    public String getKey() {
        return Prestazione.getKey(this.servizio, this.prestazione, this.flusso);
    }

    public SegnalePrestazione getSegnale() {
        return SegnalePrestazione.get(this.codiceSegnale);
    }

    public String getStato() {
        return this.stato;
    }

    public String getPrestazione() {
        return this.prestazione;
    }

    public String getStatoRichiesta() {
        return this.statoRichiesta;
    }

    public String getServizio() {
        return this.servizio;
    }

    public int getSequenza() {
        return this.sequenza;
    }

    public String getStatoRicMovRif() {
        return this.statoRicMovRif;
    }

    public boolean isSwitchout() {
        return this.prestazione.equals("SE3");
    }

    public boolean isImportDispatcher() {
        return this.importDispatcher;
    }
}

