/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import java.util.Date;

class ContatoreStatoPodChecker
implements StatoPodChecker<MisuraPod> {
    ContatoreStatoPodChecker() {
    }

    @Override
    public void check(MisuraPod current, StatoPod riferimento, String prestazione) throws StatoPodObsoletoException, StatoPodInvalidoException {
        boolean ok;
        String currMatr = current.getMatricolaAtt();
        if (currMatr == null || currMatr.isEmpty()) {
            ok = true;
        } else {
            currMatr = currMatr.trim();
            String rifMatr = riferimento.getNuMatrA().trim();
            ok = currMatr.endsWith(rifMatr);
        }
        if (!ok) {
            String codicePod = current.getCodicePod();
            Date dataMovimento = current.getDataMovimento();
            if (dataMovimento.equals(riferimento.getDataMovimento())) {
                throw new StatoPodObsoletoException("obsoleto", ErroriElaborazione.OBSOLETO, codicePod, prestazione, dataMovimento);
            }
            throw new StatoPodInvalidoException("matr.nonvalida", ErroriElaborazione.MATR_NONVALIDA, codicePod, prestazione);
        }
    }
}

