/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.misure.MisureFasce;
import biz.elabor.prebilling.model.statopod.AbstractStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.model.statopod.StatoPodMisuraHandler;
import java.util.Date;
import java.util.Set;

public abstract class AbstractMisuraStatoPod
extends AbstractStatoPod {
    private String servizio;
    private String pod;
    private String cf;
    private String piva;
    private String pivaDistributore;
    private String pivaReseller;
    private String pivaDispatcher;
    private String codiceDispacciamento;
    private String stato;
    private String flagResidente;
    private int numeroProgressivo;
    private Date dataAttivazione;
    private Date dataCessazione;
    private String cdunipre;
    private String cdFlusso;
    private String chiaveTabellaRiferimento;
    private String toponimo;
    private String via;
    private String civico;
    private String comuneCatastale;
    private String cap;
    private boolean flagOrario;
    private String cdtardis;
    private int tensione;
    private String livelloTensione;
    private double potenzaContr;
    private double potenzaDisp;
    private boolean flmisCon;
    private boolean flmisRea;
    private boolean flmisPot;
    private double inmisCon;
    private double inmisRea;
    private double inmisPot;
    private double nuLetA01;
    private double nuLetA02;
    private double nuLetA03;
    private double nuLetR01;
    private double nuLetR02;
    private double nuLetR03;
    private double nuLetP01;
    private double nuLetP02;
    private double nuLetP03;
    private String nuMatrA;
    private String nuMatrR;
    private String nuMatrP;
    private String nuMatrBio;
    private String modContatoreA;
    private String modContatoreR;
    private String modContatoreP;
    private String modContatoreBio;
    private boolean flazzconA;
    private boolean flazzconR;
    private boolean flazzconP;
    private int nuCifreA;
    private int nuCifreR;
    private int nuCifreP;
    private int nnFascia;
    private String statoRic;
    private final String codiceOfferta;
    private final String tabella;

    public AbstractMisuraStatoPod(Prestazione prestazione, String flusso, MisuraD65 mno, boolean flmisCon, boolean flmisRea, boolean flmisPot, String nuMatrA, String nuMatrR, String nuMatrP, String nuMatrBio, String modContatoreA, String modContatoreR, String modContatoreP, String modContatoreBio, double[] lastAttiva, double[] lastReattiva, StatoPod riferimento, int numeroProgressivo, String tabella, boolean orario, boolean azzeramento, StatoPodMisuraHandler misuraHandler, String cpGestore, String cpUtente, int defaultNCifre) {
        super(riferimento.getServizioTutela(), riferimento.getDataPrestazione(), riferimento.getId(), cpGestore, cpUtente, riferimento.getResidenza());
        MisureFasce misura = misuraHandler.getMisura(mno, riferimento);
        this.servizio = riferimento.getServizio();
        this.pod = mno.getCodicePod();
        this.cf = riferimento.getCf();
        this.piva = riferimento.getPiva();
        this.pivaDistributore = mno.getPivaDistributore();
        this.pivaReseller = riferimento.getPivaReseller();
        this.pivaDispatcher = mno.getPivaUtente();
        this.codiceDispacciamento = mno.getCodContrDisp();
        this.stato = prestazione.getStato();
        this.flagResidente = riferimento.getFlagResidente();
        this.numeroProgressivo = numeroProgressivo;
        this.cdFlusso = flusso;
        this.dataAttivazione = this.findDataAttivazione(prestazione, riferimento);
        this.dataCessazione = this.getDataCessazione(prestazione, mno);
        this.cdunipre = prestazione.getPrestazione();
        Set<String> id = mno.getId();
        this.chiaveTabellaRiferimento = id.iterator().next();
        this.toponimo = riferimento.getToponimo();
        this.via = riferimento.getVia();
        this.civico = riferimento.getCivico();
        this.comuneCatastale = riferimento.getComuneCatastale();
        this.cap = riferimento.getCap();
        this.flagOrario = orario;
        this.cdtardis = riferimento.getCdtardis();
        this.tensione = riferimento.getTensione();
        this.livelloTensione = riferimento.getLivelloTensione();
        this.potenzaContr = riferimento.getPotenzaContr();
        this.potenzaDisp = riferimento.getPotenzaDisp();
        this.flmisCon = flmisCon;
        this.flmisRea = flmisRea;
        this.flmisPot = flmisPot;
        this.nnFascia = mno.getTrattamento().getFasce();
        this.nuLetA01 = this.flmisCon ? AbstractMisuraStatoPod.getAttiva(misura, lastAttiva, FasciaOraria.F1) : 0.0;
        this.nuLetA02 = this.flmisCon && this.nnFascia == 3 ? AbstractMisuraStatoPod.getAttiva(misura, lastAttiva, FasciaOraria.F2) : 0.0;
        this.nuLetA03 = this.flmisCon && this.nnFascia == 3 ? AbstractMisuraStatoPod.getAttiva(misura, lastAttiva, FasciaOraria.F3) : 0.0;
        this.nuLetR01 = this.flmisRea ? misura.getReattiva(FasciaOraria.F1).getNetto() : 0.0;
        this.nuLetR02 = this.flmisRea && this.nnFascia == 3 ? AbstractMisuraStatoPod.getReattiva(misura, lastReattiva, FasciaOraria.F2) : 0.0;
        this.nuLetR03 = this.flmisRea && this.nnFascia == 3 ? AbstractMisuraStatoPod.getReattiva(misura, lastReattiva, FasciaOraria.F3) : 0.0;
        this.nuLetP01 = this.flmisPot ? misura.getPotenza(FasciaOraria.F1).getNetto() : 0.0;
        this.nuLetP02 = this.flmisPot && this.nnFascia == 3 ? misura.getPotenza(FasciaOraria.F2).getNetto() : 0.0;
        this.nuLetP03 = this.flmisPot && this.nnFascia == 3 ? misura.getPotenza(FasciaOraria.F3).getNetto() : 0.0;
        this.nuMatrA = nuMatrA;
        this.nuMatrR = nuMatrR;
        this.nuMatrP = nuMatrP;
        this.nuMatrBio = nuMatrBio;
        this.modContatoreA = modContatoreA;
        this.modContatoreR = modContatoreR;
        this.modContatoreP = modContatoreP;
        this.modContatoreBio = modContatoreBio;
        this.flazzconA = azzeramento;
        this.flazzconR = azzeramento;
        this.flazzconP = true;
        String cifreAtt = mno.getCifreAtt();
        String cifreRea = mno.getCifreRea();
        String cifrePot = mno.getCifrePot();
        this.nuCifreA = AbstractMisuraStatoPod.getNuCifre(this.flmisCon, cifreAtt, defaultNCifre);
        this.nuCifreR = AbstractMisuraStatoPod.getNuCifre(this.flmisRea, cifreRea, defaultNCifre);
        this.nuCifreP = AbstractMisuraStatoPod.getNuCifre(this.flmisPot, cifrePot, defaultNCifre);
        this.inmisCon = StatoPodHelper.getDoubleNullable(mno.getKa());
        this.inmisRea = StatoPodHelper.getDoubleNullable(mno.getKr());
        this.inmisPot = StatoPodHelper.getDoubleNullable(mno.getKp());
        this.statoRic = prestazione.getStatoRichiesta();
        this.codiceOfferta = riferimento.getCodiceOfferta();
        this.tabella = tabella;
    }

    private static int getNuCifre(boolean flmis, String cifreAtt, int defaultValue) {
        return flmis ? AbstractMisuraStatoPod.getSafeInt(cifreAtt, defaultValue) : 0;
    }

    private static int getSafeInt(String cifreAtt, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(cifreAtt);
        }
        catch (Exception exc) {
            value = defaultValue;
        }
        return value;
    }

    private static double getAttiva(MisureFasce misura, double[] lastAttiva, FasciaOraria fascia) {
        double energia = misura.getAttiva(fascia).getNetto();
        return AbstractMisuraStatoPod.getMisura(energia, lastAttiva, fascia);
    }

    private static double getReattiva(MisureFasce misura, double[] lastReattiva, FasciaOraria fascia) {
        double energia = misura.getReattiva(fascia).getNetto();
        return AbstractMisuraStatoPod.getMisura(energia, lastReattiva, fascia);
    }

    private static double getMisura(double energia, double[] lastMisura, FasciaOraria fascia) {
        double last = lastMisura == null ? 0.0 : lastMisura[fascia.ordinal()];
        return energia < last - 1.0 || energia > last ? energia : last;
    }

    @Override
    public String getStatoRic() {
        return this.statoRic;
    }

    @Override
    public String getStato() {
        return this.stato;
    }

    @Override
    public Date getDataCessazione() {
        return this.dataCessazione;
    }

    @Override
    public String getServizio() {
        return this.servizio;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getCf() {
        return this.cf;
    }

    @Override
    public String getPiva() {
        return this.piva;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public String getPivaReseller() {
        return this.pivaReseller;
    }

    @Override
    public String getPivaDispatcher() {
        return this.pivaDispatcher;
    }

    @Override
    public String getCodiceDispacciamento() {
        return this.codiceDispacciamento;
    }

    @Override
    public String getFlagResidente() {
        return this.flagResidente;
    }

    @Override
    public int getNuprogre() {
        return this.numeroProgressivo;
    }

    @Override
    public Date getDataAttivazione() {
        return this.dataAttivazione;
    }

    @Override
    public String getCdunipre() {
        return this.cdunipre;
    }

    @Override
    public String getCdFlusso() {
        return this.cdFlusso;
    }

    @Override
    public String getTabellaRiferimento() {
        return this.tabella;
    }

    @Override
    public String getChiaveTabellaRiferimento() {
        return this.chiaveTabellaRiferimento;
    }

    @Override
    public String getToponimo() {
        return this.toponimo;
    }

    @Override
    public String getVia() {
        return this.via;
    }

    @Override
    public String getCivico() {
        return this.civico;
    }

    @Override
    public String getComuneCatastale() {
        return this.comuneCatastale;
    }

    @Override
    public String getCap() {
        return this.cap;
    }

    @Override
    public boolean getFlagOrario() {
        return this.flagOrario;
    }

    @Override
    public String getCdtardis() {
        return this.cdtardis;
    }

    @Override
    public int getTensione() {
        return this.tensione;
    }

    @Override
    public String getLivelloTensione() {
        return this.livelloTensione;
    }

    @Override
    public double getPotenzaContr() {
        return this.potenzaContr;
    }

    @Override
    public double getPotenzaDisp() {
        return this.potenzaDisp;
    }

    @Override
    public boolean getFlmisCon() {
        return this.flmisCon;
    }

    @Override
    public boolean getFlmisRea() {
        return this.flmisRea;
    }

    @Override
    public boolean getFlmisPot() {
        return this.flmisPot;
    }

    @Override
    public double getNuLetA01() {
        return this.nuLetA01;
    }

    @Override
    public double getNuLetA02() {
        return this.nuLetA02;
    }

    @Override
    public double getNuLetA03() {
        return this.nuLetA03;
    }

    @Override
    public double getNuLetR01() {
        return this.nuLetR01;
    }

    @Override
    public double getNuLetR02() {
        return this.nuLetR02;
    }

    @Override
    public double getNuLetR03() {
        return this.nuLetR03;
    }

    @Override
    public double getNuLetP01() {
        return this.nuLetP01;
    }

    @Override
    public double getNuLetP02() {
        return this.nuLetP02;
    }

    @Override
    public double getNuLetP03() {
        return this.nuLetP03;
    }

    @Override
    public double getInmisCon() {
        return this.inmisCon;
    }

    @Override
    public double getInmisRea() {
        return this.inmisRea;
    }

    @Override
    public double getInmisPot() {
        return this.inmisPot;
    }

    @Override
    public String getNuMatrA() {
        return this.nuMatrA;
    }

    @Override
    public String getNuMatrR() {
        return this.nuMatrR;
    }

    @Override
    public String getNuMatrP() {
        return this.nuMatrP;
    }

    @Override
    public String getModContatoreA() {
        return this.modContatoreA;
    }

    @Override
    public String getModContatoreR() {
        return this.modContatoreR;
    }

    @Override
    public String getModContatoreP() {
        return this.modContatoreP;
    }

    @Override
    public boolean isFlazzconA() {
        return this.flazzconA;
    }

    @Override
    public boolean isFlazzconR() {
        return this.flazzconR;
    }

    @Override
    public boolean isFlazzconP() {
        return this.flazzconP;
    }

    @Override
    public int getNuCifreA() {
        return this.nuCifreA;
    }

    @Override
    public int getNuCifreR() {
        return this.nuCifreR;
    }

    @Override
    public int getNuCifreP() {
        return this.nuCifreP;
    }

    @Override
    public int getNnFascia() {
        return this.nnFascia;
    }

    @Override
    public boolean isPraticaAnnullata() {
        return false;
    }

    @Override
    public boolean isFlMisBio() {
        return false;
    }

    @Override
    public double getInMisBio() {
        return this.isFlMisBio() ? this.inmisCon : 0.0;
    }

    @Override
    public double getNuLetBio01() {
        return 0.0;
    }

    @Override
    public double getNuLetBio02() {
        return 0.0;
    }

    @Override
    public double getNuLetBio03() {
        return 0.0;
    }

    @Override
    public String getNuMatricBio() {
        return this.nuMatrBio;
    }

    @Override
    public String getModContatoreBio() {
        return this.modContatoreBio;
    }

    @Override
    public boolean isFlAzzConBio() {
        return false;
    }

    @Override
    public int getNuCifreBio() {
        return 0;
    }

    @Override
    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }
}

