/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.model.misure.FasceHandler;
import biz.elabor.prebilling.model.misure.MonoHandler;
import biz.elabor.prebilling.model.misure.OrarioHandler;
import biz.elabor.prebilling.model.misure.TrattamentoVisitor;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;

public enum Trattamento {
    M(1, false, new MonoHandler(), "MONO"),
    F(3, false, new FasceHandler(), "CE"),
    O(3, true, new OrarioHandler(), "CEO"),
    C(3, false, new FasceHandler(), "GME", "CE");

    private final int fasce;
    private final boolean orario;
    private final TrattamentoHandler handler;
    private final String ordCdConmag;
    private final String altCdConMag;

    private Trattamento(int fasce, boolean orario, TrattamentoHandler handler, String ordCdConmag) {
        this(fasce, orario, handler, ordCdConmag, ordCdConmag);
    }

    private Trattamento(int fasce, boolean orario, TrattamentoHandler handler, String ordCdConmag, String altCdConMag) {
        this.fasce = fasce;
        this.orario = orario;
        this.handler = handler;
        this.ordCdConmag = ordCdConmag;
        this.altCdConMag = altCdConMag;
    }

    public int getFasce() {
        return this.fasce;
    }

    public boolean isMono() {
        return this.equals((Object)M);
    }

    public boolean isOrario() {
        return this.orario;
    }

    public TrattamentoHandler getHandler() {
        return this.handler;
    }

    public String getOrdCdConmag(String tarDis) {
        return "BTIP".equalsIgnoreCase(tarDis) ? this.altCdConMag : this.ordCdConmag;
    }

    public void accept(TrattamentoVisitor visitor) {
        this.handler.accept(visitor);
    }
}

