/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import java.util.HashMap;
import java.util.Map;

public enum TipoLettura {
    EFFETTIVA(3),
    CALCOLATA(2),
    STIMATA(1),
    RETTIFICA(8),
    MONTAGGIO(6),
    SMONTAGGIO(7),
    ATTIVAZIONE(5),
    VOLTURA(4);

    private int peso;
    private static final Map<String, TipoLettura> MAP;

    static {
        MAP = new HashMap<String, TipoLettura>();
        MAP.put("E", EFFETTIVA);
        MAP.put("C", CALCOLATA);
        MAP.put("S", STIMATA);
        MAP.put("R", RETTIFICA);
        MAP.put("M", MONTAGGIO);
        MAP.put("G", SMONTAGGIO);
        MAP.put("A", ATTIVAZIONE);
        MAP.put("V", VOLTURA);
    }

    private TipoLettura(int peso) {
        this.peso = peso;
    }

    public static TipoLettura get(String key) {
        return MAP.get(key);
    }

    public int compare(TipoLettura tipo) {
        return this.peso - tipo.peso;
    }
}

