/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.model.misure.RilGiorno;
import java.util.ArrayList;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.structures.TappoIterator;

public class RilMese
extends ArrayList<RilGiorno> {
    private static final long serialVersionUID = 1L;
    private String codicePod;
    private int anno;
    private Month mese;
    private String matricola;

    public RilMese(String codicePod, int anno, Month mese, String matricola) {
        this.codicePod = codicePod;
        this.anno = anno;
        this.mese = mese;
        this.matricola = matricola;
    }

    public int getAnno() {
        return this.anno;
    }

    public Month getMese() {
        return this.mese;
    }

    public String getMatricola() {
        return this.matricola;
    }

    public String getCodicePod() {
        return this.codicePod;
    }

    public WorkingPeriod getPeriod() {
        return new WorkingPeriod(this.anno, this.mese);
    }

    public String getFirstCodiceFlusso() {
        return this.isEmpty() ? "" : ((RilGiorno)this.get(0)).getFirstCodiceFlusso();
    }

    public RilGiorno getRilGiorno(Date date) {
        RilGiorno rilGiorno = null;
        for (RilGiorno current : this) {
            if (!current.getDate().equals(date)) continue;
            rilGiorno = current;
            break;
        }
        return rilGiorno;
    }

    public void merge(RilMese rilMese, Date startDate, Date endDate, double coeffPerdite) {
        Date endOfTime = CalendarTools.getEndOfTime();
        RilGiorno tappo = new RilGiorno(endOfTime);
        TappoIterator<RilGiorno> iterator = new TappoIterator<RilGiorno>(rilMese.iterator(), tappo);
        RilGiorno next = (RilGiorno)iterator.next();
        Date nextDate = next.getDate();
        for (RilGiorno rilGiorno : this) {
            Date date = rilGiorno.getDate();
            if (date.before(nextDate)) continue;
            if (!nextDate.before(startDate) && !nextDate.after(endDate)) {
                rilGiorno.merge(next, coeffPerdite);
            }
            next = (RilGiorno)iterator.next();
            nextDate = next.getDate();
        }
    }
}

