/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.homelinux.elabor.calendar.CalendarTools;

public class RilGiorno
extends ArrayList<RilQuarto> {
    private static final long serialVersionUID = 1L;
    private final Date date;
    private boolean capacitiva;
    private boolean induttiva;
    private final boolean ricostruito;

    public RilGiorno(Date date, boolean ricostruito) {
        this.date = date;
        this.ricostruito = ricostruito;
    }

    public RilGiorno(Date date) {
        this(date, false);
    }

    public RilGiorno(Date date, String flusso, String id, Double[] attiva, Double[] reattiva, Double[] reattivaCapacitiva, Double[] reattivaInduttiva, RilQuartoType type) {
        this(date);
        int size = CalendarTools.getHoursOfDay(date) * 4;
        this.capacitiva = reattivaCapacitiva != null;
        this.induttiva = reattivaInduttiva != null;
        int index = 0;
        while (index < size) {
            Double reaC = reattivaCapacitiva == null ? null : reattivaCapacitiva[index];
            Double reaI = reattivaInduttiva == null ? null : reattivaInduttiva[index];
            RilQuarto rilQuarto = new RilQuarto(index, flusso, id, attiva[index], reattiva[index], reaC, reaI, 0.0, type);
            this.add(rilQuarto);
            ++index;
        }
    }

    public RilGiorno(RilGiorno rilGiorno) {
        this(rilGiorno.getDate());
        this.capacitiva = rilGiorno.isCapacitiva();
        this.induttiva = rilGiorno.isInduttiva();
        for (RilQuarto rilQuarto : rilGiorno) {
            RilQuarto newRilQuarto = new RilQuarto(rilQuarto);
            this.add(newRilQuarto);
        }
    }

    public boolean isCapacitiva() {
        return this.capacitiva;
    }

    public boolean isInduttiva() {
        return this.induttiva;
    }

    public Date getDate() {
        return this.date;
    }

    public String getFirstCodiceFlusso() {
        return this.isEmpty() ? null : ((RilQuarto)this.get(0)).getCodiceFlusso();
    }

    public String getCodiceFlusso(int index) {
        return this.size() <= index ? null : ((RilQuarto)this.get(index)).getCodiceFlusso();
    }

    public boolean checkKA(double oldKa, double newKa) {
        boolean ok = true;
        double checkKa = oldKa;
        Iterator iterator = this.iterator();
        while (ok && iterator.hasNext()) {
            RilQuarto rilQuarto = (RilQuarto)iterator.next();
            double kaRilQuarto = rilQuarto.getKa();
            if (kaRilQuarto != checkKa) {
                checkKa = newKa;
            }
            boolean bl = ok = kaRilQuarto == checkKa;
        }
        return ok;
    }

    public void merge(RilGiorno rilGiorno, double coeffPerdite) {
        int index = 0;
        while (index < CalendarTools.getHoursOfDay(this.date) * 4) {
            RilQuarto rilQuarto = (RilQuarto)this.get(index);
            double attiva = rilQuarto.getAttiva();
            RilQuarto newRilQuarto = (RilQuarto)rilGiorno.get(index);
            Double newAttiva = newRilQuarto.getAttiva();
            double currAttiva = newAttiva == null ? 0.0 : newAttiva;
            double ka = newRilQuarto.getKa();
            rilQuarto.setAttiva(attiva += currAttiva * coeffPerdite * ka);
            RilQuartoType type = newRilQuarto.getType();
            rilQuarto.setType(type);
            ++index;
        }
    }

    public boolean isRicostruito() {
        return this.ricostruito;
    }
}

