/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.model.misure.RilGiorno;
import java.util.Map;
import org.homelinux.elabor.tools.StringUtils;

public class RilData
extends RilGiorno {
    private static final long serialVersionUID = 1L;
    private final String tipoRettifica;
    private final Map<String, Map<String, String>> datiPod;

    public Map<String, Map<String, String>> getDatiPod() {
        return this.datiPod;
    }

    public RilData(String tipoRettifica, Map<String, Map<String, String>> datiPod, RilGiorno rilGiorno) {
        super(rilGiorno);
        this.tipoRettifica = tipoRettifica;
        this.datiPod = datiPod;
    }

    private Map<String, String> getDatiPdo() {
        return this.datiPod.get("DatiPdp");
    }

    private Map<String, String> getMisura() {
        String key = this.datiPod.containsKey("Misura") ? "Misura" : "Curva";
        return this.datiPod.get(key);
    }

    public String getTipoRettifica() {
        return this.tipoRettifica;
    }

    public String getPotMax() {
        Map<String, String> misura = this.getMisura();
        return misura == null ? null : misura.get("PotMax");
    }

    public String getMotivazione() {
        Map<String, String> misura = this.getMisura();
        return misura == null ? null : misura.get("Motivazione");
    }

    public String getTrattamento() {
        return this.getDatiPdo().get("Trattamento");
    }

    public String getTensione() {
        return this.getDatiPdo().get("Tensione");
    }

    public String getForfait() {
        return this.getDatiPdo().get("Forfait");
    }

    public String getGruppoMisura() {
        return this.getDatiPdo().get("GruppoMis");
    }

    public String getKaString() {
        return this.getDatiPdo().get("Ka");
    }

    public String getKrString() {
        return this.getDatiPdo().get("Kr");
    }

    public String getKpString() {
        return this.getDatiPdo().get("Kp");
    }

    public double getKa() {
        return RilData.getK(this.getKaString());
    }

    public double getKr() {
        return RilData.getK(this.getKrString());
    }

    public double getKp() {
        return RilData.getK(this.getKpString());
    }

    private static double getK(String value) {
        return StringUtils.isEmpty(value) ? 0.0 : Double.parseDouble(value);
    }
}

