/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Pdo2GRDispatcher;
import biz.elabor.prebilling.model.misure.PeriodoDispatcher;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.SospetteDispatcher;
import biz.elabor.prebilling.model.misure.TecnicheDispatcher;
import biz.elabor.prebilling.model.misure.TipoDispatcher;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class MappaMisureAzienda
extends LinkedHashMap<String, MisureAzienda>
implements Iterable<MisureAzienda> {
    private static final long serialVersionUID = 1L;
    public static final List<String> FLUSSI_ATTIVAZIONE = Arrays.asList("AV", "AVR", "AV2G", "AVR2G");
    public static final List<String> FLUSSI_VARIAZIONE_POTENZA = Arrays.asList("VP", "VPR", "VP2G", "VPR2G");
    private final TalkManager talkManager;
    private final Reseller reseller;
    private final TipoEstrazione tipo;
    private final MisureDao misureDao;
    private final DateFormat dateFormat;

    public MappaMisureAzienda(TipoEstrazione tipo, Reseller reseller, TalkManager talkManager, MisureDao misureDao) {
        this.tipo = tipo;
        this.reseller = reseller;
        this.talkManager = talkManager;
        this.misureDao = misureDao;
        this.dateFormat = StrategyHelper.getDataFormat();
    }

    private boolean ignore(Pod pod) {
        String azienda = pod.getAzienda();
        return !this.reseller.match(azienda) || !this.tipo.match(false);
    }

    @Override
    public Iterator<MisureAzienda> iterator() {
        return this.values().iterator();
    }

    public boolean containsPod(String codicePod) {
        boolean value = false;
        Iterator<MisureAzienda> iterator = this.iterator();
        while (!value && iterator.hasNext()) {
            MisureAzienda misureAzienda = iterator.next();
            value = misureAzienda.contains(codicePod);
        }
        return value;
    }

    public void addSwitchout(Pod pod, Mno mno) throws DataNotFoundException {
        MisureAzienda misureAzienda = this.getMisureAzienda(pod);
        misureAzienda.addSwitchout(pod, mno);
    }

    public void addSmis(Pod pod, ExtMno smis) {
        MisureAzienda misure = this.getMisureAzienda(pod);
        misure.addSmis(pod, smis);
    }

    public void addMisurePeriodo(ServiceStatus status, List<Mno> mnos, PodMap pods, SafeListMap<String, Pdo> pdos) {
        PeriodoDispatcher dispatcher = new PeriodoDispatcher();
        this.addMisure(status, mnos, pods, pdos, dispatcher);
    }

    public void addPdo2GR(ServiceStatus status, List<Mno> mnos, PodMap pods, SafeListMap<String, Pdo> pdos) {
        Pdo2GRDispatcher dispatcher = new Pdo2GRDispatcher();
        this.addMisure(status, mnos, pods, pdos, dispatcher);
    }

    public void addMisureTecniche(ServiceStatus status, List<Mno> mnos, PodMap pods, SafeListMap<String, Pdo> pdos) {
        TecnicheDispatcher dispatcher = new TecnicheDispatcher();
        this.addMisure(status, mnos, pods, pdos, dispatcher);
    }

    public void addMisureSospette(ServiceStatus status, List<Mno> mnos, PodMap pods, SafeListMap<String, Pdo> pdos) {
        SospetteDispatcher dispatcher = new SospetteDispatcher();
        this.addMisure(status, mnos, pods, pdos, dispatcher);
    }

    private void addMisure(ServiceStatus status, List<? extends Mno> mnos, PodMap pods, SafeListMap<String, Pdo> pdos, TipoDispatcher tipoDispatcher) {
        Class<?> myClass = this.getClass();
        String className = myClass.getSimpleName();
        for (Mno mno : mnos) {
            String codicePod = mno.getCodicePod();
            PrebillingContext.setContext(className, "codice pod: " + codicePod);
            String flusso = mno.getCodiceFlusso();
            if (FLUSSI_ATTIVAZIONE.contains(flusso) || FLUSSI_VARIAZIONE_POTENZA.contains(flusso)) {
                status.addMisuraPrestazione(codicePod, mno);
                continue;
            }
            this.addMisura(status, mno, pods, pdos, tipoDispatcher);
        }
    }

    private void addMisura(ServiceStatus status, Mno mno, PodMap pods, SafeListMap<String, Pdo> pdos, TipoDispatcher dispatcher) {
        block9: {
            String codicePod = mno.getCodicePod();
            try {
                Pod pod = pods.get(codicePod);
                String azienda = pod.getAzienda();
                mno.setCdaziend(azienda);
                StrategyHelper.handleKX(pod, mno);
                Date dataMisura = mno.getDataMisura();
                if (dataMisura.before(pod.getInizioConsumi())) {
                    if (this.talkManager != null) {
                        Warning sentence = new Warning("acquisizione.letture", "date.beforeStart");
                        sentence.addParam(codicePod);
                        sentence.addParam(this.dateFormat.format(dataMisura));
                        sentence.setCss("alert-danger");
                        this.talkManager.addSentence(sentence);
                        String descrizione = this.talkManager.getMessage(sentence);
                        MnoResult result = new MnoResult(mno, ErroriElaborazione.DATA_BEFORESTART, descrizione);
                        dispatcher.addEscluso(status, result);
                    }
                } else {
                    ErroriElaborazione errore = MappaMisureAzienda.checkForfettari(pod, mno);
                    if (errore == ErroriElaborazione.OK) {
                        if (!this.ignore(pod)) {
                            this.addMisura(dispatcher, pod, mno, pdos, status);
                        }
                    } else if (this.talkManager != null) {
                        String message = errore.getMessage();
                        Warning sentence = new Warning("acquisizione.letture", message);
                        sentence.addParam(codicePod);
                        sentence.addParam(this.dateFormat.format(dataMisura));
                        sentence.setCss("alert-danger");
                        this.talkManager.addSentence(sentence);
                        String descrizione = this.talkManager.getMessage(sentence);
                        MnoResult result = new MnoResult(mno, errore, descrizione);
                        dispatcher.addSospeso(status, result);
                    }
                }
            }
            catch (DataNotFoundException e2) {
                if (this.talkManager == null) break block9;
                String message = e2.getMessage();
                String key = e2.getKey();
                Warning sentence = new Warning("acquisizione.letture", message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(e2);
                MnoResult result = new MnoResult(mno, errore, descrizione);
                dispatcher.addSospeso(status, result);
            }
        }
    }

    private static ErroriElaborazione checkForfettari(Pod pod, Mno mno) {
        ErroriElaborazione errore = ErroriElaborazione.OK;
        if (mno.isForfait()) {
            Date dataMisura = mno.getDataMisura();
            Date dataMax = pod.getDataMax();
            Date dataInizioPeriodo = mno.getDataInizioPeriodo();
            Date dataCheck = CalendarTools.previousDay(dataInizioPeriodo);
            String eaf1 = mno.getTrattamento().isMono() ? mno.getEAM() : mno.getEAF1();
            String eaf2 = mno.getEAF2();
            String eaf3 = mno.getEAF3();
            if (MappaMisureAzienda.isEmpty(eaf1) || !MappaMisureAzienda.isEmpty(eaf2) || !MappaMisureAzienda.isEmpty(eaf3)) {
                errore = ErroriElaborazione.FORFETTARIO_SCARTATO_MISURE;
            } else if (!pod.isAzzeramento(dataMisura)) {
                errore = ErroriElaborazione.FORFETTARIO_SCARTATO_CONTATORE;
            } else if (!dataCheck.equals(dataMax)) {
                errore = ErroriElaborazione.FORFETTARIO_SCARTATO_DATA;
            }
        }
        return errore;
    }

    private static boolean isEmpty(String value) {
        return value == null;
    }

    private void addMisura(TipoDispatcher dispatcher, Pod pod, Mno mno, SafeListMap<String, Pdo> pdos, ServiceStatus status) {
        String codicePod = pod.getCodice();
        if (status.checkRiconfigurazione2GR(codicePod)) {
            if (MappaMisureAzienda.checkTransizioneRno(mno, pod)) {
                MisuraMno misuraMno = new MisuraMno(pod, mno);
                status.addRiconfigurazioneMno(misuraMno);
            } else {
                Date dataMisuraPrestazione;
                Date dataMisura = mno.getDataMisura();
                if (dispatcher.checkDataPrestazione(dataMisura, dataMisuraPrestazione = this.getDataMisuraPrestazione(pod))) {
                    if (pod.isAzzeramento(dataMisura) && !mno.isForfait()) {
                        if (pod.isNuovaFornitura()) {
                            this.nuovaFornitura(mno, dispatcher, status);
                        } else {
                            List<Pdo> pdo = MappaMisureAzienda.getPdo(pdos, codicePod);
                            if (MappaMisureAzienda.checkTransizionePdo(mno, pdo)) {
                                this.transizionePdo(mno, pdo, status);
                                status.addRiconfigurazionePod2GR(mno);
                            } else if (mno.getCodiceFlusso().equals("RNO2G")) {
                                Pdo2GRDispatcher dispatcher2G = new Pdo2GRDispatcher();
                                this.addMisura(dispatcher2G, pod, mno, status);
                            } else {
                                this.podOrario(mno, pdo, status);
                            }
                        }
                    } else if (pod.isAttesaSnm()) {
                        this.attesaSnm(mno, status);
                    } else {
                        this.addMisura(dispatcher, pod, mno, status);
                    }
                } else if (this.talkManager != null) {
                    Warning sentence = new Warning("acquisizione.letture", "blocked.pdo");
                    sentence.addParam(codicePod);
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    MnoResult result = new MnoResult(mno, ErroriElaborazione.BLOCKED_PDO, descrizione);
                    dispatcher.addSospeso(status, result);
                }
            }
        }
    }

    public Date getDataMisuraPrestazione(Pod pod) {
        Date dataMisuraPrestazione;
        String azienda = pod.getAzienda();
        MisureAzienda misureAzienda = (MisureAzienda)this.get(azienda);
        if (misureAzienda == null) {
            dataMisuraPrestazione = CalendarTools.getEndOfTime();
        } else {
            MnoPod misurePod = misureAzienda.getMisure(pod);
            Collection<ExtMno> smis = misurePod.getSmis();
            dataMisuraPrestazione = MappaMisureAzienda.getDataMisuraPrestazione(smis);
        }
        return dataMisuraPrestazione;
    }

    private static Date getDataMisuraPrestazione(Collection<ExtMno> smis) {
        return smis.isEmpty() ? CalendarTools.getEndOfTime() : smis.iterator().next().getMno().getDataMisura();
    }

    private static boolean checkTransizioneRno(Mno mno, Pod pod) {
        String codiceFlusso = mno.getCodiceFlusso();
        Date dataMisura = mno.getDataMisura();
        Date dataMax = pod.getDataMax();
        Date dataNext = CalendarTools.nextDay(dataMisura);
        Date dataInst = pod.getDataInst(dataNext);
        double kaMno = mno.getKa().doubleValue();
        double krMno = mno.getKr().doubleValue();
        double kpMno = mno.getKp().doubleValue();
        double kaPod = pod.getKa(dataMisura);
        double krPod = pod.getKr(dataMisura);
        double kpPod = pod.getKp(dataMisura);
        boolean podNuovo = pod.isPodNuovo(dataNext);
        return codiceFlusso.startsWith("RNO") && dataMisura.equals(dataMax) && dataNext.equals(dataInst) && (kaMno != kaPod || krMno != krPod || kpMno != kpPod) && podNuovo;
    }

    private void transizionePdo(Mno mno, List<Pdo> pdoList, ServiceStatus status) {
        String codicePod = mno.getCodicePod();
        Date dataMisura = mno.getDataMisura();
        ElaborCalendar calendar = new ElaborCalendar(dataMisura);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        try {
            Pdo pdo = this.misureDao.getPdoConsolidato(codicePod, anno, mese, dataMisura);
            if (pdoList.isEmpty()) {
                status.addPdo(pdo);
            } else {
                RilMese rilMese = pdo.getRilMese();
                Set<String> id = pdo.getId();
                pdo = pdoList.get(pdoList.size() - 1);
                pdo.setRilMese(rilMese);
                pdo.setId(id);
            }
        }
        catch (DataNotFoundException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void addMisura(TipoDispatcher dispatcher, Pod pod, Mno mno, ServiceStatus status) {
        MisureAzienda misureAzienda = this.getMisureAzienda(pod);
        Mno obsoleto = MappaMisureAzienda.checkRettificaObsoleta(pod, mno) ? mno : dispatcher.addMisura(misureAzienda, pod, mno);
        if (obsoleto != null && this.talkManager != null) {
            Warning sentence = new Warning("acquisizione.letture", "obsoleto");
            String codicePod = pod.getCodice();
            sentence.addParam(codicePod);
            sentence.addParam(this.dateFormat.format(mno.getDataMisura()));
            sentence.setCss("alert-warning");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(obsoleto, ErroriElaborazione.OBSOLETO, descrizione);
            dispatcher.addObsoleto(status, result);
        }
    }

    private static boolean checkRettificaObsoleta(Pod pod, Mno mno) {
        Date dataMax = pod.getDataMax();
        Date dataMisura = mno.getDataMisura();
        Date expectedStartDate = CalendarTools.nextDay(dataMisura);
        Date dataInizioContratto = pod.getDataInizio(expectedStartDate);
        Date dataInst = pod.getDataInst(expectedStartDate);
        boolean stimata = mno.isStimata();
        String codiceFlusso = mno.getCodiceFlusso().toUpperCase();
        String ccLettur = pod.getCcLettur(expectedStartDate);
        return dataMisura.before(dataMax) && !StrategyHelper.MOROSITA.contains(codiceFlusso) && !CalendarTools.isFineMese(dataMisura) && !expectedStartDate.equals(dataInizioContratto) && (!"11".equals(ccLettur) || !dataInst.equals(expectedStartDate)) || stimata && !dataMisura.after(dataMax);
    }

    private void attesaSnm(Mno mno, ServiceStatus status) {
        if (this.talkManager != null) {
            String codicePod = mno.getCodicePod();
            Warning sentence = new Warning("acquisizione.letture", "attesa.snm");
            sentence.addParam(codicePod);
            sentence.setCss("alert-warning");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, ErroriElaborazione.INATTESA_SNM, descrizione);
            if (mno.getCodiceFlusso().toLowerCase().contains("pdo2g")) {
                status.addPdo2GRSospeso(result);
            } else {
                status.addPnoSospeso(result);
            }
        }
    }

    private static List<Pdo> getPdo(SafeListMap<String, Pdo> pdos, String codicePod) {
        ArrayList<Pdo> pdo;
        try {
            pdo = (ArrayList<Pdo>)pdos.get(codicePod);
        }
        catch (DataNotFoundException exc) {
            pdo = new ArrayList<Pdo>();
        }
        return pdo;
    }

    private void podOrario(Mno mno, List<Pdo> pdo, ServiceStatus status) {
        if (this.talkManager != null) {
            String codicePod = mno.getCodicePod();
            String message = pdo.isEmpty() ? "pod.orario" : "pod.orarioConTutteMisure";
            Warning sentence = new Warning("acquisizione.letture", message);
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            status.addPnoSospeso(new MnoResult(mno, ErroriElaborazione.POD_ORARIO, descrizione));
        }
    }

    private void nuovaFornitura(Mno mno, TipoDispatcher dispatcher, ServiceStatus status) {
        if (this.talkManager != null) {
            MnoResult result = new MnoResult(mno, ErroriElaborazione.NUOVA_FORNITURA_ORARIA, "nuova fornitura oraria");
            dispatcher.addSospeso(status, result);
            Warning sentence = new Warning("acquisizione.letture", "nuova.fornituraoraria");
            String codicePod = mno.getCodicePod();
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
        }
    }

    private static boolean checkTransizionePdo(Mno mno, List<Pdo> pdo) {
        boolean transizione;
        String codiceFlusso = mno.getCodiceFlusso();
        String regime = mno.getRegime();
        if ((codiceFlusso.equals("PDO2G") || codiceFlusso.equals("RFO2G")) && regime.equals("R")) {
            if (pdo.isEmpty()) {
                transizione = true;
            } else {
                int lastIndex = pdo.size() - 1;
                Pdo lastPdo = pdo.get(lastIndex);
                String lastRegime = lastPdo.getRegime();
                transizione = lastRegime.equals("NR");
            }
        } else {
            transizione = false;
        }
        return transizione;
    }

    private MisureAzienda getMisureAzienda(Pod pod) {
        String azienda = pod.getAzienda();
        return this.getMisureAzienda(azienda);
    }

    private MisureAzienda getMisureAzienda(String azienda) {
        MisureAzienda misureAzienda = (MisureAzienda)this.get(azienda);
        if (misureAzienda == null) {
            misureAzienda = new MisureAzienda(azienda);
            this.put(azienda, misureAzienda);
        }
        return misureAzienda;
    }
}

