/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.TipoLettura;
import biz.elabor.prebilling.services.tariffe.LetturaSegnanti;
import java.util.Date;

public class Lettura
implements LetturaSegnanti {
    private final String codicePod;
    private final Date dataMisura;
    private final double[] attiva;
    private final TipoLettura tipoLettura;
    private final String pivaDistributore;
    private final String matricolaAtt;
    private final Double ka;
    private final String codiceFlusso;
    private final int idRiferimento;

    public Lettura(int idRiferimento, String codicePod, Date dataMisura, double[] attiva, TipoLettura tipoLettura, String pivaDistributore, String matricolaAtt, double ka, String codiceFlusso) {
        this.idRiferimento = idRiferimento;
        this.codicePod = codicePod;
        this.dataMisura = dataMisura;
        this.attiva = attiva;
        this.tipoLettura = tipoLettura;
        this.pivaDistributore = pivaDistributore;
        this.matricolaAtt = matricolaAtt;
        this.ka = ka;
        this.codiceFlusso = codiceFlusso;
    }

    public String getCodicePod() {
        return this.codicePod;
    }

    @Override
    public Date getDataMisura() {
        return this.dataMisura;
    }

    public TipoLettura getTipoLettura() {
        return this.tipoLettura;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public boolean isSmisMontaggio() {
        return this.tipoLettura.equals((Object)TipoLettura.MONTAGGIO);
    }

    @Override
    public String getMatricolaAtt() {
        return this.matricolaAtt;
    }

    @Override
    public double getAttiva(FasciaOraria fascia) {
        return this.attiva[fascia.ordinal()];
    }

    @Override
    public double[] getAttiva() {
        return this.attiva;
    }

    @Override
    public Number getKa() {
        return this.ka;
    }

    @Override
    public String getCodiceFlusso() {
        return this.codiceFlusso;
    }

    @Override
    public boolean isStimata() {
        return false;
    }

    public int getIdRiferimento() {
        return this.idRiferimento;
    }
}

