/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.indici;

import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilQuarto;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class CurvaIndiciGiornaliera
extends ArrayList<IndiceOrario> {
    private static final long serialVersionUID = 1L;
    private Date data;

    public CurvaIndiciGiornaliera(Date data) {
        this.data = data;
    }

    public Date getData() {
        return this.data;
    }

    public void multiply(RilGiorno rilGiorno) throws InvalidCurvaIndiciException, InvalidCurvaRilevazioniException {
        Iterator cIterator = this.iterator();
        Iterator rIterator = rilGiorno.iterator();
        while (cIterator.hasNext() && rIterator.hasNext()) {
            double attiva = 0.0;
            int index = 0;
            while (index < 4) {
                RilQuarto rQuarto = (RilQuarto)rIterator.next();
                attiva += MisureHelper.getAttiva(rQuarto);
                ++index;
            }
            IndiceOrario cOra = (IndiceOrario)cIterator.next();
            cOra.multiply(attiva);
        }
        if (cIterator.hasNext()) {
            throw new InvalidCurvaIndiciException();
        }
        if (rIterator.hasNext()) {
            Date date = rilGiorno.getDate();
            throw new InvalidCurvaRilevazioniException(date);
        }
    }
}

