/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.giada;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class SmartPodMap
implements PodMap {
    private final int anno;
    private final Month mese;
    private final String defaultOnlyPod;
    private final String cclettur;
    private final int maxRows;
    private final GiadaDao giadaDao;
    private DefaultPodMap podMap;
    private String firstPod;
    private String lastPod;

    public SmartPodMap(int anno, Month mese, String onlyPod, PrebillingConfiguration configuration, GiadaDao giadaDao) {
        this.anno = anno;
        this.mese = mese;
        this.defaultOnlyPod = onlyPod;
        this.cclettur = configuration.getCclettur();
        this.maxRows = configuration.getMaxRows();
        this.giadaDao = giadaDao;
        this.firstPod = "";
        this.lastPod = "";
        this.podMap = new DefaultPodMap();
    }

    @Override
    public Pod get(String codicePod) throws DataNotFoundException {
        return this.getOnly(codicePod, this.defaultOnlyPod);
    }

    @Override
    public Pod getOnly(String codicePod) throws DataNotFoundException {
        return this.getOnly(codicePod, codicePod);
    }

    private Pod getOnly(String codicePod, String onlyPod) throws DataNotFoundException {
        if (codicePod.compareTo(this.firstPod) < 0 || codicePod.compareTo(this.lastPod) > 0) {
            String startPod = this.lastPod.isEmpty() ? " " : codicePod;
            List<RigaPod> righePod = this.giadaDao.getRighePod(this.anno, this.mese, this.cclettur, startPod, onlyPod, this.maxRows);
            Date endOfTime = CalendarTools.getEndOfTime();
            righePod.add(new RigaPod("zzzz", null, false, 0, new Date(0L), null, null, null, false, false, false, null, false, null, null, "dispa", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "0", 1.0, 1.0, 1.0, false, false, endOfTime, null, null));
            this.lastPod = StrategyHelper.fillPodMap(righePod, this.anno, this.mese, this.podMap);
        }
        return this.podMap.get(codicePod);
    }

    @Override
    public Pod get(String dispatcher, String codicePod) throws DataNotFoundException {
        this.get(codicePod);
        return this.podMap.get(dispatcher, codicePod);
    }
}

