/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.giada;

import biz.elabor.prebilling.model.giada.AttivaExtractor;
import biz.elabor.prebilling.model.giada.AzzeramentoExtractor;
import biz.elabor.prebilling.model.giada.CcLetturExtractor;
import biz.elabor.prebilling.model.giada.CdConMagExtractor;
import biz.elabor.prebilling.model.giada.DataInizioExtractor;
import biz.elabor.prebilling.model.giada.DataInstExtractor;
import biz.elabor.prebilling.model.giada.KaExtractor;
import biz.elabor.prebilling.model.giada.KpExtractor;
import biz.elabor.prebilling.model.giada.KrExtractor;
import biz.elabor.prebilling.model.giada.MatricolaExtractor;
import biz.elabor.prebilling.model.giada.PivaDispatcherExtractor;
import biz.elabor.prebilling.model.giada.PivaDistributoreExtractor;
import biz.elabor.prebilling.model.giada.PodInstance;
import biz.elabor.prebilling.model.giada.PodNuovoExtractor;
import biz.elabor.prebilling.model.giada.PotenzaExtractor;
import biz.elabor.prebilling.model.giada.ReattivaExtractor;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.extractors.KeyExtractor;

public class Pod
implements KeyRecord<String> {
    private static final KeyExtractor<Boolean, PodInstance> ATTIVA_EXTRACTOR = new AttivaExtractor();
    private static final KeyExtractor<Boolean, PodInstance> REATTIVA_EXTRACTOR = new ReattivaExtractor();
    private static final KeyExtractor<Boolean, PodInstance> POTENZA_EXTRACTOR = new PotenzaExtractor();
    private static final KeyExtractor<Boolean, PodInstance> AZZERAMENTO_EXTRACTOR = new AzzeramentoExtractor();
    private static final KeyExtractor<Double, PodInstance> KA_EXTRACTOR = new KaExtractor();
    private static final KeyExtractor<Double, PodInstance> KR_EXTRACTOR = new KrExtractor();
    private static final KeyExtractor<Double, PodInstance> KP_EXTRACTOR = new KpExtractor();
    private static final KeyExtractor<String, PodInstance> CDCONMAG_EXTRACTOR = new CdConMagExtractor();
    private static final KeyExtractor<Boolean, PodInstance> POD_NUOVO_EXTRACTOR = new PodNuovoExtractor();
    private final String codice;
    private final boolean orario;
    private final int tensione;
    private final String azienda;
    private final Date inizioConsumi;
    private final Date fine;
    private final boolean attiva;
    private final boolean reattiva;
    private final boolean potenza;
    private final Date dataMax;
    private final List<PodInstance> instances;
    private final List<SpecificaTecnica> specifiche;
    private final String statoUtenza;
    private final boolean allineato;
    private final boolean attesaSnm;
    private final String dispatcher;
    private final String tarDis;
    private final double potImp;
    private final double potDisponibile;
    private final boolean nuovaFornitura;
    private final double attF1;
    private final double attF2;
    private final double attF3;
    private final double reaF1;
    private final double reaF2;
    private final double reaF3;
    private final String codiceOfferta;
    private Date switchout;
    private final double kA;
    private final double kR;
    private final double kP;
    private final boolean commerciale;
    private final boolean azzcon;
    private final boolean podNuovo;
    private final String numatric;
    private Date inizioConvenzionale;
    private final String cdcomist;

    public Pod(String codice, boolean orario, int tensione, String azienda, Date inizioConsumi, Date fine, boolean attiva, boolean reattiva, boolean potenza, Date dataMax, String statoUtenza, String dispatcher, boolean allineato, Date switchout, boolean attesaSnm, String tarDis, double potImp, double potDisponibile, boolean nuovaFornitura, double attF1, double attF2, double attF3, double reaF1, double reaF2, double reaF3, String codiceOfferta, double kA, double kR, double kP, boolean commerciale, String numatric) {
        this(codice, orario, tensione, azienda, inizioConsumi, fine, attiva, reattiva, potenza, dataMax, statoUtenza, dispatcher, allineato, switchout, attesaSnm, tarDis, potImp, potDisponibile, nuovaFornitura, attF1, attF2, attF3, reaF1, reaF2, reaF3, codiceOfferta, kA, kR, kP, commerciale, numatric, false, null, new ArrayList<PodInstance>());
    }

    public Pod(String codice, boolean orario, int tensione, String azienda, Date inizioConsumi, Date fine, boolean attiva, boolean reattiva, boolean potenza, Date dataMax, String statoUtenza, String dispatcher, boolean allineato, Date switchout, boolean attesaSnm, String tarDis, double potImp, double potDisponibile, boolean nuovaFornitura, double attF1, double attF2, double attF3, double reaF1, double reaF2, double reaF3, String codiceOfferta, double kA, double kR, double kP, boolean commerciale, String numatric, boolean podNuovo, String cdcomist, List<PodInstance> instances) {
        this.podNuovo = podNuovo;
        this.codice = codice;
        this.orario = orario;
        this.tensione = tensione;
        this.azienda = azienda;
        this.inizioConsumi = inizioConsumi;
        this.inizioConvenzionale = inizioConsumi;
        this.fine = fine;
        this.attiva = attiva;
        this.reattiva = reattiva;
        this.potenza = potenza;
        this.dataMax = dataMax;
        this.instances = instances;
        this.specifiche = new ArrayList<SpecificaTecnica>();
        this.statoUtenza = statoUtenza;
        this.dispatcher = dispatcher;
        this.allineato = allineato;
        this.switchout = switchout;
        this.attesaSnm = attesaSnm;
        this.tarDis = tarDis;
        this.potImp = potImp;
        this.potDisponibile = potDisponibile;
        this.nuovaFornitura = nuovaFornitura;
        this.attF1 = attF1;
        this.attF2 = attF2;
        this.attF3 = attF3;
        this.reaF1 = reaF1;
        this.reaF2 = reaF2;
        this.reaF3 = reaF3;
        this.codiceOfferta = codiceOfferta;
        this.kA = kA;
        this.kR = kR;
        this.kP = kP;
        this.commerciale = commerciale;
        this.azzcon = orario;
        this.numatric = numatric;
        this.cdcomist = cdcomist;
    }

    @Override
    public String getKey() {
        return this.getCodice();
    }

    public void addInstance(PodInstance instance) {
        this.instances.add(instance);
    }

    public void addSpecificaTecnica(SpecificaTecnica specifica) {
        this.specifiche.add(specifica);
    }

    public List<SpecificaTecnica> getSpecificheTecniche() {
        return this.specifiche;
    }

    public String getCodice() {
        return this.codice;
    }

    public boolean isOrario() {
        return this.orario;
    }

    public int getTensione() {
        return this.tensione;
    }

    public String getAzienda() {
        return this.azienda;
    }

    public Date getInizioConsumi() {
        return this.inizioConsumi;
    }

    public Date getInizioConvenzionale() {
        return this.inizioConvenzionale;
    }

    public void setInizioConvenzionale(Date inizioConvenzionale) {
        this.inizioConvenzionale = inizioConvenzionale;
    }

    public Date getFine() {
        return this.fine;
    }

    public boolean isPodNuovo(Date dataMisura) {
        return this.isMisura(this.podNuovo, dataMisura, POD_NUOVO_EXTRACTOR);
    }

    public boolean isMisuraAttiva(Date dataMisura) {
        return this.isMisura(this.attiva, dataMisura, ATTIVA_EXTRACTOR);
    }

    public boolean isMisuraReattiva(Date dataMisura) {
        return this.isMisura(this.reattiva, dataMisura, REATTIVA_EXTRACTOR);
    }

    public boolean isMisuraPotenza(Date dataMisura) {
        return this.isMisura(this.potenza, dataMisura, POTENZA_EXTRACTOR);
    }

    public boolean hasAzzeramento(Date fromDate) {
        boolean value = false;
        for (PodInstance instance : this.instances) {
            Date instanceDate = instance.getDate();
            value |= !instanceDate.before(fromDate) && instance.isAzzcon();
        }
        return value;
    }

    public boolean hasAzzeramento() {
        boolean value = false;
        for (PodInstance instance : this.instances) {
            value |= instance.isAzzcon();
        }
        return value;
    }

    public boolean isAzzeramento(Date dataMisura) {
        return this.isMisura(this.azzcon, dataMisura, AZZERAMENTO_EXTRACTOR);
    }

    public double getKa(Date dataMisura) {
        return this.getMisura((Object)this.kA, dataMisura, (KeyExtractor)KA_EXTRACTOR);
    }

    public double getKr(Date dataMisura) {
        return this.getMisura((Object)this.kR, dataMisura, (KeyExtractor)KR_EXTRACTOR);
    }

    public double getKp(Date dataMisura) {
        return this.getMisura((Object)this.kP, dataMisura, (KeyExtractor)KP_EXTRACTOR);
    }

    public String getCdConMag(Date dataMisura) {
        return this.getMisura("", dataMisura, CDCONMAG_EXTRACTOR);
    }

    public Date getDataMax() {
        return this.dataMax;
    }

    public boolean isActive() {
        return !this.statoUtenza.equals("C") && !this.statoUtenza.equals("P") && !this.statoUtenza.equals("Z");
    }

    public String getStatoUtenza() {
        return this.statoUtenza;
    }

    public boolean isAllineato() {
        return this.allineato;
    }

    public Date getSwitchout() {
        return this.switchout;
    }

    public boolean isAttesaSnm() {
        return this.attesaSnm;
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public String getTarDis() {
        return this.tarDis;
    }

    public double getPotImp() {
        return this.potImp;
    }

    public double getPotDisponibile() {
        return this.potDisponibile;
    }

    public boolean isNuovaFornitura() {
        return this.nuovaFornitura;
    }

    public boolean isFlMisbio() {
        return this.commerciale;
    }

    private boolean isMisura(boolean startValue, Date dataMisura, KeyExtractor<Boolean, PodInstance> extractor) {
        return this.getMisura(startValue, dataMisura, extractor);
    }

    private double getMisura(double startValue, Date dataMisura, KeyExtractor<Double, PodInstance> extractor) {
        return this.getMisura((Object)startValue, dataMisura, (KeyExtractor)extractor);
    }

    private <T> T getMisura(T startValue, Date dataMisura, KeyExtractor<T, PodInstance> extractor) {
        T value = startValue;
        for (PodInstance instance : this.instances) {
            Date date = instance.getDate();
            if (dataMisura.before(date)) break;
            value = extractor.getKey(instance);
        }
        return value;
    }

    public String getCcLettur(Date date) {
        CcLetturExtractor extractor = new CcLetturExtractor();
        return this.getMisura(null, date, extractor);
    }

    public String getMatricola(Date data) {
        MatricolaExtractor extractor = new MatricolaExtractor();
        return this.getMisura(this.numatric, data, extractor);
    }

    public Date getDataInst(Date data) {
        DataInstExtractor extractor = new DataInstExtractor();
        return this.getMisura(null, data, extractor);
    }

    public String getPivaDistributore(Date data) {
        PivaDistributoreExtractor extractor = new PivaDistributoreExtractor();
        return this.getMisura(null, data, extractor);
    }

    public String getPivaDispatcher(Date data) {
        PivaDispatcherExtractor extractor = new PivaDispatcherExtractor();
        return this.getMisura(null, data, extractor);
    }

    public Date getDataInizio(Date data) {
        DataInizioExtractor extractor = new DataInizioExtractor();
        return this.getMisura(null, data, extractor);
    }

    public double[] getLastAttiva() {
        return new double[]{this.attF1, this.attF2, this.attF3};
    }

    public double[] getLastReattiva() {
        return new double[]{this.reaF1, this.reaF2, this.reaF3};
    }

    public void setSwitchout(Date switchout) {
        this.switchout = switchout;
    }

    public String getMatricolaAttiva() {
        return this.numatric;
    }

    public Date getFirstDataInizio() {
        return this.instances.isEmpty() ? null : this.instances.get(0).getInizio();
    }

    public boolean isLastAzzeramento(Date date) {
        boolean lastAzzeramento = false;
        Iterator<PodInstance> iterator = this.instances.iterator();
        boolean azzeramento = false;
        while (iterator.hasNext()) {
            PodInstance instance = iterator.next();
            Date instanceDate = instance.getDate();
            if (date.before(instanceDate)) {
                if (!date.equals(CalendarTools.previousDay(instanceDate))) break;
                lastAzzeramento = azzeramento && !instance.isAzzcon();
                break;
            }
            azzeramento = instance.isAzzcon();
        }
        return lastAzzeramento;
    }

    public Date findDataMisuraPrestazione() {
        Date endOfTime;
        Date dataMisuraPrestazione = endOfTime = CalendarTools.getEndOfTime();
        Iterator<PodInstance> iterator = this.instances.iterator();
        while (dataMisuraPrestazione.equals(endOfTime) && iterator.hasNext()) {
            PodInstance current = iterator.next();
            boolean currNuovo = current.isPodNuovo();
            Date currDate = current.getDate();
            Date nextDate = CalendarTools.nextDay(this.dataMax);
            if (!currNuovo || !currDate.equals(nextDate)) continue;
            dataMisuraPrestazione = this.dataMax;
        }
        return dataMisuraPrestazione;
    }

    public String getCdcomist() {
        return this.cdcomist;
    }

    public String getCodiceOfferta(Date dataRilevazione) {
        String value = this.codiceOfferta;
        for (SpecificaTecnica specifica : this.specifiche) {
            Date data = specifica.getData();
            if (data.after(dataRilevazione)) continue;
            value = specifica.getCodiceOfferta();
        }
        return value;
    }

    public List<PodInstance> getInstances() {
        return this.instances;
    }
}

