/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.giada;

import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.RecordSafeMap;

public class DefaultPodMap
implements PodMap,
Iterable<Pod> {
    private RecordSafeMap<String, Pod> pods;
    private Map<String, Map<String, Pod>> podMap;

    public DefaultPodMap() {
        ErrorWrapper error = new ErrorWrapper("pod", ErroriElaborazione.POD_NOTFOUND);
        this.pods = new DefaultSafeMap<String, Pod>(error);
        this.podMap = new HashMap<String, Map<String, Pod>>();
    }

    @Override
    public Pod get(String codice) throws DataNotFoundException {
        return (Pod)this.pods.get(codice);
    }

    @Override
    public Pod getOnly(String codicePod) throws DataNotFoundException {
        return this.get(codicePod);
    }

    public void addWithDispatcher(Pod pod) {
        String dispatcher = pod.getDispatcher();
        Map<String, Pod> dispatcherPodMap = this.podMap.get(dispatcher);
        if (dispatcherPodMap == null) {
            dispatcherPodMap = new HashMap<String, Pod>();
            this.podMap.put(dispatcher, dispatcherPodMap);
        }
        String codicePod = pod.getCodice();
        dispatcherPodMap.put(codicePod, pod);
        this.add(pod);
    }

    @Override
    public Pod get(String dispatcher, String codicePod) throws DataNotFoundException {
        Map<String, Pod> dispatcherPodMap = this.podMap.get(dispatcher);
        if (dispatcherPodMap == null) {
            throw new DataNotFoundException("pod.notfound", codicePod, ErroriElaborazione.POD_NOTFOUND.ordinal());
        }
        Pod pod = dispatcherPodMap.get(codicePod);
        if (pod == null) {
            throw new DataNotFoundException("pod.notfound", codicePod, ErroriElaborazione.POD_NOTFOUND.ordinal());
        }
        return pod;
    }

    public void add(Pod pod) {
        this.pods.add(pod);
    }

    @Override
    public Iterator<Pod> iterator() {
        return this.pods.iterator();
    }

    public int size() {
        return this.pods.size();
    }
}

