/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.Generazione;
import biz.elabor.prebilling.dao.NullMockPrebillingConfiguration;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.homelinux.elabor.calendar.ElaborCalendar;

class CSVMockPrebillingConfiguration
extends NullMockPrebillingConfiguration {
    private boolean crm;
    private boolean trunking;
    private int nCifreAtt;
    private int nCifreRea;
    private int nCifrePot;

    CSVMockPrebillingConfiguration() {
    }

    @Override
    public int getCifreTariffe() {
        return 8;
    }

    @Override
    public String getDefaultAzienda() {
        return "default";
    }

    @Override
    public String getIdCalendarioArera() {
        return "1";
    }

    @Override
    public boolean isTrunking() {
        return this.trunking;
    }

    @Override
    public File getTmpFolder() {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("prebilling", "test");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        File tmpFolder = tmpFile.getParentFile();
        tmpFile.delete();
        return new File(tmpFolder, "prebilling");
    }

    public void setCrm(File folder) throws IOException {
        File file = new File(folder, "crm.txt");
        if (file.exists()) {
            String[] crmTxt = TextTestHelper.getLines(file);
            this.crm = Boolean.valueOf(crmTxt[0]);
        } else {
            this.crm = false;
        }
    }

    public void setTrunking(File folder) throws IOException {
        File file = new File(folder, "trunking.txt");
        if (file.exists()) {
            String[] txt = TextTestHelper.getLines(file);
            this.trunking = Boolean.parseBoolean(txt[0]);
            this.nCifreAtt = Integer.parseInt(txt[1]);
            this.nCifreRea = Integer.parseInt(txt[2]);
            this.nCifrePot = Integer.parseInt(txt[3]);
        } else {
            this.trunking = false;
        }
    }

    public static File getOutputFolder() {
        File testOutput = new File("test-output");
        testOutput.mkdirs();
        return testOutput;
    }

    @Override
    public File getMiddlewareOutputFolder() {
        File testOutput = CSVMockPrebillingConfiguration.getOutputFolder();
        File middlewaredir = new File(testOutput, "middleware");
        middlewaredir.mkdir();
        return middlewaredir;
    }

    @Override
    public File getDispatcherOutputFolder() {
        File testOutput = CSVMockPrebillingConfiguration.getOutputFolder();
        File folder = new File(testOutput, "dispatcher");
        folder.mkdirs();
        return folder;
    }

    @Override
    public File getResellerOutputFolder(String reseller) {
        File testOutput = CSVMockPrebillingConfiguration.getOutputFolder();
        return new File(testOutput, "reseller-" + reseller);
    }

    @Override
    public String getCdmeslet(String flusso, boolean stimata, boolean orario, boolean rettifica, boolean smis) {
        return stimata ? (orario ? "0050" : "0060") : "0000";
    }

    @Override
    public boolean hasCrm() {
        return this.crm;
    }

    @Override
    public double getCoeffUMPrezzi() {
        return 2.0;
    }

    @Override
    public Set<String> getTarDisDom() {
        String[] split = "D2,D3,TDR,TDNR,TDPC".split(",");
        return new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public String getVersion() {
        return "test";
    }

    @Override
    public int getLunghezzaMatricola() {
        return 20;
    }

    @Override
    public String getPivaDistributoreVoltureSpeciale() {
        return "pivaEnel";
    }

    @Override
    public int getNCifreAttiva(double k2) {
        return this.nCifreAtt;
    }

    @Override
    public int getNCifreReattiva(double k2) {
        return this.nCifreRea;
    }

    @Override
    public int getNCifrePotenza(double k2) {
        return this.nCifrePot;
    }

    @Override
    public CdConMag getCdConMag(String keyCdConMag) {
        CdConMag cdConMag = keyCdConMag.contentEquals("MONO") ? new CdConMag("MONO", "01001", Generazione.G1) : (keyCdConMag.contentEquals("CE") ? new CdConMag("CE", "01002", Generazione.G1) : (keyCdConMag.contentEquals("CEO") ? new CdConMag("CEO", "01009", Generazione.G1) : (keyCdConMag.contentEquals("GME") ? new CdConMag("GME", "01010", Generazione.G1) : new CdConMag("XXX", "00000", Generazione.G1))));
        return cdConMag;
    }

    @Override
    public int getXmlMaxSize() {
        return 10000000;
    }

    @Override
    public Date getToDay() {
        return new Date();
    }

    @Override
    public Date getTimeout(int ritardo) {
        Date toDay = this.getToDay();
        ElaborCalendar calendar = new ElaborCalendar(toDay);
        calendar.addGiorni(-ritardo);
        return calendar.getDate();
    }
}

