/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.ResultRecord;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.DatiMisura;
import biz.elabor.prebilling.dao.NullMockMisureDao;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.functest.CSVMockDaoHelper;
import biz.elabor.prebilling.functest.FunctionalTest;
import biz.elabor.prebilling.functest.MockCsvStatoPod;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.UpdateStatoPod;
import biz.elabor.prebilling.services.HelperTest;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.services.switched.SnfD65;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.volture.model.VolturaIV;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.web.xml.Partition;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;
import org.homelinux.elabor.structures.safe.SimpleSafeMap;
import org.homelinux.elabor.structures.setmap.BasicSetMap;
import org.homelinux.elabor.structures.setmap.SetMap;

class CSVMockMisureDao
extends NullMockMisureDao {
    private List<Pdo> pdos1G;
    private List<Pdo> pdos2G;
    private List<Mno> pnoPeriodo;
    private List<Mno> pno2GPeriodo;
    private List<Mno> pnoTecniche;
    private List<Mno> pnoSospette;
    private ListMapKey<String, Mno> smises;
    private SafeMap<String, Mno> pnosRiallineamento;
    private Misure<Mno> vnos;
    private List<Mno> snms;
    private List<Mno> snms2g;
    private List<Rno> rnos;
    private List<Snf> snfs;
    private List<Pdo> rfos;
    private List<Sof> sofs;
    private List<String[]> pdoStatus;
    private List<String[]> pnoStatus;
    private List<String[]> smisStatus;
    private List<String[]> snmStatus;
    private List<String[]> sofStatus;
    private List<String[]> snfStatus;
    private List<String[]> vnoStatus;
    private List<String[]> rnvStatus;
    private List<String[]> rsnStatus;
    private List<String[]> rfoStatus;
    private List<String[]> rnoStatus;
    private List<String[]> rowsStatoPod;
    private List<String[]> rowsUpdateStatoPod;
    private Map<String, StatoPod> statiPodIn;
    private List<Mno> vnosElaborati;
    private List<Mno2GE> snm2gEnergia;
    private List<Mno2GE> pno2gEnergia;
    private ListMapKey<String, Mno> rsnrnv;
    private List<Mno> rnv;
    private List<Mno> rsn;
    private Map<String, PraticaVolo> virtualPiv;
    private List<Mno> rnosXml;

    public CSVMockMisureDao(File folder, double mult) throws IOException, ParseException {
        this.pdos1G = CSVMockMisureDao.fillPdos(folder, "pdo.csv", TipoFlusso.PDO, "65", mult);
        this.pdos1G.addAll(CSVMockMisureDao.fillPdos(folder, "pdo-479.csv", TipoFlusso.PDO, "479", mult));
        this.pdos2G = CSVMockMisureDao.fillPdos(folder, "pdo-2g.csv", TipoFlusso.PDO2G, "65", mult);
        this.snms2g = FunctionalTest.loadMnos(folder, "snm-2g.csv", true, true, "SNM2G");
        this.pnoPeriodo = FunctionalTest.loadMnos(folder, "pno-periodo.csv", false, true, "PNO");
        this.pnoPeriodo.addAll(FunctionalTest.loadMnos(folder, "pno-periodo-479.csv", false, false, "PNO"));
        this.pno2GPeriodo = FunctionalTest.loadMnos(folder, "pno-2g.csv", true, true, "PNO2G");
        this.pno2gEnergia = FunctionalTest.loadPno2GEnergia(folder, "pno-2g-energia.csv");
        this.snm2gEnergia = FunctionalTest.loadPno2GEnergia(folder, "snm-2g-energia.csv");
        this.pnoTecniche = FunctionalTest.loadMnos(folder, "pno-tecniche.csv", false, true, "PNO");
        this.pnoSospette = FunctionalTest.loadMnos(folder, "pno-sospette.csv", false, true, "PNO");
        this.pnosRiallineamento = CSVMockMisureDao.loadMappaKey(folder, "pno-riallineamento.csv", false, true, "PNO");
        this.vnosElaborati = CSVMockMisureDao.loadMisure(folder, "vno.csv", false, true, "VNO");
        this.vnosElaborati.addAll(CSVMockMisureDao.loadMisure(folder, "vno-479.csv", false, false, "VNO"));
        this.vnos = CSVMockMisureDao.loadMisure(this.vnosElaborati);
        this.snms = FunctionalTest.loadMnos(folder, "snm.csv", false, true, "SNM");
        this.snms.addAll(FunctionalTest.loadMnos(folder, "snm-479.csv", false, false, "SNM"));
        this.rnos = FunctionalTest.loadRnos(folder, "rno-479.csv", false, false, "RNO");
        this.rnos.addAll(FunctionalTest.loadRnos(folder, "rno.csv", false, true, "RNO"));
        this.rnosXml = FunctionalTest.loadMnos(folder, "rno-479.csv", false, false, "RNO");
        this.rnosXml.addAll(FunctionalTest.loadMnos(folder, "rno.csv", false, true, "RNO"));
        List<Mno> smisList = FunctionalTest.loadMnos(folder, "smis.csv", true, true, "SMIS");
        this.smises = new DefaultListMapKey<String, Mno>();
        this.smises.addAll(smisList);
        this.rsn = FunctionalTest.loadMnos(folder, "rsn.csv", false, true, "RSN");
        this.rsn.addAll(FunctionalTest.loadMnos(folder, "rsn-479.csv", false, false, "RSN"));
        this.rnv = FunctionalTest.loadMnos(folder, "rnv.csv", false, true, "RNV");
        this.rnv.addAll(FunctionalTest.loadMnos(folder, "rnv-479.csv", false, false, "RNV"));
        this.rsnrnv = new DefaultListMapKey<String, Mno>();
        this.rsnrnv.addAll(this.rsn);
        this.rsnrnv.addAll(this.rnv);
        this.fillSnfs(folder);
        this.fillRfos(folder);
        this.fillSofs(folder);
        this.fillStatiPod(folder);
        this.pdoStatus = new ArrayList<String[]>();
        this.rfoStatus = new ArrayList<String[]>();
        this.rnoStatus = new ArrayList<String[]>();
        this.smisStatus = new ArrayList<String[]>();
        this.pnoStatus = new ArrayList<String[]>();
        this.snmStatus = new ArrayList<String[]>();
        this.sofStatus = new ArrayList<String[]>();
        this.snfStatus = new ArrayList<String[]>();
        this.vnoStatus = new ArrayList<String[]>();
        this.rnvStatus = new ArrayList<String[]>();
        this.rsnStatus = new ArrayList<String[]>();
        this.rowsStatoPod = new ArrayList<String[]>();
        this.rowsUpdateStatoPod = new ArrayList<String[]>();
        this.virtualPiv = new HashMap<String, PraticaVolo>();
        StructuresHelper.buildMap(this.virtualPiv, CSVMockDaoHelper.fillPiv(folder, "virtual-piv.csv"));
    }

    @Override
    public SetMap<Date, DatiMisura> getMesiRettifiche(int anno, Month mese, String onlyPod, Destinatari destinatari) {
        return new BasicSetMap<Date, DatiMisura>();
    }

    @Override
    public List<Pdo> getTestateTariffe(Destinatari destinatari, int anno, Month mese, int maxRows) {
        return new ArrayList<Pdo>();
    }

    @Override
    public Mno getVno(String codicePod, Date dataPrestazione) throws DataNotFoundException {
        throw new DataNotFoundException("");
    }

    @Override
    public ListMap<String, Pdo> getPdoTariffe(Destinatari destinatari, Set<String> podBatch, int anno, Month mese) {
        DefaultListMapKey<String, Pdo> podMap = new DefaultListMapKey<String, Pdo>();
        podMap.addAll(this.pdos1G);
        return podMap;
    }

    @Override
    public Mno getVno(Mno mno) {
        return mno;
    }

    @Override
    public Mno getSnm(Mno mno) {
        return mno;
    }

    @Override
    public Pdo getPdoConsolidato(String codicePod, int anno, Month mese, Date last) {
        RilMese rilMese = new RilMese(codicePod, anno, mese, null);
        return new Pdo(null, false, rilMese, null, null, codicePod, null, null, null, null, null, null, null);
    }

    @Override
    public Misure<Mno> getPdo2GRV(String filtroPod, Iterable<StatoMisure> stati) {
        return new Misure<Mno>("pdo2grv");
    }

    @Override
    public List<Mno> getPdo2GRXml(String azienda, TipoFlusso tipoFlusso, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition, TalkManager talkManager) {
        return new ArrayList<Mno>();
    }

    @Override
    public List<ElaborCalendar> getPnoMonths(String onlyPod, int anno, Month mese) {
        return new ArrayList<ElaborCalendar>();
    }

    @Override
    public List<ElaborCalendar> getPdoMonths(String onlyPod, int anno, Month mese) {
        return new ArrayList<ElaborCalendar>();
    }

    @Override
    public Snf getSnf(String codicePod, Date dataMisura, boolean unique) {
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        HashMap datiPdp = new HashMap();
        datiPod.put("DatiPdp", datiPdp);
        return new Snf("1", null, null, null, null, null, null, null, null, datiPod);
    }

    @Override
    public Pdo getPdo(String id, TalkManager talkManager) {
        return (this.pdos1G.isEmpty() ? this.pdos2G : this.pdos1G).get(0);
    }

    @Override
    public Mno getPdo2GRXml(String id, TalkManager talkManager) {
        Date date = CalendarTools.getDate(2020, Month.JULY, 10);
        Misura misura = PrebillingTestHelper.newMisura(date, false, 3);
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPod.put("DatiPdp", datiPdp);
        LinkedHashMap<String, String> datiMisura = new LinkedHashMap<String, String>();
        datiMisura.put("Raccolta", "P");
        datiMisura.put("TipoDato", "E");
        datiPod.put("Misura", datiMisura);
        return new Mno("1", null, null, misura, null, null, null, null, null, null, null, datiPod, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, false, null);
    }

    @Override
    public Mno getMno(String id) {
        List<Mno> mnos = !this.pnoPeriodo.isEmpty() ? this.pnoPeriodo : (!this.vnos.isEmpty() ? (List<Mno>)this.vnos.iterator().next() : (!this.rnv.isEmpty() ? this.rnv : this.pno2GPeriodo));
        return mnos.get(0);
    }

    @Override
    public List<Mno> getPdo2GRFinoMese(int anno, Month mese, String filtroPod, Iterable<StatoMisure> stati) {
        return new ArrayList<Mno>();
    }

    @Override
    public Mno2GE getPno2geaXml(String id) {
        return this.pno2gEnergia.get(0);
    }

    @Override
    public Mno2GE getPno2gerXml(String id) {
        return this.pno2gEnergia.get(0);
    }

    @Override
    public Map<String, PraticaVolo> getVirtualPiv() {
        return this.virtualPiv;
    }

    @Override
    public Snf getSnf(String id) {
        return this.snfs.get(0);
    }

    @Override
    public Sof getSof(String id) {
        return this.sofs.get(0);
    }

    @Override
    public List<Mno> getVnos(String codPratAtt) {
        ArrayList<Mno> vnoscpa = new ArrayList<Mno>();
        for (Mno vno : this.vnosElaborati) {
            String codPratAttVno = vno.getCodPratAtt();
            if (codPratAttVno == null || !codPratAttVno.equals(codPratAtt)) continue;
            vnoscpa.add(vno);
        }
        return vnoscpa;
    }

    @Override
    public ListMapKey<String, Mno> getSmis(String reseller, String filtroPod, Iterable<StatoMisure> stati) {
        return this.smises;
    }

    @Override
    public ListMapKey<String, Mno> getSmisXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod) {
        return this.smises;
    }

    @Override
    public StatoPod getStatoPodApertura(String servizio, String codicePrestazione, String codicePod, Date dataMisura, StatoPod tecStatoPod) throws DataNotFoundException {
        return this.getStatoPod(servizio, codicePod, dataMisura);
    }

    @Override
    public StatoPod getStatoPodChiusura(String servizio, String codicePrestazione, String codicePod, Date dataMisura, StatoPod tecStatoPod) throws DataNotFoundException {
        return this.getStatoPod(servizio, codicePod, dataMisura);
    }

    public List<String[]> getUpdateStatiPod() {
        return this.rowsUpdateStatoPod;
    }

    public List<String[]> getStatiPod() {
        return this.rowsStatoPod;
    }

    private static SafeMap<String, Mno> loadMappaKey(File folder, String fileName, boolean dueG, boolean delibera65, String flusso) throws IOException, ParseException {
        SimpleSafeMap<String, Mno> map = new SimpleSafeMap<String, Mno>(fileName);
        List<Mno> elements = FunctionalTest.loadMnos(folder, fileName, dueG, delibera65, flusso);
        map.addAll(elements);
        return map;
    }

    private void fillRfos(File folder) throws IOException {
        Pdo rfo;
        String[] row;
        CsvReader reader;
        this.rfos = new ArrayList<Pdo>();
        File file = new File(folder, "rfo.csv");
        if (file.exists()) {
            reader = new CsvReader(";");
            try {
                reader.setFile(file);
                row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    rfo = FunctionalTest.getRfo(row);
                    this.rfos.add(rfo);
                }
            }
            finally {
                reader.close();
            }
        }
        if ((file = new File(folder, "rfo-479.csv")).exists()) {
            reader = new CsvReader(";");
            try {
                reader.setFile(file);
                row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    rfo = FunctionalTest.getRfo479(row);
                    this.rfos.add(rfo);
                }
            }
            finally {
                reader.close();
            }
        }
    }

    private void fillSnfs(File folder) throws IOException {
        this.snfs = new ArrayList<Snf>();
        File file = new File(folder, "snf.csv");
        if (file.exists()) {
            CsvReader reader = new CsvReader(";");
            reader.setFile(file);
            String[] row = reader.getNextRow();
            while (reader.hasNext()) {
                row = reader.next();
                Snf snf = CSVMockMisureDao.getSnf(row);
                this.snfs.add(snf);
            }
            reader.close();
        }
    }

    private void fillStatiPod(File folder) throws IOException {
        this.statiPodIn = new HashMap<String, StatoPod>();
        File file = new File(folder, "stato-pod-in.csv");
        if (file.exists()) {
            CsvReader reader = new CsvReader(";");
            reader.setFile(file);
            String[] row = reader.getNextRow();
            while (reader.hasNext()) {
                row = reader.next();
                StatoPod stato = CSVMockMisureDao.buildStatoPod(row);
                String cpGestore = stato.getCpGestore();
                this.addStatoPodIn(stato, cpGestore);
                String cpUtente = stato.getCpUtente();
                this.addStatoPodIn(stato, cpUtente);
                String codicePod = stato.getPod();
                this.statiPodIn.put(codicePod, stato);
            }
            reader.close();
        }
    }

    private void addStatoPodIn(StatoPod stato, String codicePratica) {
        if (codicePratica != null && !codicePratica.isEmpty()) {
            this.statiPodIn.put(codicePratica, stato);
        }
    }

    private static StatoPod buildStatoPod(String[] row) {
        return new MockCsvStatoPod(row);
    }

    private void fillSofs(File folder) throws IOException {
        this.sofs = new ArrayList<Sof>();
        File file = new File(folder, "sof.csv");
        if (file.exists()) {
            CsvReader reader = new CsvReader(";");
            reader.setFile(file);
            String[] row = reader.getNextRow();
            while (reader.hasNext()) {
                row = reader.next();
                Sof sof = CSVMockMisureDao.getSof(row);
                this.sofs.add(sof);
            }
            reader.close();
        }
    }

    private static List<Mno> loadMisure(File folder, String fileName, boolean dueG, boolean delibera65, String flusso) throws IOException, ParseException {
        return FunctionalTest.loadMnos(folder, fileName, dueG, delibera65, flusso);
    }

    private static Misure<Mno> loadMisure(List<Mno> mnos) {
        Misure<Mno> misure = new Misure<Mno>("vno");
        for (Mno mno : mnos) {
            if (!mno.getStato().equals((Object)StatoMisure.VALIDATO)) continue;
            misure.add(mno);
        }
        return misure;
    }

    private static Snf getSnf(String[] row) {
        Date date = CalendarTools.getDate(2017, Month.AUGUST, 30);
        boolean cottimo = row.length >= 4 ? Boolean.parseBoolean(row[3]) : false;
        String codPratAtt = row.length >= 5 ? row[4].trim() : null;
        String azienda = row.length > 5 ? row[5].trim() : "reseller";
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "M");
        datiPdp.put("Tensione", "100");
        datiPdp.put("PotContrImp", "0");
        datiPdp.put("PotDisp", "10");
        datiPdp.put("Ka", "0");
        datiPdp.put("Kr", "1");
        datiPdp.put("Kp", "1");
        datiPdp.put("MatrAtt", "matratt");
        datiPdp.put("CifreAtt", "6");
        datiPdp.put("CifreRea", "6");
        datiPdp.put("CifrePot", "6");
        datiPdp.put("GruppoMis", cottimo ? "NO" : "");
        datiPdp.put("Forfait", "");
        datiPdp.put("CodiceTariffa", row[1].trim());
        datiPdp.put("ServizioTutela", row[2].trim());
        datiPod.put("DatiPdp", datiPdp);
        String codicePod = row[0].trim();
        return new Snf("1", codicePod, "pivautente", "pivadistributore", "dispatcher", date, codPratAtt, azienda, "nomeFile_R.xml", datiPod);
    }

    private static Sof getSof(String[] row) {
        String codPratAtt = row.length > 1 ? row[1].trim() : "0001";
        String azienda = row.length > 2 ? row[2].trim() : "reseller";
        String trattamento = row.length > 3 ? row[3].trim() : "O";
        Date date = CalendarTools.getDate(2017, Month.AUGUST, 30);
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", trattamento);
        datiPod.put("DatiPdp", datiPdp);
        datiPdp.put("Tensione", "1234");
        datiPdp.put("PotContrImp", "123");
        datiPdp.put("PotDisp", "132");
        datiPdp.put("CodiceTariffa", "codtar");
        datiPdp.put("ServizioTutela", "sertut");
        datiPdp.put("MatrAtt", "matratt");
        datiPdp.put("Ka", "1.0");
        datiPdp.put("Kr", "1.0");
        datiPdp.put("Kp", "1.0");
        datiPod.put("DatiPdp", datiPdp);
        String nomeFile = "nomeFile_R.xml";
        return new Sof("1", row[0], "pivautente", "pivadistributore", "dispatcher", codPratAtt, azienda, date, nomeFile, datiPod);
    }

    private static List<Pdo> fillPdos(File folder, String filename, TipoFlusso flusso, String delibera, double mult) throws IOException {
        ArrayList<Pdo> pdos = new ArrayList<Pdo>();
        File file = new File(folder, filename);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Pdo pdo = CSVMockMisureDao.getPdo(row, flusso, delibera, mult);
                    pdos.add(pdo);
                }
            }
        }
        return pdos;
    }

    private static Pdo getPdo(String[] row, TipoFlusso flusso, String delibera, double mult) {
        String codicePod = row[0];
        int anno = CSVMockDaoHelper.getInteger(row[1]);
        Month mese = CSVMockDaoHelper.getMonth(row[2]);
        int duplicate = row.length > 7 ? CSVMockDaoHelper.getInteger(row[7]) : 0;
        String matratt = row.length > 10 ? row[10].trim() : "pdomatr";
        String codiceFlusso = flusso.name();
        RilMese rilMese = CSVMockMisureDao.buildRilMese(codicePod, matratt, anno, mese, codiceFlusso, duplicate, mult);
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> dati = new LinkedHashMap<String, String>();
        dati.put("TipoDato", delibera.equals("65") ? "X" : "S");
        if (!delibera.equals("65")) {
            dati.put("Validato", "S");
            dati.put("Raccolta", "P");
            dati.put("PotMax", "123.456");
        }
        datiPod.put(flusso.is2G() ? "Misura" : "Curva", dati);
        dati = new LinkedHashMap();
        dati.put("Trattamento", "O");
        dati.put("Tensione", "400");
        dati.put("PotContrImp", "3.3");
        dati.put("PotDisp", "3");
        dati.put("MatrAtt", "matratt");
        dati.put("MatrRea", "matrrea");
        dati.put("MatrPot", "matrpot");
        datiPod.put("DatiPdp", dati);
        String codContrDisp = row[6].trim().isEmpty() ? "codcontrdisp" : row[6].trim();
        Date dataRilevazione = CalendarTools.getDate(2019, Month.JANUARY, 1);
        boolean stimata = CSVMockDaoHelper.getBoolean(row[3]);
        String codPratAtt = row.length > 8 ? row[8].trim() : null;
        String azienda = row.length > 9 ? row[9].trim() : "reseller";
        String nomeFile = row.length > 11 ? row[11].trim() : "nomeFile_R.xml";
        String regime = row.length > 11 ? CSVMockMisureDao.getRegime(nomeFile) : "R";
        String idTipoFlusso = "misura_oraria";
        return new Pdo("1", stimata, rilMese, row[4].trim(), row[5].trim(), codContrDisp, codPratAtt, azienda, datiPod, "tiporettifica", "motivazione", dataRilevazione, nomeFile, delibera, idTipoFlusso, regime, null, null);
    }

    private static String getRegime(String nomeFile) {
        String[] split = nomeFile.split("_");
        int lunghezza = split.length;
        return split[lunghezza - 1].replace(".xml", "");
    }

    private static RilMese buildRilMese(String codicePod, String matricola, int anno, Month mese, String codiceFlusso, int duplicate, double mult) {
        RilMese rilMese = new RilMese(codicePod, anno, mese, matricola);
        for (int day : new DaysOfMonthIterable(anno, mese)) {
            Date date = CalendarTools.getDate(anno, mese, day);
            RilGiorno rilGiorno = new RilGiorno(date);
            int index = 0;
            while (index < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(index, codiceFlusso, "", (double)index * mult, index, index, index);
                rilGiorno.add(rilQuarto);
                ++index;
            }
            rilMese.add(rilGiorno);
            if (day != duplicate) continue;
            rilMese.add(rilGiorno);
        }
        return rilMese;
    }

    @Override
    public Misure<Mno> getVnos(String filtroPod, Iterable<StatoMisure> stati) {
        return this.vnos;
    }

    @Override
    public List<Mno> getMnoXml(String azienda, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso tipo, String pod) {
        return this.vnosElaborati;
    }

    @Override
    public List<Pdo> getPdoXml(String azienda, TipoFlusso flusso, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, String regime, Partition partition, TalkManager talkManager) {
        return flusso.is2G() ? this.pdos2G : this.pdos1G;
    }

    @Override
    public List<Pdo> getPdoMese(int anno, Month mese, String filtroPod, String reseller, Iterable<StatoMisure> stati) {
        return this.pdos1G;
    }

    @Override
    public List<Pdo> getPdoFinoMese(int anno, Month mese, String reseller, String filtroPod, Iterable<StatoMisure> stati) {
        return this.pdos1G;
    }

    @Override
    public List<Mno> getSnmXml(String azienda, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod) {
        return flusso.is2G() ? this.snms2g : this.snms;
    }

    @Override
    public List<Mno> getPnoPeriodoXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod, Partition partition) {
        return flusso.is2G() ? this.pno2GPeriodo : this.pnoPeriodo;
    }

    @Override
    public List<Mno> getPnoPeriodo(int anno, Month mese, String filtroPod, Iterable<StatoMisure> stati) {
        return this.pnoPeriodo;
    }

    @Override
    public List<Mno> getPnoTecniche(int anno, Month mese, String filtroPod, Iterable<StatoMisure> stati) {
        return this.pnoTecniche;
    }

    @Override
    public List<Mno> getPnoSospette(int anno, Month mese, String filtroPod) {
        return this.pnoSospette;
    }

    @Override
    public List<Mno> getRnoXml(TipoFlusso flusso, String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod) {
        return this.rnosXml;
    }

    @Override
    public List<Rno> getRno(String azienda, String filtroPod) {
        return this.rnos;
    }

    @Override
    public SafeMap<String, Mno> getPnosRiallineamento(int anno, Month mese) {
        return this.pnosRiallineamento;
    }

    @Override
    public List<Mno> getSnm(String filtroPod, Iterable<StatoMisure> stati) {
        ArrayList<Mno> allSnms = new ArrayList<Mno>();
        allSnms.addAll(this.snms);
        allSnms.addAll(this.snms2g);
        return allSnms;
    }

    @Override
    public List<Snf> getSnfXml(final TipoFlusso tipoFlusso, String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod) {
        Condition<Snf> condition = new Condition<Snf>(){

            @Override
            public boolean check(Snf item) {
                return item.getCodiceFlusso().equals(tipoFlusso.name());
            }
        };
        Filter<Snf> filter = new Filter<Snf>(condition);
        return filter.filter(this.snfs);
    }

    @Override
    public List<Snf> getSnfs(String filtroPod, Iterable<StatoMisure> stati) {
        return this.snfs;
    }

    @Override
    public List<Sof> getSofXml(String azienda, int stat, String statoEsportazioneo, Date dataInizio, Date dataFine, String pod) {
        return this.sofs;
    }

    @Override
    public List<Sof> getSofs(String filtroPod, Iterable<StatoMisure> stati) {
        return this.sofs;
    }

    @Override
    public List<Pdo> getRfoXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod) {
        ArrayList<Pdo> rettifiche = new ArrayList<Pdo>();
        for (Pdo rfo : this.rfos) {
            rettifiche.add(rfo);
        }
        return this.rfos;
    }

    @Override
    public List<Pdo> getRfo(Funzionalita funzionalita, String filtroPod, Iterable<StatoMisure> stati) {
        return this.getRfoXml(null, 0, "", null, null, "");
    }

    public List<String[]> getStatiSnm() {
        return this.snmStatus;
    }

    public List<String[]> getStatiRfo() {
        return this.rfoStatus;
    }

    public List<String[]> getStatiRno() {
        return this.rnoStatus;
    }

    public List<String[]> getStatiPdo() {
        return this.pdoStatus;
    }

    public List<String[]> getStatiPno() {
        return this.pnoStatus;
    }

    public List<String[]> getStatiSmis() {
        return this.smisStatus;
    }

    public List<String[]> getStatiSof() {
        return this.sofStatus;
    }

    public List<String[]> getStatiVno() {
        return this.vnoStatus;
    }

    public List<String[]> getStatiRnv() {
        return this.rnvStatus;
    }

    public List<String[]> getStatiRsn() {
        return this.rsnStatus;
    }

    public List<String[]> getStatiSnf() {
        return this.snfStatus;
    }

    @Override
    public boolean recordStatoSwitch(StatoContainer status, TalkManager talkManager) {
        Iterable<MnoResult> snmElaborati = status.getSnmElaborati();
        Iterable<MnoResult> snmSospesi = status.getSnmSospesi();
        List<MnoResult> snmObsoleti = status.getSnmObsoleti();
        Iterable<SofResult> sofElaborati = status.getSofElaborati();
        Iterable<SofResult> sofSospesi = status.getSofSospesi();
        List<SofResult> sofObsoleti = status.getSofObsoleti();
        ListMap<String, SnfResult> snfElaborati = status.getSnfElaborati();
        ListMap<String, SnfResult> snfSospesi = status.getSnfSospesi();
        ListMap<String, SnfResult> snfObsoleti = status.getSnfObsoleti();
        ListMap<String, SnfResult> snfEsclusi = status.getSnfEsclusi();
        boolean ok = this.setSnmStatus(snmElaborati, StatoMisure.ELABORATO);
        ok &= this.setSnmStatus(snmSospesi, StatoMisure.SOSPESO);
        ok &= this.setSnmStatus(snmObsoleti, StatoMisure.OBSOLETO);
        ok &= this.setSofStatus(sofElaborati, StatoMisure.ELABORATO);
        ok &= this.setSofStatus(sofSospesi, StatoMisure.SOSPESO);
        ok &= this.setSofStatus(sofObsoleti, StatoMisure.OBSOLETO);
        ok &= this.setSnfStatus(snfElaborati, StatoMisure.ELABORATO);
        ok &= this.setSnfStatus(snfSospesi, StatoMisure.SOSPESO);
        ok &= this.setSnfStatus(snfObsoleti, StatoMisure.OBSOLETO);
        ok &= this.setSnfStatus(snfEsclusi, StatoMisure.ESCLUSO);
        List<StatoPod> statiPod = status.getStatiPod();
        return ok &= this.setStatiPod(statiPod);
    }

    private boolean setSnfStatus(ListMap<String, SnfResult> results, StatoMisure stato) {
        boolean ok = true;
        for (List list : results) {
            ok &= this.setSnfStatus(list, stato);
        }
        return ok;
    }

    private boolean setStatiPod(Iterable<StatoPod> statiPod) {
        for (StatoPod statoPod : statiPod) {
            Date dataMovimento = statoPod.getDataMovimento();
            Date dataAttivazione = statoPod.getDataAttivazione();
            Date dataPrestazione = statoPod.getDataPrestazione();
            String cpUtente = statoPod.getCpUtente();
            String cf = statoPod.getCf();
            String[] row = new String[]{statoPod.getCpGestore(), statoPod.getPod(), statoPod.getStato(), statoPod.getStatoRic(), String.valueOf(statoPod.getNuprogre()), FunctionalTest.DATE_FORMAT.format(dataMovimento), FunctionalTest.DATE_FORMAT.format(dataAttivazione), String.valueOf(statoPod.getFlagOrario()), String.valueOf(statoPod.getNuLetA01()), statoPod.getCdunipre(), statoPod.getNuMatrA(), statoPod.getTabellaRiferimento(), statoPod.getCdFlusso(), statoPod.getServizioTutela(), dataPrestazione == null ? "" : FunctionalTest.DATE_FORMAT.format(dataPrestazione), cpUtente == null ? "" : cpUtente, cf == null ? "" : cf, String.valueOf(statoPod.isFlMisBio()), String.valueOf(statoPod.getNuLetBio01()), statoPod.getNuMatricBio(), String.valueOf(statoPod.getInmisCon())};
            this.rowsStatoPod.add(row);
        }
        return true;
    }

    private boolean setUpdateStatiPod(Iterable<UpdateStatoPod> statiPod) {
        for (UpdateStatoPod statoPod : statiPod) {
            Date dataMovimento = statoPod.getDataMovimento();
            String[] row = new String[]{statoPod.getPod(), statoPod.getStatoRic(), String.valueOf(statoPod.getNuprogre()), FunctionalTest.DATE_FORMAT.format(dataMovimento)};
            this.rowsUpdateStatoPod.add(row);
        }
        return true;
    }

    @Override
    public boolean recordStatoLetture(StatoContainer status, TalkManager talkManager) {
        boolean ok = this.setPdoStatus(status.getPdoElaborati(), StatoMisure.ELABORATO);
        ok &= this.setPdoStatus(status.getPdoSospesi(), StatoMisure.SOSPESO);
        ok &= this.setPdoStatus(status.getPdoObsoleti(), StatoMisure.OBSOLETO);
        ok &= this.setPdoStatus(status.getPdoEsclusi(), StatoMisure.ESCLUSO);
        ok &= this.setRfoStatus(status.getRfoElaborati(), StatoMisure.ELABORATO);
        ok &= this.setRfoStatus(status.getRfoSospesi(), StatoMisure.SOSPESO);
        ok &= this.setRfoStatus(status.getRfoObsoleti(), StatoMisure.OBSOLETO);
        ok &= this.setRfoStatus(status.getRfoEsclusi(), StatoMisure.ESCLUSO);
        ok &= this.setPnoStatus(status.getPnoElaborati(), StatoMisure.ELABORATO);
        ok &= this.setPnoStatus(status.getPnoSospesi(), StatoMisure.SOSPESO);
        ok &= this.setPnoStatus(status.getPnoObsoleti(), StatoMisure.OBSOLETO);
        ok &= this.setPnoStatus(status.getPnoEsclusi(), StatoMisure.ESCLUSO);
        ok &= this.setSmisStatus(status.getSmisElaborati(), StatoMisure.ELABORATO);
        ok &= this.setSmisStatus(status.getSmisSospesi(), StatoMisure.SOSPESO);
        ok &= this.setSmisStatus(status.getSmisEsclusi(), StatoMisure.ESCLUSO);
        ok &= this.setSmisStatus(status.getSmisObsoleti(), StatoMisure.OBSOLETO);
        ok &= this.setRnoStatus(status.getRnoElaborati(), StatoMisure.ELABORATO);
        ok &= this.setRnoStatus(status.getRnoSospesi(), StatoMisure.SOSPESO);
        List<StatoPod> statiPod = status.getStatiPod();
        ok &= this.setStatiPod(statiPod);
        List<UpdateStatoPod> updateStatiPod = status.getUpdateStatiRichiesta();
        return ok &= this.setUpdateStatiPod(updateStatiPod);
    }

    @Override
    public boolean recordStatoTariffe(ServiceStatus status, TalkManager talkManager) {
        boolean ok = true;
        Map<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> tariffeResult = status.getTariffeOrarieResult();
        for (Map.Entry<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> destinatariEntry : tariffeResult.entrySet()) {
            for (Map.Entry statoEntry : destinatariEntry.getValue().entrySet()) {
                StatoMisure stato = (StatoMisure)((Object)statoEntry.getKey());
                List statoTariffeResult = (List)statoEntry.getValue();
                ok &= this.setPdoStatus(statoTariffeResult, stato);
            }
        }
        return ok;
    }

    @Override
    public boolean recordStatoVolture(ServiceStatus status, TalkManager talkManager) {
        boolean ok = this.setVnoStatus(status.getVnoElaborati(), StatoMisure.ELABORATO);
        ok &= this.setVnoStatus(status.getVnoSospesi(), StatoMisure.SOSPESO);
        ok &= this.setVnoStatus(status.getVnoObsoleti(), StatoMisure.OBSOLETO);
        ok &= this.setVnoStatus(status.getVnoEsclusi(), StatoMisure.ESCLUSO);
        List<StatoPod> statiPod = status.getStatiPod();
        return ok &= this.setStatiPod(statiPod);
    }

    @Override
    public boolean recordStatoMisure(ServiceStatus status, TalkManager talkManager) {
        Iterable<PdoResult> pdoEsportati = status.getPdoEsportati();
        boolean ok = this.setPdoStatus(pdoEsportati, null);
        Iterable<MnoResult> pnoEsportati = status.getPnoEsportati();
        ok &= this.setPnoStatus(pnoEsportati, null);
        Iterable<MnoResult> smisEsportati = status.getSmisEsportati();
        ok &= this.setSmisStatus(smisEsportati, null);
        Iterable<SofResult> sofEsportati = status.getSofEsportati();
        ok &= this.setSofStatus(sofEsportati, null);
        Iterable<SnfResult> snfEsportati = status.getSnfEsportati();
        ok &= this.setSnfStatus(snfEsportati, null);
        Iterable<MnoResult> snmEsportati = status.getSnmEsportati();
        ok &= this.setSnmStatus(snmEsportati, null);
        Iterable<PdoResult> rfoEsportati = status.getRfoEsportati();
        ok &= this.setRfoStatus(rfoEsportati, null);
        Iterable<MnoResult> rnoEsportati = status.getRnoEsportati();
        ok &= this.setRnoStatus(rnoEsportati, null);
        Iterable vnoEsportati = status.getVnoEsportati();
        ok &= this.setVnoStatus(vnoEsportati, null);
        Iterable<MnoResult> rnvEsportati = status.getRnvEsportati();
        ok &= this.setRnvStatus(rnvEsportati, null);
        Iterable<MnoResult> rsnEsportati = status.getRsnEsportati();
        return ok &= this.setRsnStatus(rsnEsportati, null);
    }

    private boolean setVnoStatus(Iterable<MnoResult> vnos, StatoMisure stato) {
        for (MnoResult vnoResult : vnos) {
            MisuraNonoraria vno = (MisuraNonoraria)vnoResult.getRecord();
            Date date = vno.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{vno.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), vno.getCdaziend()};
            this.vnoStatus.add(row);
        }
        return true;
    }

    private boolean setRnvStatus(Iterable<MnoResult> rnv, StatoMisure stato) {
        for (MnoResult rnvResult : rnv) {
            MisuraNonoraria record = (MisuraNonoraria)rnvResult.getRecord();
            Date date = record.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{record.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), record.getCdaziend()};
            this.rnvStatus.add(row);
        }
        return true;
    }

    private boolean setRsnStatus(Iterable<MnoResult> rsn, StatoMisure stato) {
        for (MnoResult rsnResult : rsn) {
            MisuraNonoraria record = (MisuraNonoraria)rsnResult.getRecord();
            Date date = record.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{record.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), record.getCdaziend()};
            this.rsnStatus.add(row);
        }
        return true;
    }

    private boolean setSnfStatus(Iterable<SnfResult> snfs, StatoMisure stato) {
        for (SnfResult snfResult : snfs) {
            SnfD65 snf = (SnfD65)snfResult.getRecord();
            Date date = snf.getDate();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{snf.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), snf.getCdaziend(), snf.getTabella()};
            this.snfStatus.add(row);
        }
        return true;
    }

    private boolean setSofStatus(Iterable<SofResult> sofs, StatoMisure stato) {
        for (SofResult sofResult : sofs) {
            Sof sof = (Sof)sofResult.getRecord();
            Date date = sof.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{sof.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), sof.getCdaziend()};
            this.sofStatus.add(row);
        }
        return true;
    }

    private boolean setSnmStatus(Iterable<MnoResult> snms, StatoMisure stato) {
        for (MnoResult snmResult : snms) {
            MisuraNonoraria snm = (MisuraNonoraria)snmResult.getRecord();
            Date date = snm.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{snm.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), snm.getCdaziend()};
            this.snmStatus.add(row);
        }
        return true;
    }

    private boolean setPdoStatus(Iterable<? extends ResultRecord<Pdo, PrebillingError>> pdos, StatoMisure stato) {
        for (ResultRecord<Pdo, PrebillingError> resultRecord : pdos) {
            Pdo pdo = resultRecord.getRecord();
            RilMese rilMese = pdo.getRilMese();
            String[] row = new String[]{pdo.getCodicePod(), String.valueOf(rilMese.getAnno()), String.valueOf(rilMese.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), pdo.getCdaziend()};
            this.pdoStatus.add(row);
        }
        return true;
    }

    private boolean setRfoStatus(Iterable<PdoResult> pdos, StatoMisure stato) {
        for (PdoResult pdoResult : pdos) {
            Pdo pdo = (Pdo)pdoResult.getRecord();
            RilMese rilMese = pdo.getRilMese();
            String[] row = new String[]{pdo.getCodicePod(), String.valueOf(rilMese.getAnno()), String.valueOf(rilMese.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), pdo.getCdaziend()};
            this.rfoStatus.add(row);
        }
        return true;
    }

    private boolean setSmisStatus(Iterable<MnoResult> smisList, StatoMisure stato) {
        for (MnoResult smisResult : smisList) {
            MisuraNonoraria smis = (MisuraNonoraria)smisResult.getRecord();
            Date date = smis.getDataMisura();
            String[] row = new String[]{smis.getCodicePod(), FunctionalTest.DATE_FORMAT.format(date), stato == null ? "esportato" : stato.name().toLowerCase(), smis.getCdaziend()};
            this.smisStatus.add(row);
        }
        return true;
    }

    private boolean setPnoStatus(Iterable<MnoResult> pnos, StatoMisure stato) {
        for (MnoResult pnoResult : pnos) {
            MisuraNonoraria pno = (MisuraNonoraria)pnoResult.getRecord();
            Date date = pno.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{pno.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), pno.getCdaziend()};
            this.pnoStatus.add(row);
        }
        return true;
    }

    private boolean setRnoStatus(Iterable<MnoResult> pnos, StatoMisure stato) {
        for (MnoResult pnoResult : pnos) {
            MisuraNonoraria pno = (MisuraNonoraria)pnoResult.getRecord();
            Date date = pno.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(date);
            String[] row = new String[]{pno.getCodicePod(), String.valueOf(calendar.getAnno()), String.valueOf(calendar.getMese().getIndex()), stato == null ? "esportato" : stato.name().toLowerCase(), pno.getCdaziend()};
            this.rnoStatus.add(row);
        }
        return true;
    }

    @Override
    public StatoPod getStatoPodGestore(String servizio, String flusso, String codicePod, String codicePratica) throws DataNotFoundException {
        StatoPod statoPod = this.statiPodIn.get(codicePratica);
        if (statoPod == null) {
            int error = ErroriElaborazione.MOVIMENTORIFERIMENTO_NOTFOUND.ordinal();
            throw new DataNotFoundException("statopod.notfound", codicePratica, error);
        }
        return statoPod;
    }

    @Override
    public StatoPod getStatoPodUtente(String servizio, String prestazione, String azienda, String codicePod, String codicePratica) throws DataNotFoundException {
        String cpUtente = codicePratica.substring(2);
        return this.getStatoPodGestore(servizio, prestazione, codicePod, cpUtente);
    }

    @Override
    public StatoPod getStatoPod(String servizio, String codicePod, Date dataMovimento) throws DataNotFoundException {
        StatoPod statoPod = this.statiPodIn.get(codicePod);
        if (statoPod == null) {
            throw new DataNotFoundException("statopod.notfound", codicePod, 0);
        }
        return statoPod;
    }

    @Override
    public SafeListMap<String, Prestazione> getPrestazioni() {
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("prestazione");
        prestazioni.add(new Prestazione("E", "SE1", "SNF", 0, 1, "", "EN", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "F2G", 0, 1, "", "EN", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "SOF", 0, 1, "", "EO", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "SNM", 0, 1, "", "e", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "PDO", 0, 10, "", "e", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "RFO", 0, 10, "", "e", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "VNO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "VNO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "VNO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "VNO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "SE3", "PDO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "VT4", "PDO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "SE3", "RFO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "SE3", "PNO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "VT4", "PNO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "CP1", "PDO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "CP1", "RFO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "CP1", "PNO", 0, 2, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "RC1", "PDO", 0, 3, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "RC1", "RFO", 0, 3, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "RC1", "PNO", 0, 3, "C", "E", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "PDO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "PDO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "RFO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "RFO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "PDO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "PDO", 0, 6, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "RFO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "RFO", 0, 6, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "GM1", "RIM", 0, 2, "Y", "y", "Q", false));
        prestazioni.add(new Prestazione("E", "GM1", "INS", 0, 2, "W", "w", "", false));
        prestazioni.add(new Prestazione("E", "SE1", "RSN", 0, 1, "I", "i", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "RNV", 0, 8, "J", "j", "", false));
        prestazioni.add(new Prestazione("E", "VT1", "RNV", 0, 9, "K", "k", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "RNV", 0, 8, "M", "m", "", false));
        prestazioni.add(new Prestazione("E", "VT3", "RNV", 0, 9, "N", "n", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PNO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PNO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PDO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "PDO", 0, 1, "A", "e", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "RFO", 0, 4, "C", "x", "", false));
        prestazioni.add(new Prestazione("E", "AE1", "RFO", 0, 1, "A", "e", "", false));
        return prestazioni;
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2geaXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod, Partition partition) {
        return flusso.equals((Object)TipoFlusso.PNO2G) ? this.pno2gEnergia : this.snm2gEnergia;
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2gerXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        return flusso.equals((Object)TipoFlusso.PNO2G) ? this.pno2gEnergia : this.snm2gEnergia;
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2gercXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        return new ArrayList<Mno2GE>();
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2geriXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        return new ArrayList<Mno2GE>();
    }

    @Override
    public ListMap<String, Mno> getRsnRnv(int anno, Month mese, String filtroPod) {
        return this.rsnrnv;
    }

    @Override
    public StatoPod getStatoPod(String servizio, String codicePod, String cpGestore) {
        return this.statiPodIn.get(cpGestore);
    }

    @Override
    public StatoPod getLastStatoPod(String servizio, String codicePod, String flusso, Date dataMisura, String statoRic) throws DataNotFoundException {
        StatoPod statoPod = this.statiPodIn.get(codicePod);
        if (statoPod == null) {
            int errore = ErroriElaborazione.STATOPOD_INVALIDO.ordinal();
            throw new DataNotFoundException("statopod.notfound", codicePod, errore);
        }
        return statoPod;
    }

    @Override
    public StatoPod getStatoPod(String servizio, String prestazione, String flusso, String codicePod, Date dataMisura, String stato) {
        return this.statiPodIn.get(codicePod);
    }

    @Override
    public StatoPod getStatoPodFlusso(String servizio, String[] flussi, String codicePod, Date dataMovimento) {
        return this.statiPodIn.get(codicePod);
    }

    @Override
    public List<Mno> getRnvXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso tipo, String pod) {
        return this.rnv;
    }

    @Override
    public List<Mno> getRsnXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso tipo, String pod) {
        return this.rsn;
    }

    @Override
    public List<Mno2GE> getPdo2gREaXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso pdo2g, String pod, Partition partition) {
        return new ArrayList<Mno2GE>();
    }

    @Override
    public List<Mno2GE> getPdo2gRErXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso pdo2g, String pod, Partition partition) {
        return new ArrayList<Mno2GE>();
    }

    @Override
    public Map<String, List<VolturaIV>> getVoltureIV(String onlyPod) {
        return new HashMap<String, List<VolturaIV>>();
    }
}

