/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.functest.FunctionalTest;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;

class CSVMockDaoHelper {
    CSVMockDaoHelper() {
    }

    public static Date getDate(String string) throws ParseException {
        Date date = string.trim().isEmpty() ? null : FunctionalTest.DATE_FORMAT.parse(string);
        return date;
    }

    public static int getInteger(String string) {
        return Integer.parseInt(string);
    }

    public static boolean getBoolean(String string) {
        return string.toUpperCase().equals("TRUE");
    }

    public static Month getMonth(String string) {
        Month month;
        if (string.trim().isEmpty()) {
            month = null;
        } else {
            int index = CSVMockDaoHelper.getInteger(string);
            month = Month.valueOf(index);
        }
        return month;
    }

    public static Double getDouble(String string) {
        return string.trim().isEmpty() ? null : Double.valueOf(string);
    }

    public static List<PraticaVolo> fillPiv(File folder, String fileName) throws IOException, ParseException {
        ArrayList<PraticaVolo> pivList = new ArrayList<PraticaVolo>();
        File file = new File(folder, fileName);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    PraticaVolo piv = CSVMockDaoHelper.getPraticaVolo(row);
                    pivList.add(piv);
                }
            }
        }
        return pivList;
    }

    private static PraticaVolo getPraticaVolo(String[] row) throws ParseException {
        String codicePod = row[0].trim();
        String reseller = row[1].trim();
        Date date = CSVMockDaoHelper.getDate(row[2].trim());
        if (date == null) {
            date = CalendarTools.getEndOfTime();
        }
        String codicePrestazione = row[3].trim();
        String codPratAtt = row.length > 4 ? row[4].trim() : "cpgestore";
        String calendarId = row.length > 5 ? row[5].trim() : "1";
        SpecificaTecnica voltura = new SpecificaTecnica(calendarId, date);
        return new PraticaVolo(codicePod, reseller, voltura, codicePrestazione, codPratAtt, date, 0);
    }
}

