/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.Sof;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.homelinux.elabor.db.RecordCreator;

public class SofCreator
implements RecordCreator<Sof> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();

    @Override
    public Sof createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String codice = rs.getString("pod_id").trim().substring(0, 14);
        Date dataInizio = RecordCreatorHelper.getDate(restrictedRS, "data_inizio", this.dateFormat);
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        String codContrDisp = rs.getString("contratto_dispacciamento");
        String pivaUtente = rs.getString("piva_dispatcher");
        String pivaDistributore = rs.getString("piva_distributore");
        String nomeFile = rs.getString("nome_file");
        Map<String, Map<String, String>> datiPod = SofCreator.createDatiPod(rs);
        String id = rs.getString("id");
        String codPratAtt = rs.getString("COD_PRATICA_ATTIVAZIONE");
        String cdaziend = rs.getString("CDAZIEND");
        if (cdaziend != null) {
            cdaziend = cdaziend.trim();
        }
        String delibera = rs.getString("DELIBERA");
        return new Sof(id, codice, pivaUtente, pivaDistributore, codContrDisp, codPratAtt, cdaziend, dataInizio, nomeFile, datiPod, delibera);
    }

    private static Map<String, Map<String, String>> createDatiPod(ResultSet rs) throws SQLException {
        String[][] campiDatiPdp = new String[][]{{"CONFMIS", "ConfigurazioneMisuratore"}, {"DISALIMENT", "Disalimentabilita"}, {"RESIDENZA", "Residenza"}, {"tipo_misuratore", "TipoMisuratore"}, {"punto_dispacciamento", "PuntoDispacciamento"}, {"trattamento_pod", "Trattamento"}, {"tensione", "Tensione"}, {"potenza_contr_impegnata", "PotContrImp"}, {"potenza_disponibile", "PotDisp"}, {"cod_tariffa", "CodiceTariffa"}, {"servizio_tutela", "ServizioTutela"}, {"prestazioni", "prestazioni"}};
        String[] campiMisura = new String[]{"EaF1", "EaF2", "EaF3", "ErF1", "ErF2", "ErF3", "PotF1", "PotF2", "PotF3"};
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        Map<String, String> datiPdp = SofCreator.createDatiPdp(rs, campiDatiPdp);
        Map<String, String> misura = SofCreator.createMisura(campiMisura);
        datiPod.put("DatiPdp", datiPdp);
        datiPod.put("Misura", misura);
        return datiPod;
    }

    private static Map<String, String> createDatiPdp(ResultSet rs, String[][] campiDatiPdp) throws SQLException {
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        String[][] stringArray = campiDatiPdp;
        int n2 = campiDatiPdp.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] campo = stringArray[n3];
            String valoreTxt = rs.getString(campo[0]);
            if (valoreTxt != null) {
                datiPdp.put(campo[1], valoreTxt);
            }
            ++n3;
        }
        return datiPdp;
    }

    private static Map<String, String> createMisura(String[] campiMisura) {
        LinkedHashMap<String, String> misura = new LinkedHashMap<String, String>();
        String[] stringArray = campiMisura;
        int n2 = campiMisura.length;
        int n3 = 0;
        while (n3 < n2) {
            String campo = stringArray[n3];
            misura.put(campo, "0");
            ++n3;
        }
        return misura;
    }
}

