/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.giada.RigaPod;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.RecordCreator;

public class RigaPodCreator
implements RecordCreator<RigaPod> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();

    @Override
    public RigaPod createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String codice = rs.getString("cdprerif").trim();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        String cdazirif = rs.getString("cdazirif").trim();
        String ccstaute = rs.getString("ccstaute").trim();
        boolean orario = rs.getBoolean("flmisora");
        boolean flazzcon = rs.getBoolean("flazzcon");
        boolean commericale = rs.getBoolean("flmisbio");
        int tensione = rs.getInt("qttensio");
        Date inizio = RecordCreatorHelper.getDate(restrictedRS, "inizio", this.dateFormat);
        String codiceOfferta = rs.getString("codice_offerta");
        Date dataMax = RecordCreatorHelper.getDate(restrictedRS, "data_max", this.dateFormat);
        Date dataInst = RecordCreatorHelper.getDate(restrictedRS, "data_inst", this.dateFormat);
        Date fine = RecordCreatorHelper.getDate(restrictedRS, "fine", this.dateFormat);
        Date dataTecnica = RecordCreatorHelper.getDate(restrictedRS, "voltura", this.dateFormat);
        if (dataTecnica == null && !dataInst.equals(inizio)) {
            ElaborCalendar calendar = new ElaborCalendar(dataInst);
            calendar.addGiorni(-1);
            dataTecnica = calendar.getDate();
        }
        boolean attiva = rs.getBoolean("flmiscon");
        boolean reattiva = rs.getBoolean("flmisrea");
        boolean potenza = rs.getBoolean("flmispot");
        String allineatoStr = rs.getString("ccallgru");
        boolean allineato = allineatoStr == null ? false : allineatoStr.trim().toUpperCase().equals("SI");
        Date switchout = RecordCreatorHelper.getDate(restrictedRS, "data_out", this.dateFormat);
        Date attesaSnm = RecordCreatorHelper.getDate(restrictedRS, "data_snm", this.dateFormat);
        String dispatcher = rs.getString("cod_disp").trim();
        String tarDis = rs.getString("cdtardis");
        double potImp = rs.getDouble("qtpotenz");
        double potDisponibile = rs.getDouble("qtpotdis");
        boolean nuovaFornitura = RecordCreatorHelper.getBoolean(restrictedRS, "nuova_fornitura");
        double attF1 = rs.getDouble("att_f1");
        double attF2 = rs.getDouble("att_f2");
        double attF3 = rs.getDouble("att_f3");
        double reaF1 = rs.getDouble("rea_f1");
        double reaF2 = rs.getDouble("rea_f2");
        double reaF3 = rs.getDouble("rea_f3");
        double kA = rs.getDouble("ka");
        double kR = rs.getDouble("kr");
        double kP = rs.getDouble("kp");
        String numatric = RecordCreatorHelper.getString(restrictedRS, "numatric");
        String cdconmag = rs.getString("cdconmag");
        cdconmag = cdconmag == null ? "GENERICO" : cdconmag.trim();
        boolean podNuovo = rs.getBoolean("pod_nuovo");
        String pivaDistributore = rs.getString("piva_distributore");
        String pivaDispatcher = rs.getString("piva_dispatcher");
        String cdcomist = rs.getString("cdcomist");
        String ccLettur = rs.getString("cclettur_inst");
        return new RigaPod(codice, cdazirif, orario, tensione, inizio, dataTecnica, dataMax, fine, attiva, reattiva, potenza, ccstaute, allineato, switchout, attesaSnm, dispatcher, tarDis, potImp, potDisponibile, nuovaFornitura, attF1, attF2, attF3, reaF1, reaF2, reaF3, codiceOfferta, kA, kR, kP, commericale, flazzcon, dataInst, numatric, cdconmag, podNuovo, pivaDistributore, pivaDispatcher, cdcomist, ccLettur);
    }
}

