/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class PraticaVoloCreator
implements RecordCreator<PraticaVolo> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");

    @Override
    public PraticaVolo createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String codicePod = rs.getString("cdprerif").trim().substring(0, 14);
        String codiceReseller = rs.getString("cdanagra").trim();
        Date dataAppuntamento = RecordCreatorHelper.getDate(restrictedRS, "dtapptec", DATE_FORMAT);
        String calendarId = rs.getString("dxoffcrm");
        String codicePrestazione = rs.getString("cdunipre").trim();
        String codPratAtt = rs.getString("cdrichie");
        if (codPratAtt != null) {
            codPratAtt = codPratAtt.trim();
        }
        String context = this.getClass().getSimpleName();
        PrebillingContext.setContext(context, "piv: " + codicePod + "/" + codiceReseller);
        SpecificaTecnica specifica = new SpecificaTecnica(calendarId, dataAppuntamento);
        Date dataCommerciale = RecordCreatorHelper.getDate(restrictedRS, "dtappcom", DATE_FORMAT);
        int ccclaint = rs.getInt("ccclaint");
        String codiceDisp = rs.getString("codice_disp");
        return new PraticaVolo(codicePod, codiceReseller, specifica, codicePrestazione, codPratAtt, dataCommerciale, ccclaint, codiceDisp);
    }
}

