/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.BasicIdFlusso;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.RestrictedResultSet;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.text.Format;

public class PdoCreator {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();
    private final DecimalFormat doubleFormat = Format.newDecimalFormat(Locale.US, "0.000");

    public List<Pdo> getRecords(RestrictedResultSet rs, boolean complete, boolean attivaOnly) throws SQLException {
        ArrayList<Pdo> pdos = new ArrayList<Pdo>();
        BasicIdFlusso pdo = null;
        boolean tariffaElaborata = true;
        boolean tariffaResellerElaborata = true;
        RilMese rilMese = null;
        while (rs.next()) {
            RilQuartoType type;
            Map<String, Map<String, String>> datiPod;
            String codice = rs.getString("pod_id").trim().substring(0, 14);
            String codiceFlusso = rs.getString("cod_flusso");
            int anno = rs.getInt("anno");
            Month mese = Month.valueOf(rs.getInt("mese"));
            String id = rs.getString("id");
            String delibera = rs.getString("delibera");
            boolean delibera65 = delibera.equals("65");
            boolean dueG = codiceFlusso.endsWith("2G");
            String tipoRettifica = RecordCreatorHelper.getString(rs, "TIPO_RETTIFICA");
            Map<String, Map<String, String>> map = datiPod = complete ? MisureHelper.createDatiPod(dueG, delibera65, attivaOnly, rs) : null;
            if (pdo == null || rilMese == null || PdoCreator.checkPod(rilMese, codice, anno, mese)) {
                rilMese = new RilMese(codice, anno, mese, null);
                pdo = this.buildPdo(rs, rilMese, delibera, tipoRettifica, datiPod);
                pdos.add((Pdo)pdo);
                tariffaElaborata = true;
                tariffaResellerElaborata = true;
            }
            pdo.addId(id);
            if (!complete) continue;
            if (datiPod == null) {
                type = RilQuartoType.REALE;
            } else {
                Map<String, String> misura = datiPod.get("Misura");
                if (misura == null) {
                    type = RilQuartoType.REALE;
                } else {
                    String tipoDato = misura.get("TipoDato");
                    type = RilQuartoType.build(tipoDato);
                }
            }
            RilGiorno rilGiorno = this.getRilGiorno(rs, codiceFlusso, id, type);
            tariffaElaborata &= PdoCreator.checkTariffaElaborata(rs);
            tariffaResellerElaborata &= PdoCreator.checkTariffaResellerElaborata(rs);
            if (rilMese.isEmpty()) {
                rilMese.add(rilGiorno);
            } else {
                int lastIndex = rilMese.size() - 1;
                RilGiorno last = (RilGiorno)rilMese.get(lastIndex);
                Date lastDate = last.getDate();
                Date date = rilGiorno.getDate();
                if (date.equals(lastDate)) {
                    PdoCreator.mergeRilGiorno(last, rilGiorno);
                } else {
                    rilMese.add(rilGiorno);
                }
            }
            Date dataRilevazione = RecordCreatorHelper.getDate(rs, "DATA_RILEVAZIONE", this.dateFormat);
            ((Pdo)pdo).addRilData(dataRilevazione, tipoRettifica, datiPod, rilGiorno);
            ((Pdo)pdo).setTariffaElaborata(tariffaElaborata);
            ((Pdo)pdo).setTariffaResellerElaborata(tariffaResellerElaborata);
        }
        rs.close();
        return pdos;
    }

    private static boolean checkTariffaElaborata(RestrictedResultSet rs) throws SQLException {
        int value = rs.getInt("STATO_TARIFFE");
        StatoMisure stato = StatoMisure.valueOf(value);
        return stato != null && stato.isElaborato();
    }

    private static boolean checkTariffaResellerElaborata(RestrictedResultSet rs) throws SQLException {
        int value = rs.getInt("STATO_TARIFFE_RESELLER");
        StatoMisure stato = StatoMisure.valueOf(value);
        return stato != null && stato.isElaborato();
    }

    private static void mergeRilGiorno(RilGiorno last, RilGiorno next) {
        Iterator lastIterator = last.iterator();
        Iterator nextIterator = next.iterator();
        while (lastIterator.hasNext() && nextIterator.hasNext()) {
            Double reattiva;
            RilQuarto lastQuarto = (RilQuarto)lastIterator.next();
            RilQuarto nextQuarto = (RilQuarto)nextIterator.next();
            String codiceFlusso = nextQuarto.getCodiceFlusso();
            String id = nextQuarto.getId();
            double ka = nextQuarto.getKa();
            Double attiva = nextQuarto.getAttiva();
            RilQuartoType type = nextQuarto.getType();
            if (attiva != null) {
                lastQuarto.setAttiva(attiva);
                lastQuarto.setCodiceFlusso(codiceFlusso);
                lastQuarto.setId(id);
                lastQuarto.setKa(ka);
            }
            if ((reattiva = nextQuarto.getReattiva()) != null) {
                lastQuarto.setReattiva(reattiva);
                lastQuarto.setCodiceFlusso(codiceFlusso);
                lastQuarto.setId(id);
            }
            lastQuarto.setType(type);
        }
    }

    private static int[] findColumnIndexes(ResultSetMetaData metadata) throws SQLException {
        int[] colIndexes = new int[4];
        int numColumns = 0;
        int colIndex = 1;
        while (colIndex <= metadata.getColumnCount() && numColumns < colIndexes.length) {
            String columnName = metadata.getColumnName(colIndex);
            if (columnName.toUpperCase().equals("E_1")) {
                colIndexes[numColumns] = colIndex;
                ++numColumns;
            }
            ++colIndex;
        }
        return colIndexes;
    }

    private RilGiorno getRilGiorno(RestrictedResultSet rs, String flusso, String id, RilQuartoType type) throws SQLException {
        ResultSetMetaData metadata = rs.getMetadata();
        int[] colIndexes = PdoCreator.findColumnIndexes(metadata);
        int startAttiva = colIndexes[0];
        int startReattiva = colIndexes[1];
        int startReattivaCapacitiva = colIndexes[2];
        int startReattivaInduttiva = colIndexes[3];
        Date date = RecordCreatorHelper.getDate(rs, "data_att", this.dateFormat);
        double kA = flusso.equals("PDO") || flusso.equals("RFO") ? 1.0 : RecordCreatorHelper.getDouble(rs, "KA", this.doubleFormat, 1.0);
        RilGiorno rilGiorno = new RilGiorno(date);
        int nQuarti = CalendarTools.getHoursOfDay(date) * 4;
        int index = 0;
        while (index < nQuarti) {
            Double attiva = PdoCreator.getDouble(rs, startAttiva + index);
            Double reattiva = startReattiva == 0 ? null : PdoCreator.getDouble(rs, startReattiva + index);
            Double reattivaCapacitiva = startReattivaCapacitiva == 0 ? null : PdoCreator.getDouble(rs, startReattivaCapacitiva + index);
            Double reattivaInduttiva = startReattivaInduttiva == 0 ? null : PdoCreator.getDouble(rs, startReattivaInduttiva + index);
            RilQuarto rilQuarto = new RilQuarto(index, flusso, id, attiva, reattiva, reattivaCapacitiva, reattivaInduttiva, kA, type);
            rilGiorno.add(rilQuarto);
            ++index;
        }
        return rilGiorno;
    }

    private static boolean checkPod(RilMese rilMese, String codice, int anno, Month mese) {
        String codiceRil = rilMese.getCodicePod();
        int annoRil = rilMese.getAnno();
        Month meseRil = rilMese.getMese();
        return !codice.equals(codiceRil) || annoRil != anno || meseRil != mese;
    }

    private Pdo buildPdo(RestrictedResultSet rs, RilMese rilMese, String delibera, String tipoRettifica, Map<String, Map<String, String>> datiPod) throws SQLException {
        boolean stimata = RecordCreatorHelper.getBoolean(rs, "tipo_dato");
        String pIvaUtente = rs.getString("PIVA_DISPATCHER").trim();
        String pIvaDistributore = rs.getString("PIVA_DISTRIBUTORE").trim();
        String codContrDisp = rs.getString("CONTRATTO_DISPACCIAMENTO").trim();
        String codPratAtt = rs.getString("COD_PRATICA_ATTIVAZIONE");
        String cdaziend = rs.getString("CDAZIEND");
        Date dataRilevazione = RecordCreatorHelper.getDate(rs, "DATA_RILEVAZIONE", this.dateFormat);
        Date dataImport = RecordCreatorHelper.getDate(rs, "DATA_IMPORT_FILE", this.dateFormat);
        String motivazione = rs.getString("MOTIVAZIONE");
        String nomeFile = rs.getString("NOME_FILE");
        String regime = rs.getString("REGIME");
        if (cdaziend != null) {
            cdaziend = cdaziend.trim();
        }
        String idTipoFlusso = rs.getString("tipo_dettaglio_misura_id");
        String causaOstativa = rs.getString("causa_ostativa");
        return new Pdo(null, stimata, rilMese, pIvaUtente, pIvaDistributore, codContrDisp, codPratAtt, cdaziend, datiPod, tipoRettifica, motivazione, dataRilevazione, nomeFile, delibera, idTipoFlusso, regime, causaOstativa, dataImport);
    }

    private static Double getDouble(RestrictedResultSet rs, int column) throws SQLException {
        Double value;
        String valueStr = null;
        try {
            valueStr = rs.getString(column);
            value = valueStr == null ? null : Double.valueOf(valueStr);
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            String podId = rs.getString("pod_id");
            throw new RuntimeException(String.valueOf(message) + ": " + valueStr + " - " + column + " - " + podId);
        }
        return value;
    }
}

