/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Trattamento;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.homelinux.elabor.db.RecordCreator;

public class Pdo2GCreator
implements RecordCreator<Mno> {
    private static final String[] CAMPI_DATI_PDP = new String[]{"Trattamento", "Tensione", "Forfait", "GruppoMis", "Ka", "Kr", "Kp"};
    private static final String[] CAMPI_SQL_DATI_PDP = new String[]{"TRATTAMENTO_POD", "TENSIONE", "FORFAIT", "GRUPPO_MISURA", "KA", "KR", "KP"};
    private final boolean infer;
    private final DateFormat dateFormat;

    public Pdo2GCreator(boolean infer) {
        this.infer = infer;
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
    }

    @Override
    public Mno createRecord(ResultSet rs) throws SQLException {
        Date dataPrestazione;
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String flusso = rs.getString("cod_flusso");
        String codice = rs.getString("pod_id").trim().substring(0, 14);
        String delibera = rs.getString("delibera");
        String id = rs.getString("id");
        boolean stimata = flusso.equals("RFO2G") ? false : RecordCreatorHelper.getBoolean(restrictedRS, "tipo_dato");
        HashSet<String> cifre = new HashSet<String>();
        Map<String, Map<String, String>> datiPod = MisureHelper.createDatiPod(rs, true, Trattamento.O, cifre, CAMPI_DATI_PDP, CAMPI_SQL_DATI_PDP);
        String pIvaUtente = rs.getString("PIVA_DISPATCHER").trim();
        String pIvaDistributore = rs.getString("PIVA_DISTRIBUTORE").trim();
        String codContrDisp = rs.getString("CONTRATTO_DISPACCIAMENTO").trim();
        String codPratAtt = rs.getString("COD_PRATICA_ATTIVAZIONE");
        String cdaziend = rs.getString("CDAZIEND");
        Date dataRilevazione = RecordCreatorHelper.getDate(restrictedRS, "DATA_RILEVAZIONE", this.dateFormat);
        String tipoRettifica = RecordCreatorHelper.getString(restrictedRS, "TIPO_RETTIFICA");
        String motivazione = rs.getString("MOTIVAZIONE");
        String nomeFile = rs.getString("NOME_FILE");
        String regime = rs.getString("REGIME");
        if (cdaziend != null) {
            cdaziend = cdaziend.trim();
        }
        Date date = RecordCreatorHelper.getDate(restrictedRS, "data_att", this.dateFormat);
        String idTipoMisura = rs.getString("tipo_dettaglio_misura_id");
        Date dataVoltura = dataPrestazione = RecordCreatorHelper.getDataPrestazione(restrictedRS, date, this.infer, this.dateFormat);
        Misura misura = new Misura(date, stimata, 3, flusso);
        FasciaOraria fasciaMaxPotenza = FasciaOraria.F1;
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            misura.setAttiva(fascia, rs.getDouble("EA_" + fascia.name()), 0.0);
            misura.setReattiva(fascia, rs.getDouble("ER_" + fascia.name()), 0.0);
            double potenza = rs.getDouble("POT_" + fascia.name());
            misura.setPotenza(fascia, potenza, 0.0);
            if (misura.getPotenza(fasciaMaxPotenza).getNetto() < potenza) {
                fasciaMaxPotenza = fascia;
            }
            ++n3;
        }
        double potMax = rs.getDouble("POTENZA_MAX");
        if (potMax > misura.getPotenza(fasciaMaxPotenza).getNetto()) {
            misura.setPotenza(fasciaMaxPotenza, potMax, 0.0);
        }
        StatoMisure stato = StatoMisure.valueOf(rs.getInt("stato"));
        StatoMisure statoTariffeDisp = StatoMisure.valueOf(rs.getInt("stato_tariffe"));
        StatoMisure statoTariffeRese = StatoMisure.valueOf(rs.getInt("stato_tariffe_reseller"));
        String causaOstativa = rs.getString("causa_ostativa");
        return new Mno(id, flusso, codice, misura, pIvaUtente, pIvaDistributore, codContrDisp, codPratAtt, cdaziend, null, dataVoltura, datiPod, motivazione, null, null, dataRilevazione, dataPrestazione, tipoRettifica, nomeFile, delibera, idTipoMisura, stato, statoTariffeDisp, statoTariffeRese, regime, false, null, true, true, causaOstativa);
    }
}

