/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GR;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.RecordCreator;

public class MnoCreator
implements RecordCreator<Mno> {
    private static final Set<String> CIFRE = new HashSet<String>();
    private static final String[] CAMPI_DATI_PDP;
    private static final String[] CAMPI_SQL_DATI_PDP;
    private final boolean infer;
    private final DateFormat dateFormat;

    static {
        CIFRE.add("CifreAtt");
        CIFRE.add("CifreRea");
        CIFRE.add("CifrePot");
        CAMPI_DATI_PDP = new String[]{"Trattamento", "Tensione", "PotContrImp", "PotDisp", "Ka", "Kr", "Kp", "MatrAtt", "MatrRea", "MatrPot", "DataInstMisAtt", "DataInstMisRea", "DataInstMisPot", "CifreAtt", "CifreRea", "CifrePot", "GruppoMis", "Forfait"};
        CAMPI_SQL_DATI_PDP = new String[]{"TRATTAMENTO_POD", "TENSIONE", "POTENZA_CONTR_IMPEGNATA", "POTENZA_DISPONIBILE", "KA", "KR", "KP", "MATRICOLA_ATTIVA", "MATRICOLA_REATTIVA", "MATRICOLA_POTENZA", "DATA_INST_MIS_ATTIVA", "DATA_INST_MIS_REATTIVA", "DATA_INST_MIS_POTENZA", "CIFRE_ATTIVA", "CIFRE_REATTIVA", "CIFRE_POTENZA", "GRUPPO_MISURA", "FORFAIT"};
    }

    public MnoCreator(boolean infer) {
        this.infer = infer;
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
    }

    @Override
    public Mno createRecord(ResultSet rs) throws SQLException {
        StatoMisure statoTariffeRese;
        StatoMisure statoTariffeDisp;
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String flusso = restrictedRS.getString("cod_flusso");
        String id = rs.getString("id");
        String codice = rs.getString("pod_id").trim().substring(0, 14);
        Date dataInst = RecordCreatorHelper.getDate(restrictedRS, "DATA_INST_MIS_ATTIVA", this.dateFormat);
        Date dataMisura = RecordCreatorHelper.getDate(restrictedRS, "data_misura", this.dateFormat);
        Date dataVoltura = RecordCreatorHelper.getDate(restrictedRS, "data_voltura", this.dateFormat);
        Date dataPrestazione = RecordCreatorHelper.getDataPrestazione(restrictedRS, dataMisura, this.infer, this.dateFormat);
        if (StrategyHelper.MOROSITA.contains(flusso.toUpperCase())) {
            dataMisura = dataPrestazione;
        }
        dataVoltura = dataVoltura == null ? dataPrestazione : dataVoltura;
        String tipoRettifica = RecordCreatorHelper.getString(restrictedRS, "TIPO_RETTIFICA");
        Date dataRilevazione = RecordCreatorHelper.getDate(restrictedRS, "DATA_RILEVAZIONE", this.dateFormat);
        boolean stimata = flusso.equals("RNO2G") ? false : RecordCreatorHelper.getBoolean(restrictedRS, "tipo_dato");
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        Trattamento trattamento = RecordCreatorHelper.getEnum(rs, Trattamento.class, "trattamento_pod", Trattamento.F);
        int fasce = trattamento.getFasce();
        Misura misura = new Misura(dataMisura, stimata, fasce, flusso);
        FasciaOraria fasciaMaxPotenza = FasciaOraria.F1;
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            misura.setAttiva(fascia, rs.getDouble("EA_" + fascia.name()), 0.0);
            misura.setReattiva(fascia, rs.getDouble("ER_" + fascia.name()), 0.0);
            try {
                double energiaRC = rs.getDouble("ERC_" + fascia.name());
                misura.setReattivaCapacitiva(fascia, energiaRC, 0.0);
            }
            catch (SQLException energiaRC) {
                // empty catch block
            }
            try {
                double energiaRI = rs.getDouble("ERI_" + fascia.name());
                misura.setReattivaInduttiva(fascia, energiaRI, 0.0);
            }
            catch (SQLException energiaRI) {
                // empty catch block
            }
            double potenza = rs.getDouble("POT_" + fascia.name());
            misura.setPotenza(fascia, potenza, 0.0);
            if (misura.getPotenza(fasciaMaxPotenza).getNetto() < potenza) {
                fasciaMaxPotenza = fascia;
            }
            ++n3;
        }
        double potMax = rs.getDouble("POTENZA_MAX");
        if (potMax > misura.getPotenza(fasciaMaxPotenza).getNetto()) {
            misura.setPotenza(fasciaMaxPotenza, potMax, 0.0);
        }
        boolean dueG = TipoFlusso.valueOf(flusso).is2G();
        Map<String, Map<String, String>> datiPod = MisureHelper.createDatiPod(rs, dueG, trattamento, CIFRE, CAMPI_DATI_PDP, CAMPI_SQL_DATI_PDP);
        String pIvaUtente = rs.getString("PIVA_DISPATCHER").trim();
        String pIvaDistributore = rs.getString("PIVA_DISTRIBUTORE").trim();
        String codContrDisp = rs.getString("CONTRATTO_DISPACCIAMENTO").trim();
        String codPratAtt = rs.getString("COD_PRATICA_ATTIVAZIONE");
        String cdaziend = rs.getString("CDAZIEND");
        if (cdaziend != null) {
            cdaziend = cdaziend.trim();
        }
        String motivazione = restrictedRS.getString("MOTIVAZIONE");
        String tipoMisuratore = restrictedRS.getString("TIPO_MISURATORE");
        String nomeFile = restrictedRS.getString("NOME_FILE");
        Date dataMessaRegime = RecordCreatorHelper.getDate(restrictedRS, "DATA_MESSA_REGIME", this.dateFormat);
        String delibera = rs.getString("DELIBERA");
        StatoMisure stato = StatoMisure.valueOf(rs.getInt("stato"));
        try {
            statoTariffeDisp = StatoMisure.valueOf(rs.getInt("stato_tariffe"));
            statoTariffeRese = StatoMisure.valueOf(rs.getInt("stato_tariffe_reseller"));
        }
        catch (Exception exc) {
            statoTariffeDisp = null;
            statoTariffeRese = null;
        }
        String idTipoFlusso = rs.getString("tipo_dettaglio_misura_id");
        String regime = rs.getString("regime");
        boolean forfait = "SI".equals(rs.getString("forfait"));
        Date dataInizioPeriodo = RecordCreatorHelper.getDate(restrictedRS, "data_inizio_periodo", this.dateFormat);
        String causaOstativa = rs.getString("causa_ostativa");
        Mno2GR mno = new Mno2GR(id, flusso, codice, misura, pIvaUtente, pIvaDistributore, codContrDisp == null ? "" : codContrDisp, codPratAtt == null ? "" : codPratAtt, cdaziend, dataInst, dataVoltura, datiPod, motivazione, tipoMisuratore, dataMessaRegime, dataRilevazione, dataPrestazione, tipoRettifica, nomeFile, delibera, idTipoFlusso, stato, statoTariffeDisp, statoTariffeRese, regime, forfait, dataInizioPeriodo, true, false, causaOstativa);
        if (forfait && this.infer) {
            mno.setKa("1");
            mno.setKr("1");
            mno.setKp("1");
        }
        return mno;
    }
}

