/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.Mno2GE;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.RecordCreator;

public class Mno2GECreator
implements RecordCreator<Mno2GE> {
    private static final List<String> CAP_IND = Arrays.asList("C", "I");
    private final DateFormat dateFormat;
    private final String tipoDettaglio;
    private final boolean orario;

    public Mno2GECreator(String tipoDettaglio, boolean orario) {
        this.tipoDettaglio = tipoDettaglio;
        this.orario = orario;
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
    }

    @Override
    public Mno2GE createRecord(ResultSet rs) throws SQLException {
        DefaultRRS rrs = new DefaultRRS(rs);
        String codicePod = rs.getString("pod_id");
        Date data = RecordCreatorHelper.getDate(rrs, "data", this.dateFormat);
        int size = CalendarTools.getHoursOfDay(data) * 4;
        Double[] energiaOraria = new Double[size];
        int index = 1;
        while (index <= size) {
            String name = "E_" + index;
            energiaOraria[index - 1] = rs.getString(name) == null ? null : Double.valueOf(rs.getDouble(name));
            ++index;
        }
        Double[] energiaFascia = new Double[6];
        String tipoRea = rs.getString("tipo_rea");
        String spec = CAP_IND.contains(tipoRea) && !this.orario ? String.valueOf(this.tipoDettaglio) + tipoRea : this.tipoDettaglio;
        int index2 = 1;
        while (index2 <= 6) {
            String name = "E" + spec + "_F" + index2;
            energiaFascia[index2 - 1] = rs.getString(name) == null ? null : Double.valueOf(rs.getDouble(name));
            ++index2;
        }
        return new Mno2GE(codicePod, data, tipoRea, energiaOraria, energiaFascia);
    }
}

