/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.statopod.UpdateStatoPod;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class StatoRichiestaMultiUpdateHandler
implements TableMultiUpdateHandler<UpdateStatoPod> {
    StatoRichiestaMultiUpdateHandler() {
    }

    @Override
    public String getQuery() {
        return "update STATO_POD set STATO_RIC=? where CDSERVIZ=? and POD=? and DATA_MOVIMENTO=? and NUPROGRE=?";
    }

    @Override
    public boolean prepare(PreparedStatement statement, UpdateStatoPod statoPod, StatoMisure stato, String id) throws SQLException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        statement.setString(1, statoPod.getStatoRic());
        statement.setString(2, statoPod.getServizio());
        statement.setString(3, statoPod.getPod());
        statement.setString(4, StatoRichiestaMultiUpdateHandler.formatNullableDate(dateFormat, statoPod.getDataMovimento()));
        statement.setInt(5, statoPod.getNuprogre());
        return true;
    }

    private static String formatNullableDate(DateFormat dateFormat, Date date) {
        return date == null ? " " : dateFormat.format(date);
    }
}

