/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.dao.TariffeElaborateDeleteHandler;
import biz.elabor.prebilling.dao.TariffeElaborateInsertHandler;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.tariffe.Tariffa;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.db.MultiUpdateHandler;
import org.homelinux.elabor.exceptions.UnrecoverableException;

class RecordTariffeElaborateHandler
implements MultiUpdateHandler {
    private final Connection connection;
    private final ServiceStatus status;

    public RecordTariffeElaborateHandler(Connection connection, ServiceStatus status) {
        this.connection = connection;
        this.status = status;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        List<Tariffa> tariffeDispatcher = this.status.getTariffeElaborateDispatcher();
        this.recordTariffeElaborate(tariffeDispatcher, true);
        List<Tariffa> tariffeReseller = this.status.getTariffeElaborateReseller();
        this.recordTariffeElaborate(tariffeReseller, false);
    }

    private void recordTariffeElaborate(List<Tariffa> tariffeDispatcher, boolean dispatcher) throws SQLException, UnrecoverableException {
        TariffeElaborateDeleteHandler deleteHandler = new TariffeElaborateDeleteHandler(dispatcher);
        this.executeMultiUpdate(tariffeDispatcher, deleteHandler);
        TariffeElaborateInsertHandler insertHandler = new TariffeElaborateInsertHandler(dispatcher);
        this.executeMultiUpdate(tariffeDispatcher, insertHandler);
    }

    private <T> void executeMultiUpdate(List<T> tariffeDispatcher, TableMultiUpdateHandler<T> deleteHandler) throws SQLException, UnrecoverableException {
        Iterator<T> iterator;
        if (tariffeDispatcher != null && (iterator = tariffeDispatcher.iterator()).hasNext()) {
            String query = deleteHandler.getQuery();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (PreparedStatement statement = this.connection.prepareStatement(query);){
                    while (iterator.hasNext()) {
                        T item = iterator.next();
                        if (!deleteHandler.prepare(statement, item, null, null)) continue;
                        statement.addBatch();
                    }
                    statement.clearParameters();
                    statement.executeBatch();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException exc) {
                throw new UnrecoverableException(exc);
            }
        }
    }
}

