/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.ResultRecord;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractRecordStatoHandler;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.dao.TariffeNonorarieMultiUpdateHandler;
import biz.elabor.prebilling.dao.TariffeOrarieMultiUpdateHandler;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.exceptions.UnrecoverableException;
import org.homelinux.elabor.structures.listmap.ListMap;

class RecordStatoTariffeHandler
extends AbstractRecordStatoHandler {
    private final StatoContainer status;

    public RecordStatoTariffeHandler(Connection connection, StatoContainer status) {
        super(connection);
        this.status = status;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        Map<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> tariffeOrarieResult = this.status.getTariffeOrarieResult();
        for (Map.Entry<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> destinatariEntry : tariffeOrarieResult.entrySet()) {
            Destinatari destinatari = destinatariEntry.getKey();
            TariffeOrarieMultiUpdateHandler tariffeHandler = new TariffeOrarieMultiUpdateHandler(destinatari);
            for (Map.Entry statoEntry : destinatariEntry.getValue().entrySet()) {
                StatoMisure stato = (StatoMisure)((Object)statoEntry.getKey());
                List statoTariffeResult = (List)statoEntry.getValue();
                this.executeMultiUpdate(statoTariffeResult, stato, tariffeHandler);
            }
        }
        Map<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>> tariffeNonorarieResult = this.status.getTariffeNonorarieResult();
        for (Map.Entry<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>> destinatariEntry : tariffeNonorarieResult.entrySet()) {
            Destinatari destinatari = destinatariEntry.getKey();
            TariffeNonorarieMultiUpdateHandler tariffeHandler = new TariffeNonorarieMultiUpdateHandler(destinatari);
            for (Map.Entry statoEntry : destinatariEntry.getValue().entrySet()) {
                StatoMisure stato = (StatoMisure)((Object)statoEntry.getKey());
                List statoTariffeResult = (List)statoEntry.getValue();
                this.executeMultiUpdate(statoTariffeResult, stato, tariffeHandler);
            }
        }
    }
}

