/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractRecordStatoHandler;
import biz.elabor.prebilling.dao.MnoMultiUpdateHandler;
import biz.elabor.prebilling.dao.Pdo2GRMultiUpdateHandler;
import biz.elabor.prebilling.dao.PdoMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatiPodMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.dao.StatoRichiestaMultiUpdateHandler;
import biz.elabor.prebilling.model.Funzionalita;
import java.sql.Connection;
import java.sql.SQLException;
import org.homelinux.elabor.exceptions.UnrecoverableException;

class RecordStatoLettureHandler
extends AbstractRecordStatoHandler {
    private final StatoContainer status;

    public RecordStatoLettureHandler(Connection connection, StatoContainer status) {
        super(connection);
        this.status = status;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        PdoMultiUpdateHandler pdoHandler = new PdoMultiUpdateHandler(Funzionalita.LETTURE);
        MnoMultiUpdateHandler mnoHandler = new MnoMultiUpdateHandler(Funzionalita.LETTURE);
        Pdo2GRMultiUpdateHandler pdo2GRHandler = new Pdo2GRMultiUpdateHandler(Funzionalita.LETTURE);
        this.executeMultiUpdate(this.status.getPdoElaborati(), StatoMisure.ELABORATO, pdoHandler);
        this.executeMultiUpdate(this.status.getPdoSospesi(), StatoMisure.SOSPESO, pdoHandler);
        this.executeMultiUpdate(this.status.getPdoObsoleti(), StatoMisure.OBSOLETO, pdoHandler);
        this.executeMultiUpdate(this.status.getPdoEsclusi(), StatoMisure.ESCLUSO, pdoHandler);
        this.executeMultiUpdate(this.status.getRfoElaborati(), StatoMisure.ELABORATO, pdoHandler);
        this.executeMultiUpdate(this.status.getRfoSospesi(), StatoMisure.SOSPESO, pdoHandler);
        this.executeMultiUpdate(this.status.getRfoObsoleti(), StatoMisure.OBSOLETO, pdoHandler);
        this.executeMultiUpdate(this.status.getRfoEsclusi(), StatoMisure.ESCLUSO, pdoHandler);
        this.executeMultiUpdate(this.status.getPnoElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getPnoSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getPdo2GRSospesi(), StatoMisure.SOSPESO, pdo2GRHandler);
        this.executeMultiUpdate(this.status.getPdo2GRElaborati(), StatoMisure.ELABORATO, pdo2GRHandler);
        this.executeMultiUpdate(this.status.getPdo2GREsclusi(), StatoMisure.ESCLUSO, pdo2GRHandler);
        this.executeMultiUpdate(this.status.getPdo2GRObsoleti(), StatoMisure.OBSOLETO, pdo2GRHandler);
        this.executeMultiUpdate(this.status.getPnoObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getPnoEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getRnoElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getRnoSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        StatiPodMultiUpdateHandler statiPodHandler = new StatiPodMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getStatiPod(), null, statiPodHandler);
        StatoRichiestaMultiUpdateHandler statiRichiestaHandler = new StatoRichiestaMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getUpdateStatiRichiesta(), null, statiRichiestaHandler);
    }
}

