/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.LettureDeleteHandler;
import biz.elabor.prebilling.dao.LettureInsertHandler;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.db.MultiUpdateHandler;
import org.homelinux.elabor.exceptions.UnrecoverableException;

class RecordLettureHandler
implements MultiUpdateHandler {
    private final ServiceStatus status;
    private final Connection connection;
    private final PrebillingConfiguration configuration;

    public RecordLettureHandler(Connection connection, PrebillingConfiguration configuration, ServiceStatus status) {
        this.status = status;
        this.connection = connection;
        this.configuration = configuration;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        List<MisuraNonoraria> letture = this.status.getLetture();
        LettureDeleteHandler lettureDeleteHandler = new LettureDeleteHandler();
        this.executeMultiUpdate(letture, lettureDeleteHandler);
        LettureInsertHandler lettureInsertHandler = new LettureInsertHandler(this.configuration);
        this.executeMultiUpdate(letture, lettureInsertHandler);
    }

    private void executeMultiUpdate(List<MisuraNonoraria> items, TableMultiUpdateHandler<MisuraNonoraria> handler) throws SQLException, UnrecoverableException {
        Iterator<MisuraNonoraria> iterator;
        if (items != null && (iterator = items.iterator()).hasNext()) {
            String query = handler.getQuery();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (PreparedStatement statement = this.connection.prepareStatement(query);){
                    while (iterator.hasNext()) {
                        MisuraNonoraria item = iterator.next();
                        if (!handler.prepare(statement, item, null, null)) continue;
                        statement.addBatch();
                    }
                    statement.clearParameters();
                    statement.executeBatch();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException exc) {
                throw new UnrecoverableException(exc);
            }
        }
    }
}

