/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.services.letture.PodConsumi;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class PodConsumiCreator
implements RecordCreator<PodConsumi> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();

    @Override
    public PodConsumi createRecord(ResultSet rs) throws SQLException {
        String codice = rs.getString("cdprerif").trim();
        String cdazirif = rs.getString("cdazirif").trim();
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        Date inizio = RecordCreatorHelper.getDate(restrictedRS, "inizio", this.dateFormat);
        Date fine = RecordCreatorHelper.getDate(restrictedRS, "fine", this.dateFormat);
        String cdcomist = rs.getString("CDCOMIST");
        String codiceOfferta = rs.getString("CODICE_OFFERTA");
        Date dtinifor = RecordCreatorHelper.getDate(restrictedRS, "dtinifor", this.dateFormat);
        double attF1 = rs.getDouble("att_f1");
        double attF2 = rs.getDouble("att_f2");
        double attF3 = rs.getDouble("att_f3");
        return new PodConsumi(codice, cdazirif, inizio, fine, cdcomist, codiceOfferta, dtinifor, attF1, attF2, attF3);
    }
}

