/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.JdbcMisureDao;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.misure.Mno;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

class MnoFittiziaMUH
implements TableMultiUpdateHandler<Mno> {
    private final String defaultAzienda;

    public MnoFittiziaMUH(String defaultAzienda) {
        this.defaultAzienda = defaultAzienda;
    }

    @Override
    public String getQuery() {
        return "UPDATE misure_pod_non_orari SET cdaziend=? WHERE  cod_flusso in ('PNO2G','RNO2G') AND  pod_id=? AND  to_char(data_misura,'yyyy-mm')=? AND  trim(cdaziend)=?";
    }

    @Override
    public boolean prepare(PreparedStatement statement, Mno mno, StatoMisure stato, String id) throws SQLException {
        statement.setString(1, mno.getCdaziend());
        statement.setString(2, mno.getCodicePod());
        Date dataMisura = mno.getDataMisura();
        statement.setString(3, JdbcMisureDao.DATE_MONTH_FORMAT.format(dataMisura));
        statement.setString(4, this.defaultAzienda);
        return true;
    }
}

