/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;

class LettureInsertHandler
implements TableMultiUpdateHandler<MisuraNonoraria> {
    private final PrebillingConfiguration configuration;

    public LettureInsertHandler(PrebillingConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getQuery() {
        return "INSERT INTO letture (pod, data, ka, ea_f1, ea_f2, ea_f3, tipo, piva_distributore, matricola_attiva, id_riferimento, cod_flusso) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public boolean prepare(PreparedStatement ps, MisuraNonoraria item, StatoMisure stato, String id) throws SQLException {
        ps.setString(1, item.getCodicePod());
        ps.setDate(2, new Date(item.getDataMisura().getTime()));
        double ka = item.getKa() == null ? 1.0 : item.getKa().doubleValue();
        ps.setDouble(3, ka);
        Misura misura = item.getMisura();
        boolean trunking = this.configuration.isTrunking();
        int nCifreAttiva = this.configuration.getNCifreAttiva(ka);
        double nettoF1 = misura.getAttiva(FasciaOraria.F1).getNetto();
        double attivaF1 = trunking ? MathUtils.floor(nettoF1, nCifreAttiva) : nettoF1;
        double nettoF2 = misura.getAttiva(FasciaOraria.F2).getNetto();
        double attivaF2 = trunking ? MathUtils.floor(nettoF2, nCifreAttiva) : nettoF2;
        double nettoF3 = misura.getAttiva(FasciaOraria.F3).getNetto();
        double attivaF3 = trunking ? MathUtils.floor(nettoF3, nCifreAttiva) : nettoF3;
        ps.setDouble(4, attivaF1);
        ps.setDouble(5, attivaF2);
        ps.setDouble(6, attivaF3);
        String raccolta = item.getRaccolta();
        String matricolaAtt = item.getMatricolaAtt();
        if (matricolaAtt == null) {
            matricolaAtt = "";
        }
        boolean stimata = misura.isStimata();
        String codiceFlusso = item.getCodiceFlusso();
        boolean calcolata = item.isCalcolata();
        ps.setString(7, TariffeHelper.getTipoLettura(stimata, codiceFlusso, raccolta, matricolaAtt, calcolata));
        ps.setString(8, item.getPivaDistributore());
        ps.setString(9, StringUtils.isEmpty(matricolaAtt) ? " " : matricolaAtt);
        Iterator<String> idIterator = item.getId().iterator();
        ps.setString(10, idIterator.hasNext() ? idIterator.next() : "0");
        ps.setString(11, codiceFlusso);
        return true;
    }
}

