/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.dao.JdbcPrebillingDao;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.NotDeletableException;

public class JdbcPrebillingDaoTest
extends TestCase {
    private static void resetDb(JdbcPrebillingDao dao) throws NotDeletableException {
        dao.executeDelete("delete from stime");
        dao.executeDelete("delete from fasce");
    }

    public void testGetCalendarioFasce() throws DuplicateKeyException, DataNotFoundException, NotDeletableException {
        TestConfiguration configuration = new TestConfiguration();
        JdbcPrebillingDao dao = new JdbcPrebillingDao(configuration);
        JdbcPrebillingDaoTest.resetDb(dao);
        try {
            dao.getCalendarioFasce("1", 2017, Month.JUNE);
            JdbcPrebillingDaoTest.fail("non rilevato calendario inesistente");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dao.executeInsert("insert into fasce values (1, 2017, 6, 1, 1, 1)");
        try {
            dao.getCalendarioFasce("1", 2017, Month.JUNE);
            JdbcPrebillingDaoTest.fail("non rilevato calendario incompleto");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int giorno = 1;
        int ora = 3;
        String inserts = "";
        do {
            inserts = String.valueOf(inserts) + "insert into fasce values (1, 2017, 6," + giorno + ", " + ora + ", 1);";
            if (++ora <= 24) continue;
            ora = 1;
            ++giorno;
        } while (giorno <= 30);
        dao.executeInsert(inserts);
        try {
            dao.getCalendarioFasce("1", 2017, Month.JUNE);
            JdbcPrebillingDaoTest.fail("non rilevato calendario incompleto");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dao.executeInsert("insert into fasce values (1, 2017, 6, 1, 2, 1)");
        dao.getCalendarioFasce("1", 2017, Month.JUNE);
    }
}

