/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.misure.model.fasce.CalendarioFasce;
import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.CalendarioFasceOrario;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.dao.AbstractJdbcMisureDao;
import biz.elabor.prebilling.common.dao.ApplicazioneCreator;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.dao.creator.ApplicazioneResellerCreator;
import biz.elabor.prebilling.dao.creator.CalendarioFasceCreator;
import biz.elabor.prebilling.dao.creator.DispatchingFlussoCreator;
import biz.elabor.prebilling.dao.creator.MisureTypeCreator;
import biz.elabor.prebilling.dao.creator.OffertaCommercialeCreator;
import biz.elabor.prebilling.dao.creator.OffertaCreator;
import biz.elabor.prebilling.dao.creator.ResellerCreator;
import biz.elabor.prebilling.dao.creator.StatoCreator;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.MisuraType;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.tariffe.ApplicazioneReseller;
import biz.elabor.prebilling.services.StrategyHelper;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class JdbcPrebillingDao
extends AbstractJdbcMisureDao
implements PrebillingDao {
    private static final String GET_CALENDARIO_FASCE = "SELECT * FROM fasce WHERE ID_CALENDARIO = :id: AND anno = :anno AND mese = :mese ORDER BY giorno, ora";
    private static final String INSERT_FASCIA_ORARIA = "INSERT INTO fasce (ID_CALENDARIO, anno, mese, giorno, ora, fascia) VALUES (:id:, :anno, :mese, :giorno, :ora, :fascia) ";
    private static final String DELETE_CALENDARIO_FASCIE_ORARIE = "DELETE FROM fasce WHERE ID_CALENDARIO = :id: AND anno = :anno";
    private static final String GET_OFFERTE = "SELECT * FROM offerte ORDER BY indice";
    private static final String GET_OFFERTA = "SELECT * FROM offerte WHERE indice = :indice";
    private static final String INSERT_OFFERTA = "INSERT INTO offerte (indice, mercato, zona) VALUES (:indice, :mercato, :zona)";
    private static final String DELETE_OFFERTA = "DELETE FROM offerte WHERE indice = :indice";
    private static final String UPDATE_OFFERTA = "UPDATE offerte SET mercato = :mercato, zona = :zona WHERE indice = :indice";
    private static final String GET_SPREAD_APPLICATION = "SELECT * FROM applicazioni ORDER BY tipo";
    private static final String INSERT_APPLICAZIONE = "INSERT INTO applicazioni (tipo, spread) VALUES (:tipo, :spread)";
    private static final String GET_APPLICAZIONE = "SELECT * FROM applicazioni WHERE tipo = :tipo";
    private static final String DELETE_APPLICAZIONE = "DELETE FROM applicazioni WHERE tipo = :tipo";
    private static final String UPDATE_APPLICAZIONE = "UPDATE applicazioni SET spread = :spread WHERE tipo = :tipo";
    private static final String UPDATE_STATO = "UPDATE stato SET tipostato = :tipostato, data = :data, id_log = :id_log WHERE funzionalita = :funzionalita AND cdaziend=:cdaziend";
    private static final String GET_STATO = "SELECT * FROM stato WHERE funzionalita = :funzionalita AND tipostato != 'NO_ESECUZIONE'";
    private static final String INSERT_STATO = "INSERT INTO stato (funzionalita, cdaziend, tipostato, data, id_log) VALUES (:funzionalita, :cdaziend, :tipostato, :data, :id_log)";
    private final DateFormat longDateFormat = StrategyHelper.getLongDateFormat();

    public JdbcPrebillingDao(PrebillingConfiguration configuration) {
        super(configuration.getPrebillingHost(), configuration.getPrebillingType(), configuration.getPrebillingDbName(), configuration.getPrebillingDbUser(), configuration.getPrebillingDbPassword());
    }

    @Override
    public CalendarioFasceMensile getCalendarioFasce(String id, int anno, Month mese) throws DataNotFoundException {
        CalendarioFasceMensile record;
        QueryTemplate query = new QueryTemplate(GET_CALENDARIO_FASCE);
        query.replace(":id:", id);
        query.replace(":anno", anno);
        query.replace(":mese", mese.getIndex());
        CalendarioFasceCreator creator = new CalendarioFasceCreator();
        String key = String.valueOf(id) + "/" + anno + "/" + (Object)((Object)mese);
        try {
            record = this.getRecord(query, creator, "fasce.notfound", key, false);
        }
        catch (DataAccessException exc) {
            throw new DataNotFoundException("fasce.notfound", key);
        }
        return record;
    }

    @Override
    public void saveCalendarioFasce(CalendarioFasce calendario) {
        String id = calendario.getId();
        int anno = calendario.getAnno();
        this.deleteCalendarioFasce(id, anno);
        for (CalendarioFasceMensile fascia : calendario) {
            this.saveCalendarioFasceMensile(fascia);
        }
    }

    protected void deleteCalendarioFasce(String id, int anno) {
        QueryTemplate query = new QueryTemplate(DELETE_CALENDARIO_FASCIE_ORARIE);
        query.replace(":id:", id);
        query.replace(":anno", anno);
        this.execute(query);
    }

    protected void saveCalendarioFasceMensile(CalendarioFasceMensile mensile) {
        this.startTransaction();
        for (CalendarioFasceGiornaliero giornaliero : mensile) {
            for (CalendarioFasceOrario orario : giornaliero) {
                String id = orario.getId();
                int anno = orario.getAnno();
                Month mese = orario.getMese();
                int giorno = orario.getGiorno();
                int ora = orario.getOra();
                FasciaOraria fascia = orario.getFascia();
                QueryTemplate query = new QueryTemplate(INSERT_FASCIA_ORARIA);
                query.replace(":id:", id);
                query.replace(":anno", anno);
                query.replace(":mese", mese.getIndex());
                query.replace(":giorno", giorno);
                query.replace(":ora", ora);
                query.replace(":fascia", fascia.ordinal());
                this.execute(query);
            }
        }
        this.commit();
    }

    @Override
    public List<Offerta> getOfferte() {
        QueryTemplate query = new QueryTemplate(GET_OFFERTE);
        OffertaCreator creator = new OffertaCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public Offerta getOfferta(int indice) throws DataNotFoundException {
        OffertaCreator creator = new OffertaCreator();
        QueryTemplate query = new QueryTemplate(GET_OFFERTA);
        query.replace(":indice", indice);
        return this.getRecord(query, creator, "offerta.notfound", String.valueOf(indice));
    }

    @Override
    public void insertOfferta(Offerta offerta) throws DuplicateKeyException {
        QueryTemplate query = new QueryTemplate(INSERT_OFFERTA);
        String indice = offerta.getCodIndiceEnergetico();
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        query.replace(":indice", indice);
        query.replace(":mercato", mercato);
        query.replace(":zona", zona);
        this.executeInsert(query);
    }

    @Override
    public void deleteOfferta(Offerta offerta) throws NotDeletableException {
        QueryTemplate query = new QueryTemplate(DELETE_OFFERTA);
        String indice = offerta.getCodIndiceEnergetico();
        query.replace(":indice", indice);
        this.executeDelete(query);
    }

    @Override
    public void updateOfferta(Offerta offerta) throws DataNotFoundException, DuplicateKeyException {
        QueryTemplate query = new QueryTemplate(UPDATE_OFFERTA);
        String indice = offerta.getCodIndiceEnergetico();
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        query.replace(":indice", indice);
        query.replace(":mercato", mercato);
        query.replace(":zona", zona);
        this.executeUpdate(query);
    }

    @Override
    public List<Reseller> getResellers() {
        QueryTemplate query = new QueryTemplate("select * from resellers order by codice");
        ResellerCreator creator = new ResellerCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public Reseller getReseller(String codice) {
        Reseller reseller;
        QueryTemplate query = new QueryTemplate("select * from resellers where codice = :codice");
        query.replace(":codice", codice);
        ResellerCreator creator = new ResellerCreator();
        try {
            reseller = this.getRecord(query, creator, null, null);
        }
        catch (DataNotFoundException e2) {
            reseller = new Reseller("*", "tutti", null, false, false);
        }
        return reseller;
    }

    @Override
    public Reseller getResellerByPiva(String pIvaReseller) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("select * from resellers where rownum = 1 AND p_iva = :pIvaReseller");
        query.replace(":pIvaReseller", pIvaReseller);
        ResellerCreator creator = new ResellerCreator();
        return this.getRecord(query, creator, null, null);
    }

    @Override
    public Map<String, Applicazione> getApplicazioni() {
        QueryTemplate query = new QueryTemplate(GET_SPREAD_APPLICATION);
        ApplicazioneCreator creator = new ApplicazioneCreator();
        LinkedHashMap applicazioni = new LinkedHashMap();
        return this.buildMap(applicazioni, query, creator);
    }

    @Override
    public void insertApplicazione(Applicazione applicazione) throws DuplicateKeyException {
        QueryTemplate query = new QueryTemplate(INSERT_APPLICAZIONE);
        int tipo = applicazione.getTipo();
        boolean spread = applicazione.isSpread();
        query.replace(":tipo", tipo);
        query.replace(":spread", spread);
        this.executeInsert(query);
    }

    @Override
    public Applicazione getApplicazione(int tipo) throws DataNotFoundException {
        ApplicazioneCreator creator = new ApplicazioneCreator();
        QueryTemplate query = new QueryTemplate(GET_APPLICAZIONE);
        query.replace(":tipo", tipo);
        return this.getRecord(query, creator, "applicazione.notfound", String.valueOf(tipo));
    }

    @Override
    public void deleteApplicazione(Applicazione applicazione) throws NotDeletableException {
        QueryTemplate query = new QueryTemplate(DELETE_APPLICAZIONE);
        int tipo = applicazione.getTipo();
        query.replace(":tipo", tipo);
        this.executeDelete(query);
    }

    @Override
    public void updateApplicazione(Applicazione applicazione) throws DataNotFoundException, DuplicateKeyException {
        QueryTemplate query = new QueryTemplate(UPDATE_APPLICAZIONE);
        int tipo = applicazione.getTipo();
        boolean spread = applicazione.isSpread();
        query.replace(":tipo", tipo);
        query.replace(":spread", spread);
        this.executeUpdate(query);
    }

    @Override
    public StatoElaborazione getStato(Funzionalita funzionalita, List<String> ambiti) throws DataNotFoundException {
        String template = GET_STATO;
        if (!ambiti.isEmpty()) {
            template = String.valueOf(template) + " AND (";
            String connettore = "";
            for (String ambito : ambiti) {
                template = String.valueOf(template) + connettore;
                template = String.valueOf(template) + "cdaziend LIKE '" + ambito + "'";
                connettore = " OR ";
            }
            template = String.valueOf(template) + ")";
        }
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":funzionalita", funzionalita.name());
        StatoCreator creator = new StatoCreator();
        return this.getRecord(query, creator, null, funzionalita.name());
    }

    @Override
    public void saveStato(Funzionalita funzionalita, String azienda, TipoStato stato, Date date, String idEsecuzione) {
        try {
            try {
                this.updateStato(funzionalita, azienda, stato, date, idEsecuzione);
            }
            catch (DataNotFoundException exc) {
                this.insertStato(funzionalita, azienda, stato, date, idEsecuzione);
            }
        }
        catch (DuplicateKeyException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void updateStato(Funzionalita funzionalita, String azienda, TipoStato tipoStato, Date data, String idEsecuzione) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate(UPDATE_STATO);
        query.replace(":funzionalita", funzionalita.name());
        query.replace(":cdaziend", azienda);
        query.replace(":tipostato", tipoStato.name());
        query.replace(":data", data, this.longDateFormat);
        query.replace(":id_log", idEsecuzione);
        try {
            this.executeUpdate(query);
        }
        catch (DuplicateKeyException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void insertStato(Funzionalita funzionalita, String azienda, TipoStato tipoStato, Date data, String idEsecuzione) throws DuplicateKeyException {
        QueryTemplate query = new QueryTemplate(INSERT_STATO);
        query.replace(":funzionalita", funzionalita.name());
        query.replace(":cdaziend", azienda);
        query.replace(":tipostato", tipoStato.name());
        query.replace(":data", data, this.longDateFormat);
        query.replace(":id_log", idEsecuzione);
        this.executeInsert(query);
    }

    @Override
    public DispatchingFlussi getDispatchingFlussi() {
        DispatchingFlussi map = new DispatchingFlussi();
        QueryTemplate query = new QueryTemplate("SELECT * FROM dispatching_flussi");
        DispatchingFlussoCreator creator = new DispatchingFlussoCreator();
        this.buildMap(map, query, creator);
        return map;
    }

    @Override
    public SafeMap<String, OffertaCommerciale> getOfferteCommerciali() {
        ErrorWrapper safeMapError = new ErrorWrapper("offertacommerciale", ErroriElaborazione.OFFERTA_COMMERCIALE_NOTFOUND);
        DefaultSafeMap map = new DefaultSafeMap(safeMapError);
        QueryTemplate query = new QueryTemplate("select * from offerte_commerciali");
        OffertaCommercialeCreator creator = new OffertaCommercialeCreator();
        return this.buildMap(map, query, creator);
    }

    @Override
    public Map<String, String> getMisureType() {
        QueryTemplate query = new QueryTemplate("SELECT * FROM tipi_dettagli_misure");
        MisureTypeCreator creator = new MisureTypeCreator();
        List<MisuraType> records = this.getRecords(query, creator);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (MisuraType record : records) {
            String id = record.getId();
            String tipo = record.getTipo();
            map.put(id, tipo);
        }
        return map;
    }

    @Override
    public Iterable<ApplicazioneReseller> getApplicazioniReseller() {
        QueryTemplate query = new QueryTemplate("select * from applicazioni_reseller order by cdaziend, id_app_dispatcher");
        ApplicazioneResellerCreator creator = new ApplicazioneResellerCreator();
        return this.getRecords(query, creator);
    }
}

