/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.AbstractJdbcMisureDao;
import biz.elabor.prebilling.common.dao.BasicDaoHelper;
import biz.elabor.prebilling.common.dao.MultiPuntoOptionCreator;
import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.dao.MultipuntoEntryCreator;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.dao.PrebillingExceptionHandler;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.AziendaExtractor;
import biz.elabor.prebilling.dao.CodicePodExtractor;
import biz.elabor.prebilling.dao.DateCreator;
import biz.elabor.prebilling.dao.DatiMisura;
import biz.elabor.prebilling.dao.DistributoreSotteso;
import biz.elabor.prebilling.dao.DistributoreSottesoCreator;
import biz.elabor.prebilling.dao.JdbcStatoPod;
import biz.elabor.prebilling.dao.KeyTariffaElaborataCreator;
import biz.elabor.prebilling.dao.LastMisuraCreator;
import biz.elabor.prebilling.dao.ListVolturaIVBuilder;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.dao.MultipuntoListBuilder;
import biz.elabor.prebilling.dao.PartitionCreator;
import biz.elabor.prebilling.dao.PrestazioneCreator;
import biz.elabor.prebilling.dao.RaggruppamentoExtractor;
import biz.elabor.prebilling.dao.RecordLettureHandler;
import biz.elabor.prebilling.dao.RecordResellerUpdateHandler;
import biz.elabor.prebilling.dao.RecordStatoConsolidamentoHandler;
import biz.elabor.prebilling.dao.RecordStatoLettureHandler;
import biz.elabor.prebilling.dao.RecordStatoMisureHandler;
import biz.elabor.prebilling.dao.RecordStatoSwitchHandler;
import biz.elabor.prebilling.dao.RecordStatoTariffeHandler;
import biz.elabor.prebilling.dao.RecordStatoVoltureHandler;
import biz.elabor.prebilling.dao.RecordTariffeElaborateHandler;
import biz.elabor.prebilling.dao.Ricalendarizzazione;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.dao.TipoDettaglioOrario;
import biz.elabor.prebilling.dao.ValorePiccoCreator;
import biz.elabor.prebilling.dao.WrapStatoPod;
import biz.elabor.prebilling.dao.creator.AliquotePerditeCreator;
import biz.elabor.prebilling.dao.creator.ComuneCreator;
import biz.elabor.prebilling.dao.creator.DatiRettificaCreator;
import biz.elabor.prebilling.dao.creator.FlussoResellerCreator;
import biz.elabor.prebilling.dao.creator.LettureCreator;
import biz.elabor.prebilling.dao.creator.Mno2GECreator;
import biz.elabor.prebilling.dao.creator.MnoCreator;
import biz.elabor.prebilling.dao.creator.Pdo2GCreator;
import biz.elabor.prebilling.dao.creator.PdoCreator;
import biz.elabor.prebilling.dao.creator.PraGiornalieroCreator;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.dao.creator.RicalendarizzazioneCreator;
import biz.elabor.prebilling.dao.creator.RnoCreator;
import biz.elabor.prebilling.dao.creator.SnfCreator;
import biz.elabor.prebilling.dao.creator.SofCreator;
import biz.elabor.prebilling.dao.creator.StatoPodCreator;
import biz.elabor.prebilling.dao.creator.VirtualPivCreator;
import biz.elabor.prebilling.dao.creator.VoltureIVCreator;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.pra.PraGiornaliero;
import biz.elabor.prebilling.model.pra.PraMensile;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.tariffe.Comune;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.reseller.FlussoReseller;
import biz.elabor.prebilling.services.tariffe.AliquotaPerdite;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.ValorePicco;
import biz.elabor.prebilling.services.volture.model.VolturaIV;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.io.IOException;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.CalendarCreator;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;
import org.homelinux.elabor.structures.safe.SimpleSafeMap;
import org.homelinux.elabor.structures.setmap.SetMap;
import org.homelinux.elabor.structures.setmap.SetMapKey;
import org.homelinux.elabor.structures.setmap.TreeSetMapKey;
import org.homelinux.elabor.tools.StringUtils;

public class JdbcMisureDao
extends AbstractJdbcMisureDao
implements MisureDao {
    private static final String[] FLUSSI_VNO = new String[]{"VNO", "VNO2G"};
    private static final String[] FLUSSI_SNM = new String[]{"SNM", "SNM2G"};
    private static final String DATE_CLAUSE_XML = "to_char(data_misura,'yyyymmdd') <= :data_fine: AND to_char(data_misura,'yyyymmdd') >= :data_inizio: AND";
    private static final String DATE_CLAUSE_SMIS_XML = "((to_char(data_misura,'yyyymmdd') <= :data_fine: AND to_char(data_misura,'yyyymmdd') >= :data_inizio:) OR (to_char(data_misura,'yyyymmdd') = :data_extra: AND raccolta='M')) AND";
    private static final String DATE_CLAUSE_PDO_XML = "to_char(mpe.data,'yyyymmdd') <= :data_fine: AND to_char(mpe.data,'yyyymmdd') >= :data_inizio: AND";
    private static final String DATE_CLAUSE_FUN_XML = "to_char(data_inizio,'yyyymmdd') <= :data_fine: AND to_char(data_inizio,'yyyymmdd') >= :data_inizio: AND";
    public static final DateFormat DATE_MONTH_FORMAT = new SimpleDateFormat("yyyy-MM");
    private static final DateFormat DATE_FORMAT_MISURE = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DATE_FORMAT_DIESIS = new SimpleDateFormat("yyyyMMdd");
    private static final Iterable<StatoMisure> STATI_PDO = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO, StatoMisure.ELABORATO);
    private String queryPdoXml;
    private String queryPdoMese;
    private String queryPdoTariffeMese;
    private String queryPnoTariffeMese;
    private String queryPnoConsumiMese;
    private String queryPdoFinoMese;
    private String queryTestateTariffe;
    private String queryPdo2GR;
    private String queryPdo2GRDaA;
    private String queryPdo2GRXml;
    private String queryPnoPeriodoXml;
    private String queryPnoPeriodoMese;
    private String queryPnoElaborati;
    private String queryPdo2GRElaborati;
    private String queryPnoConsolidamento;
    private String queryPdoConsolidamento;
    private String queryPnoSoTardivo;
    private String queryPdo2GRSoTardivo;
    private String queryPnoPraticaTardivaLetture;
    private String queryPdo2GRPraticaTardivaLetture;
    private String queryPnoLateProcessing;
    private String queryPnoCP1LateProcessing;
    private String queryVnoLateProcessing;
    private String queryPdo2GRLateProcessing;
    private String queryPdo2GRCP1LateProcessing;
    private String queryPnoTecnicheMese;
    private String queryPnoSospette;
    private String queryPnoXmlPod;
    private String queryRnoXmlPod;
    private String queryVno;
    private String queryPdo2GRV;
    private String queryMnoXml;
    private String queryVnoPratica;
    private String querySnm;
    private String querySnf;
    private String querySnfXml;
    private String querySof;
    private String queryRno;
    private String queryRfo;
    private String queryRfoXml;
    private String queryPnoRiallineamento;
    private String querySmis;
    private String query2gea;
    private String query2ger;
    private String querypnoea;
    private String querypnoer;
    private String querypdoea;
    private String querypdoer;
    private String querypdo2grea;
    private String querypdo2grer;
    private String querypno2geaSingle;
    private String querypno2gerSingle;
    private String querypdo2geaSingle;
    private String querypdo2gerSingle;
    private String queryRsnRnv;
    private String queryRnvXml;
    private String queryRsnXml;
    private String queryRnoXml;
    private Set<String> prestazioniIgnorate;
    private PrebillingConfiguration configuration;
    private String queryPdoSingle;
    private String queryPdoConsolidato;
    private String queryPdoXmlPod;
    private String queryRfoXmlPod;
    private String queryRnvXmlPod;
    private String queryRsnXmlPod;
    private String queryVnoXmlPod;
    private String querySnmXmlPod;
    private String queryVoltureIV;
    private String queryVolturaIV;
    private String queryMnoPraticaTardiva;
    private String queryMo2GRPraticaTardiva;
    private String queryMnoPrestazioni;
    private String queryMnoPrestazioniOrfane;

    public JdbcMisureDao(PrebillingConfiguration configuration) throws IOException {
        super(configuration.getMisureHost(), configuration.getMisureType(), configuration.getMisureDbName(), configuration.getMisureDbUser(), configuration.getMisureDbPassword());
        ClassLoader classLoader = JdbcMisureDao.class.getClassLoader();
        this.queryPdoXml = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-xml.sql");
        this.queryPdoMese = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-mese.sql");
        this.queryPdoTariffeMese = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-tariffe-mese.sql");
        this.queryPnoTariffeMese = JdbcMisureDao.loadTemplate(classLoader, "query-pno-tariffe-mese.sql");
        this.queryPnoConsumiMese = JdbcMisureDao.loadTemplate(classLoader, "query-pno-consumi-mese.sql");
        this.queryTestateTariffe = JdbcMisureDao.loadTemplate(classLoader, "query-testate-tariffe.sql");
        this.queryPdoFinoMese = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-fino-mese.sql");
        this.queryPdo2GR = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr.sql");
        this.queryPdo2GRDaA = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-da-a.sql");
        this.queryPdo2GRXml = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-xml.sql");
        this.queryPnoPeriodoXml = JdbcMisureDao.loadTemplate(classLoader, "query-pno-periodo-xml.sql");
        this.queryPnoSoTardivo = JdbcMisureDao.loadTemplate(classLoader, "query-pno-so-tardivo.sql");
        this.queryPnoPraticaTardivaLetture = JdbcMisureDao.loadTemplate(classLoader, "query-pno-pratica-tardiva-letture.sql");
        this.queryPdo2GRPraticaTardivaLetture = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-pratica-tardiva-letture.sql");
        this.queryPnoLateProcessing = JdbcMisureDao.loadTemplate(classLoader, "query-pno-lateprocessing.sql");
        this.queryPnoCP1LateProcessing = JdbcMisureDao.loadTemplate(classLoader, "query-pno-cp1-lateprocessing.sql");
        this.queryVnoLateProcessing = JdbcMisureDao.loadTemplate(classLoader, "query-vno-lateprocessing.sql");
        this.queryPdo2GRLateProcessing = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-lateprocessing.sql");
        this.queryPdo2GRCP1LateProcessing = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-cp1-lateprocessing.sql");
        this.queryPdo2GRSoTardivo = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-so-tardivo.sql");
        this.queryPnoPeriodoMese = JdbcMisureDao.loadTemplate(classLoader, "query-pno-periodo-mese.sql");
        this.queryPnoElaborati = JdbcMisureDao.loadTemplate(classLoader, "query-pno-elaborati.sql");
        this.queryPdo2GRElaborati = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gr-elaborati.sql");
        this.queryPnoConsolidamento = JdbcMisureDao.loadTemplate(classLoader, "query-pno-consolidamento.sql");
        this.queryPdoConsolidamento = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-consolidamento.sql");
        this.queryPnoRiallineamento = JdbcMisureDao.loadTemplate(classLoader, "query-pno-riallineamento.sql");
        this.queryPnoTecnicheMese = JdbcMisureDao.loadTemplate(classLoader, "query-pno-tecniche-mese.sql");
        this.queryPnoSospette = JdbcMisureDao.loadTemplate(classLoader, "query-pno-sospette.sql");
        this.queryVnoPratica = JdbcMisureDao.loadTemplate(classLoader, "query-vno-pratica.sql");
        this.queryVno = JdbcMisureDao.loadTemplate(classLoader, "query-vno.sql");
        this.queryPdo2GRV = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2g-r-v.sql");
        this.queryMnoXml = JdbcMisureDao.loadTemplate(classLoader, "query-mno-xml.sql");
        this.querySnm = JdbcMisureDao.loadTemplate(classLoader, "query-snm.sql");
        this.querySnf = JdbcMisureDao.loadTemplate(classLoader, "query-snf.sql");
        this.querySnfXml = JdbcMisureDao.loadTemplate(classLoader, "query-snf-xml.sql");
        this.querySof = JdbcMisureDao.loadTemplate(classLoader, "query-sof.sql");
        this.queryRno = JdbcMisureDao.loadTemplate(classLoader, "query-rno.sql");
        this.queryRfo = JdbcMisureDao.loadTemplate(classLoader, "query-rfo.sql");
        this.queryRfoXml = JdbcMisureDao.loadTemplate(classLoader, "query-rfo-xml.sql");
        this.querySmis = JdbcMisureDao.loadTemplate(classLoader, "query-smis.sql");
        this.query2gea = JdbcMisureDao.loadTemplate(classLoader, "query-2gea.sql");
        this.query2ger = JdbcMisureDao.loadTemplate(classLoader, "query-2ger.sql");
        this.querypnoea = JdbcMisureDao.loadTemplate(classLoader, "query-pno-ea.sql");
        this.querypnoer = JdbcMisureDao.loadTemplate(classLoader, "query-pno-er.sql");
        this.querypdoea = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-ea.sql");
        this.querypdoer = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-er.sql");
        this.querypdo2grea = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2gea.sql");
        this.querypdo2grer = JdbcMisureDao.loadTemplate(classLoader, "query-pdo2ger.sql");
        this.querypno2geaSingle = JdbcMisureDao.loadTemplate(classLoader, "query-2gea-single.sql").replaceAll(":tabella_princ", "misure_pod_non_orari").replaceAll(":tabella_sec", "misure_pod_non_orari_ea");
        this.querypno2gerSingle = JdbcMisureDao.loadTemplate(classLoader, "query-2ger-single.sql").replaceAll(":tabella_princ", "misure_pod_non_orari").replaceAll(":tabella_sec", "misure_pod_non_orari_er");
        this.querypdo2geaSingle = JdbcMisureDao.loadTemplate(classLoader, "query-2gea-single.sql").replaceAll(":tabella_princ", "misure_pod_orari").replaceAll(":tabella_sec", "misure_pod_orari_ea");
        this.querypdo2gerSingle = JdbcMisureDao.loadTemplate(classLoader, "query-2ger-single.sql").replaceAll(":tabella_princ", "misure_pod_orari").replaceAll(":tabella_sec", "misure_pod_orari_er");
        this.queryRsnRnv = JdbcMisureDao.loadTemplate(classLoader, "query-rsnrnv.sql");
        this.queryRnvXml = JdbcMisureDao.loadTemplate(classLoader, "query-rnv-xml.sql");
        this.queryRsnXml = JdbcMisureDao.loadTemplate(classLoader, "query-rsn-xml.sql");
        this.queryRnoXml = JdbcMisureDao.loadTemplate(classLoader, "query-rno-xml.sql");
        this.queryPdoSingle = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-single.sql");
        this.queryPdoConsolidato = JdbcMisureDao.loadTemplate(classLoader, "query-pdo-consolidato.sql");
        this.queryVoltureIV = JdbcMisureDao.loadTemplate(classLoader, "query-volture-iv.sql");
        this.queryVolturaIV = JdbcMisureDao.loadTemplate(classLoader, "query-voltura-iv.sql");
        this.queryMnoPraticaTardiva = JdbcMisureDao.loadTemplate(classLoader, "query-mno-pratica-tardiva.sql");
        this.queryMo2GRPraticaTardiva = JdbcMisureDao.loadTemplate(classLoader, "query-mo2gr-pratica-tardiva.sql");
        this.queryMnoPrestazioni = JdbcMisureDao.loadTemplate(classLoader, "query-mno-prestazioni.sql");
        this.queryMnoPrestazioniOrfane = JdbcMisureDao.loadTemplate(classLoader, "query-mno-prestazioni-orfane.sql");
        this.prestazioniIgnorate = configuration.getPrestazioniIgnorate();
        this.configuration = configuration;
    }

    @Override
    public List<Pdo> getPdoXml(String azienda, TipoFlusso flusso, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod, String regime, Partition partition, TalkManager talkManager) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPdoXml, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        template = JdbcMisureDao.replaceRegimeClause(template, regime);
        template = JdbcMisureDao.replaceRaccoltaClause(template, raccolta);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, stato);
        List<String> flussi = Arrays.asList(flusso.name());
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, true, false, creator, this);
    }

    @Override
    public List<Partition> getPdoXmlMonth(String azienda, String regime, TipoFlusso tipoFlusso, String currPrefix, int prefixLength, FiltriXml filtri) {
        String codicePod = filtri.getPod();
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        String template = JdbcMisureDao.replaceAziendaClause("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "  FROM misure_pod_orari mp, misure_pod_orari_ea mpe" + "  WHERE" + currPrefixClause + "    azienda-clause" + "    export-clause" + "    pod-clause" + "    date-clause" + "    raccolta-clause" + "    mpe.misure_pod_orari_id=mp.id AND" + "    mp.cod_flusso = :flusso AND" + "    mp.regime = :regime AND" + "    stato IN (:stati)" + "  GROUP BY substr(pod_id, 1, " + prefixLength + ")" + "\t ORDER BY substr(pod_id, 1, " + prefixLength + ")", azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, filtri.getStatoEsportazione());
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        template = JdbcMisureDao.replaceRaccoltaClause(template, filtri.getRaccolta());
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, filtri.getStato());
        query.replace(":flusso", tipoFlusso.name());
        query.replace(":regime", regime);
        query.replace(":data_inizio:", filtri.getDataInizio(), DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", filtri.getDataFine(), DATE_FORMAT_DIESIS);
        PartitionCreator creator = new PartitionCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Partition> getPnoXmlMonth(String azienda, TipoFlusso tipoFlusso, String currPrefix, int prefixLength, FiltriXml filtri) {
        String codicePod = filtri.getPod();
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        String template = JdbcMisureDao.replaceAziendaClause("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count" + "  FROM misure_pod_non_orari" + "  WHERE" + currPrefixClause + "    azienda-clause" + "    export-clause" + "    pod-clause" + "    date-clause" + "    raccolta-clause" + "    cod_flusso = :flusso AND" + "    stato IN (:stati)" + "  GROUP BY substr(pod_id, 1, " + prefixLength + ")" + "\t ORDER BY substr(pod_id, 1, " + prefixLength + ")", azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replaceExportClause(template, filtri.getStatoEsportazione());
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        template = JdbcMisureDao.replaceRaccoltaClause(template, filtri.getRaccolta());
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, filtri.getStato());
        query.replace(":flusso", tipoFlusso.name());
        query.replace(":data_inizio:", filtri.getDataInizio(), DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", filtri.getDataFine(), DATE_FORMAT_DIESIS);
        PartitionCreator creator = new PartitionCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPdo2GRXml(String azienda, TipoFlusso flusso, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod, Partition partition, TalkManager talkManager) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPdo2GRXml, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        template = JdbcMisureDao.replaceRaccoltaClause(template, raccolta);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, stato);
        List<String> flussi = Arrays.asList(flusso.name());
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        Pdo2GCreator creator = new Pdo2GCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Pdo> getPdoPod(String codicePod, Date dataInizio, Date dataFine, String reseller, TipoFlusso flusso, String regime, TalkManager talkManager) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPdoXmlPod, reseller);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        template = JdbcMisureDao.replaceRegimeClause(template, regime);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, 0);
        List<String> flussi = Arrays.asList(flusso.name());
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, true, false, creator, this);
    }

    @Override
    public Pdo getPdo(String id, TalkManager talkManager) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate(this.queryPdoSingle);
        query.replace(":id", id);
        PdoCreator creator = new PdoCreator();
        List<Pdo> pdos = RecordCreatorHelper.getPdos(query, true, false, creator, this);
        return JdbcMisureDao.getSingle(id, pdos, "misure_pod_orari");
    }

    @Override
    public Pdo getPdo(String codicePod, int anno, Month mese, String reseller, Iterable<StatoMisure> stati) throws DataNotFoundException {
        List<Pdo> pdos = this.getPdoMese(anno, mese, codicePod, reseller, stati);
        if (pdos.isEmpty()) {
            throw new DataNotFoundException("pod.misurenotfound", codicePod, ErroriElaborazione.POD_MISURENOTFOUND.ordinal());
        }
        return pdos.get(0);
    }

    @Override
    public Pdo getPdoConsolidato(String codicePod, int anno, Month mese, Date last) throws DataNotFoundException {
        ElaborCalendar calendar = new ElaborCalendar(last);
        calendar.addGiorni(1);
        Date date = calendar.getDate();
        QueryTemplate query = new QueryTemplate(this.queryPdoConsolidato);
        query.replace(":codice:", codicePod);
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        query.replace(":last:", date, DATE_FORMAT_DIESIS);
        PdoCreator creator = new PdoCreator();
        List<Pdo> pdos = RecordCreatorHelper.getPdos(query, true, false, creator, this);
        String id = String.valueOf(codicePod) + "|" + anno + "|" + (Object)((Object)mese) + "|" + last;
        Pdo pdo = JdbcMisureDao.getSingle(id, pdos, "misure_pod_orari");
        return pdo;
    }

    @Override
    public Mno getPdo2GRXml(String id, TalkManager talkManager) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate(this.queryPdoSingle);
        query.replace(":id", id);
        Pdo2GCreator creator = new Pdo2GCreator(false);
        return this.getRecord(query, creator, "misure_pod_orari", id);
    }

    private static <T> T getSingle(String id, List<T> records, String tabella) throws DataNotFoundException {
        T record;
        switch (records.size()) {
            case 1: {
                record = records.get(0);
                break;
            }
            case 0: {
                throw new DataNotFoundException("non esiste un record con id " + id + " nella tabella " + tabella);
            }
            default: {
                throw new RuntimeException("molti record con id " + id + " nella tabella " + tabella);
            }
        }
        return record;
    }

    private static <T> T getSingleFacoltativo(String id, List<T> records, String tabella) {
        T record;
        switch (records.size()) {
            case 1: {
                record = records.get(0);
                break;
            }
            case 0: {
                record = null;
                break;
            }
            default: {
                throw new RuntimeException("molti record con id " + id + " nella tabella " + tabella);
            }
        }
        return record;
    }

    @Override
    public Mno getMno(String id) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT * FROM misure_pod_non_orari WHERE id = :id ORDER by pod_id, data_misura");
        query.replace(":id", id);
        MnoCreator creator = new MnoCreator(false);
        List<Mno> mnos = this.getRecords(query, creator);
        return JdbcMisureDao.getSingle(id, mnos, "misure_pod_non_orari");
    }

    @Override
    public Snf getSnf(String id) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT * FROM sw_dati_funz_pod_non_orari WHERE id = :id ORDER by pod_id, data_inizio");
        query.replace(":id", id);
        SnfCreator creator = new SnfCreator();
        List<Snf> records = this.getRecords(query, creator);
        return JdbcMisureDao.getSingle(id, records, "misure_pod_non_orari");
    }

    @Override
    public Sof getSof(String id) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT * FROM sw_dati_funz_pod_orari WHERE id = :id ORDER by pod_id");
        query.replace(":id", id);
        SofCreator creator = new SofCreator();
        List<Sof> records = this.getRecords(query, creator);
        return JdbcMisureDao.getSingle(id, records, "sw_dati_funz_pod_orari");
    }

    @Override
    public List<Pdo> getPdoFinoMese(int anno, Month mese, String reseller, String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPdoFinoMese, pod);
        template = JdbcMisureDao.replaceAziendaClause(template, reseller);
        return this.getPdo(template, anno, mese, stati);
    }

    @Override
    public List<Mno> getPdo2GRFinoMese(int anno, Month mese, String filtroPod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPdo2GR, filtroPod);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPdo2GRDaA(String codicePod, Date startDate, Date endDate, Destinatari destinatari, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceDestinatariClause(destinatari, this.queryPdo2GRDaA, stati);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codice_pod:", codicePod);
        query.replace(":start_date:", startDate, DATE_FORMAT_MISURE);
        query.replace(":end_date:", endDate, DATE_FORMAT_MISURE);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(STATI_PDO);
        query.replace(":stati:", codici);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Pdo> getPdoMese(int anno, Month mese, String pod, String reseller, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPdoMese, pod);
        template = JdbcMisureDao.replaceAziendaClause(template, reseller);
        return this.getPdo(template, anno, mese, stati);
    }

    @Override
    public ListMap<String, Pdo> getPdoTariffe(Destinatari destinatari, Set<String> podBatch, int anno, Month mese) {
        String template = JdbcMisureDao.replaceDestinatariClause(destinatari, this.queryPdoTariffeMese, STATI_PDO);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codicipod:", podBatch);
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        PdoCreator creator = new PdoCreator();
        List<Pdo> pdoList = RecordCreatorHelper.getPdos(query, true, true, creator, this);
        DefaultListMapKey<String, Pdo> pdoMap = new DefaultListMapKey<String, Pdo>();
        pdoMap.addAll(pdoList);
        return pdoMap;
    }

    @Override
    public ListMap<String, Mno> getPnoTariffe(Destinatari destinatari, Iterable<String> podBatch, int annoStart, Month meseStart, int annoStop, Month meseStop) {
        String template = JdbcMisureDao.replaceDestinatariClause(destinatari, this.queryPnoTariffeMese, STATI_PDO);
        return this.getPnoMap(podBatch, annoStart, meseStart, annoStop, meseStop, template);
    }

    @Override
    public ListMap<String, Mno> getPnoConsumi(Iterable<String> podBatch, int annoStart, Month meseStart, int annoStop, Month meseStop) {
        return this.getPnoMap(podBatch, annoStart, meseStart, annoStop, meseStop, this.queryPnoConsumiMese);
    }

    public ListMap<String, Mno> getPnoMap(Iterable<String> podBatch, int annoStart, Month meseStart, int annoStop, Month meseStop, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codicipod:", podBatch);
        String annomeseStart = JdbcMisureDao.formatAnnoMese(annoStart, meseStart);
        query.replace(":annomesestart:", annomeseStart);
        String annomeseStop = JdbcMisureDao.formatAnnoMese(annoStop, meseStop);
        query.replace(":annomese:", annomeseStop);
        MnoCreator creator = new MnoCreator(true);
        DefaultListMapKey<String, Mno> pnoMap = new DefaultListMapKey<String, Mno>();
        this.buildClassifier(pnoMap, query, creator);
        return pnoMap;
    }

    @Override
    public List<Pdo> getTestateTariffe(Destinatari destinatari, int anno, Month mese, int maxRows) {
        return this.getRettificheTariffe(destinatari, this.queryTestateTariffe, anno, mese, maxRows, false, StrategyHelper.STATI);
    }

    private List<Pdo> getRettificheTariffe(Destinatari destinatari, String template, int anno, Month mese, int maxRows, boolean complete, Iterable<StatoMisure> stati) {
        QueryTemplate query = new QueryTemplate(JdbcMisureDao.replaceDestinatariClause(destinatari, template, stati));
        query.replace(":anno", anno);
        query.replace(":mese", mese.getIndex());
        query.replace(":max_rows", maxRows);
        return this.getPdo(query, StrategyHelper.STATI, complete);
    }

    private static String replaceDestinatariClause(Destinatari destinatari, String template, Iterable<StatoMisure> stati) {
        String statoFieldName = destinatari.getStatoFieldName();
        String statiStr = JdbcMisureDao.buildStati(stati);
        String destinatariStr = String.valueOf(statoFieldName) + " in (" + statiStr + ")";
        return template.replaceAll("destinatari-clause", destinatariStr);
    }

    private static String buildStati(Iterable<StatoMisure> stati) {
        String statiStr = "";
        for (StatoMisure stato : stati) {
            statiStr = String.valueOf(statiStr) + (statiStr.isEmpty() ? "" : ",") + stato.getCodice();
        }
        return statiStr;
    }

    private List<Pdo> getPdo(String template, int anno, Month mese, Iterable<StatoMisure> stati) {
        QueryTemplate query = new QueryTemplate(template);
        return this.getPdo(query, anno, mese, stati);
    }

    private List<Pdo> getPdo(QueryTemplate query, int anno, Month mese, Iterable<StatoMisure> stati) {
        query.replace(":anno", anno);
        query.replace(":mese", mese.getIndex());
        return this.getPdo(query, stati, true);
    }

    private List<Pdo> getPdo(QueryTemplate query, Iterable<StatoMisure> stati, boolean complete) {
        query.replaceRaw(":stato", "stato");
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati", codici);
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, complete, false, creator, this);
    }

    @Override
    public List<Pdo> getRfo(Funzionalita funzionalita, String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryRfo, pod);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        QueryTemplate query = new QueryTemplate(template);
        query.replaceRaw(":stato", "stato");
        query.replace(":stati", codici);
        query.replace(":regime:", funzionalita.getRegimeRFO2GBanned());
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, true, false, creator, this);
    }

    @Override
    public List<Pdo> getRfoXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRfoXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getRfoXml(stati, dataInizio, dataFine, template);
    }

    private List<Pdo> getRfoXml(Iterable<Integer> stati, Date dataInizio, Date dataFine, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":flussi:", "RFO");
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, true, false, creator, this);
    }

    @Override
    public List<Mno> getPnoPeriodoXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod, Partition partition) {
        List<String> flussi = Arrays.asList(flusso.name());
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPnoPeriodoXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        MnoCreator creator = new MnoCreator(false);
        return this.getPnoXml(template, stati, dataInizio, dataFine, flussi, creator);
    }

    @Override
    public List<Mno> getPno2GPeriodoXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod, Partition partition, TipoFlusso tipoFlusso) {
        List<String> flussi = Arrays.asList(tipoFlusso.name());
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPnoPeriodoXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        MnoCreator creator = new MnoCreator(false);
        return this.getPnoXml(template, stati, dataInizio, dataFine, flussi, creator);
    }

    @Override
    public List<Mno> getPnoPeriodo(int anno, Month mese, String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPnoPeriodoMese, pod);
        return this.getPnosMese(anno, mese, template, stati);
    }

    @Override
    public List<Mno> getPnoElaborati(Pod pod) {
        QueryTemplate query = new QueryTemplate(this.queryPnoElaborati);
        query.replace(":codicepod", pod.getCodice());
        query.replace(":data:", pod.getDataMax(), DATE_FORMAT_MISURE);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPdo2GRElaborati(Pod pod) {
        QueryTemplate query = new QueryTemplate(this.queryPdo2GRElaborati);
        query.replace(":codicepod", pod.getCodice());
        query.replace(":data:", pod.getDataMax(), DATE_FORMAT_MISURE);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPnoPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPnoXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice:", codicePod);
        query.replace(":flussi", StrategyHelper.PNO);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPno2GPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryPnoXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice:", codicePod);
        query.replace(":flussi", StrategyHelper.PNO2G);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getRnosPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRnoXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice:", codicePod);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getRnvPod(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRnvXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, 0);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice:", codicePod);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Pdo> getRfosPod(String codicePod, Date dataInizio, Date dataFine, String azienda, TalkManager talkManager) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRfoXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice:", codicePod);
        PdoCreator creator = new PdoCreator();
        return RecordCreatorHelper.getPdos(query, true, false, creator, this);
    }

    @Override
    public List<ElaborCalendar> getMnoMonths() {
        QueryTemplate query = new QueryTemplate("SELECT to_char(data_misura, 'yyyy-mm') as month FROM misure_pod_non_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND\tstato in (4, 5, 6, 7) GROUP BY to_char(data_misura, 'yyyy-mm')");
        CalendarCreator creator = new CalendarCreator("month", DATE_MONTH_FORMAT);
        return this.getRecords(query, creator);
    }

    @Override
    public List<ElaborCalendar> getPdoMonths() {
        QueryTemplate query = new QueryTemplate("SELECT anno, mese FROM misure_pod_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND\tstato in (4, 5, 6, 7) GROUP BY anno, mese");
        CalendarCreator creator = new CalendarCreator("anno", "mese");
        return this.getRecords(query, creator);
    }

    @Override
    public List<ElaborCalendar> getSnfMonths() {
        QueryTemplate query = new QueryTemplate("SELECT to_char(data_inizio, 'yyyy-mm') as month FROM sw_dati_funz_pod_non_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND\tstato in (4, 5, 6, 7) GROUP BY to_char(data_inizio, 'yyyy-mm')");
        CalendarCreator creator = new CalendarCreator("month", DATE_MONTH_FORMAT);
        return this.getRecords(query, creator);
    }

    @Override
    public List<ElaborCalendar> getSofMonths() {
        QueryTemplate query = new QueryTemplate("SELECT to_char(data_inizio, 'yyyy-mm') as month FROM sw_dati_funz_pod_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND\tstato in (4, 5, 6, 7) GROUP BY to_char(data_inizio, 'yyyy-mm')");
        CalendarCreator creator = new CalendarCreator("month", DATE_MONTH_FORMAT);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Partition> getPdoPrefixes(ElaborCalendar month, String currPrefix, int prefixLength) {
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM misure_pod_orari " + "WHERE" + currPrefixClause + " (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND" + " anno = :anno: AND mese = :mese:  AND" + "\tstato in (4,5,6,7) " + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        int anno = month.getAnno();
        Month mese = month.getMese();
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public List<Partition> getMnoPrefixes(ElaborCalendar month, String currPrefix, int prefixLength) {
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM misure_pod_non_orari " + "WHERE" + currPrefixClause + " (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND" + "\tstato in (4, 5, 6, 7) AND" + " to_char(data_misura, 'yyyy-mm') = :date: " + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public List<Partition> getSnfPrefixes(ElaborCalendar month, String currPrefix, int prefixLength) {
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM sw_dati_funz_pod_non_orari " + "WHERE" + currPrefixClause + " (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND" + "\tstato in (4, 5, 6, 7) AND" + " to_char(data_inizio, 'yyyy-mm') = :date:" + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public List<Partition> getSofPrefixes(ElaborCalendar month, String currPrefix, int prefixLength) {
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM sw_dati_funz_pod_orari " + "WHERE" + currPrefixClause + " (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND" + "\tstato in (4, 5, 6, 7) AND" + " to_char(data_inizio, 'yyyy-mm') = :date:" + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public List<FlussoReseller> getMnoNoReseller(ElaborCalendar month, String prefix) {
        QueryTemplate query = new QueryTemplate("SELECT id, pod_id, data_misura as data FROM misure_pod_non_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND  pod_id LIKE :pattern: AND\t stato in (4, 5, 6, 7) AND  to_char(data_misura, 'yyyy-mm') = :date: ORDER BY pod_id");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        FlussoResellerCreator creator = new FlussoResellerCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<FlussoReseller> getSnfNoReseller(ElaborCalendar month, String prefix) {
        QueryTemplate query = new QueryTemplate("SELECT id, pod_id, data_inizio as data FROM sw_dati_funz_pod_non_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND  pod_id LIKE :pattern: AND\t stato in (4, 5, 6, 7) AND  to_char(data_inizio, 'yyyy-mm') = :date: ORDER BY pod_id");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        FlussoResellerCreator creator = new FlussoResellerCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<FlussoReseller> getSofNoReseller(ElaborCalendar month, String prefix) {
        QueryTemplate query = new QueryTemplate("SELECT id, pod_id, data_inizio as data FROM sw_dati_funz_pod_orari WHERE (cdaziend is null or cdaziend = ' ' or cdaziend = '') AND  pod_id LIKE :pattern: AND\t stato in (4, 5, 6, 7) AND  to_char(data_inizio, 'yyyy-mm') = :date: ORDER BY pod_id");
        Date date = month.getDate();
        query.replace(":date:", date, DATE_MONTH_FORMAT);
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        FlussoResellerCreator creator = new FlussoResellerCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<FlussoReseller> getPdoNoReseller(ElaborCalendar month, String prefix) {
        QueryTemplate query = new QueryTemplate("SELECT mpo.id, mpo.pod_id, mpoa.data FROM misure_pod_orari mpo, misure_pod_orari_ea mpoa WHERE  mpo.anno = :anno: AND mpo.mese = :mese:  AND (mpo.cdaziend is null or mpo.cdaziend = ' ' or mpo.cdaziend = '') AND\t mpo.stato in (4, 5, 6, 7) AND  mpo.pod_id LIKE :pattern: AND  mpo.id = mpoa.misure_pod_orari_id ORDER BY mpo.pod_id");
        int anno = month.getAnno();
        Month mese = month.getMese();
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        FlussoResellerCreator creator = new FlussoResellerCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public boolean recordMnoReseller(List<FlussoReseller> flussi, TalkManager talkManager, Logger logger) {
        return this.recordReseller(flussi, "misure_pod_non_orari", talkManager, logger);
    }

    @Override
    public boolean recordSnfReseller(List<FlussoReseller> flussi, TalkManager talkManager, Logger logger) {
        return this.recordReseller(flussi, "sw_dati_funz_pod_non_orari", talkManager, logger);
    }

    @Override
    public boolean recordSofReseller(List<FlussoReseller> flussi, TalkManager talkManager, Logger logger) {
        return this.recordReseller(flussi, "sw_dati_funz_pod_orari", talkManager, logger);
    }

    @Override
    public boolean recordPdoReseller(List<FlussoReseller> flussi, TalkManager talkManager, Logger logger) {
        return this.recordReseller(flussi, "misure_pod_orari", talkManager, logger);
    }

    private boolean recordReseller(List<FlussoReseller> flussi, String tabella, TalkManager talkManager, Logger logger) {
        Connection connection = this.getConnection();
        RecordResellerUpdateHandler updateHandler = new RecordResellerUpdateHandler(flussi, tabella, connection);
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(updateHandler, exceptionHandler);
    }

    @Override
    public List<ElaborCalendar> getPnoMonths(String onlyPod, int anno, Month mese) {
        String condition = onlyPod.isEmpty() ? "" : " pod_id='" + onlyPod + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT to_char(data_misura, 'yyyy-mm') as month FROM misure_pod_non_orari WHERE" + condition + " to_char(data_misura, 'yyyy-mm') <= :data: AND" + "\tcod_flusso IN (" + "\t\t'PNO2G', 'RNO2G', 'VNO2G', 'DS2G', 'DSR2G', 'AV2G', 'AVR2G', 'VP2G', 'VPR2G'" + "\t) AND" + "\tstato = 4 AND" + " cod_errore = 111 " + "GROUP BY to_char(data_misura, 'yyyy-mm')");
        Date data = CalendarTools.getDate(anno, mese, 1);
        query.replace(":data:", data, DATE_MONTH_FORMAT);
        CalendarCreator creator = new CalendarCreator("month", DATE_MONTH_FORMAT);
        return this.getRecords(query, creator);
    }

    @Override
    public List<ElaborCalendar> getPdoMonths(String onlyPod, int anno, Month mese) {
        String condition = onlyPod.isEmpty() ? "" : " pod_id='" + onlyPod + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT anno, mese FROM misure_pod_orari WHERE" + condition + " (anno < :anno: OR (anno = :anno: AND mese <= :mese:))  AND" + "\tcod_flusso IN ('PDO2G', 'RFO2G') AND" + "\tstato = 4 AND" + " cod_errore = 111 " + "GROUP BY anno, mese");
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        CalendarCreator creator = new CalendarCreator("anno", "mese");
        return this.getRecords(query, creator);
    }

    @Override
    public List<Partition> getMno2GPartitions(String onlyPod, ElaborCalendar month, String currPrefix, int prefixLength) {
        String condition = onlyPod.isEmpty() ? "" : " pod_id='" + onlyPod + "' AND";
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM misure_pod_non_orari " + "WHERE" + currPrefixClause + condition + " to_char(data_misura, 'yyyy-mm') = :data: AND" + "\tcod_flusso IN (" + "\t\t'PNO2G', 'RNO2G', 'VNO2G', 'DS2G', 'DSR2G', 'AV2G', 'AVR2G', 'VP2G', 'VPR2G'" + "\t) AND" + "\tstato = 4 AND" + " cod_errore = 111 " + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        Date data = month.getDate();
        query.replace(":data:", data, DATE_MONTH_FORMAT);
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public List<Partition> getPdo2GPartitions(String onlyPod, ElaborCalendar month, String currPrefix, int prefixLength) {
        String condition = onlyPod.isEmpty() ? "" : " pod_id='" + onlyPod + "' AND";
        int currPrefixLength = currPrefix.length();
        String currPrefixClause = currPrefix.isEmpty() ? "" : " substr(pod_id, 1, " + currPrefixLength + ") = '" + currPrefix + "' AND";
        QueryTemplate query = new QueryTemplate("SELECT substr(pod_id, 1, " + prefixLength + ") as prefix, count(*) as count " + "FROM misure_pod_orari " + "WHERE" + currPrefixClause + condition + " anno = :anno: AND mese = :mese:  AND" + "\tcod_flusso in ('PDO2G', 'RFO2G') AND" + "\tstato = 4 AND" + " cod_errore = 111 " + "GROUP BY substr(pod_id, 1, " + prefixLength + ")");
        int anno = month.getAnno();
        Month mese = month.getMese();
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        return this.getRecords(query, new PartitionCreator());
    }

    @Override
    public ListMap<String, Mno> getPnoConsolidamento(String onlyPod, ElaborCalendar month, String prefix) {
        DefaultListMapKey<String, Mno> listMap = new DefaultListMapKey<String, Mno>();
        String template = JdbcMisureDao.replacePodClause(this.queryPnoConsolidamento, onlyPod);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        Date date = month.getDate();
        query.replace(":data:", date, DATE_MONTH_FORMAT);
        MnoCreator creator = new MnoCreator(true);
        this.buildClassifier(listMap, query, creator);
        return listMap;
    }

    @Override
    public ListMap<String, Mno> getPdoConsolidamento(String onlyPod, ElaborCalendar month, String prefix) {
        DefaultListMapKey<String, Mno> listMap = new DefaultListMapKey<String, Mno>();
        String template = JdbcMisureDao.replacePodClause(this.queryPdoConsolidamento, onlyPod);
        QueryTemplate query = new QueryTemplate(template);
        int anno = month.getAnno();
        Month mese = month.getMese();
        query.replace(":pattern:", String.valueOf(prefix) + "%");
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        Pdo2GCreator creator = new Pdo2GCreator(true);
        this.buildClassifier(listMap, query, creator);
        return listMap;
    }

    public List<Mno> getPdo2GRSoTardivo(Date data, int scostamento, String codicePod) {
        QueryTemplate query = new QueryTemplate(this.queryPdo2GRSoTardivo);
        query.replace(":codice_pod:", codicePod);
        JdbcMisureDao.fillQueryDataScostamento(query, data, scostamento);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecords(query, creator);
    }

    private static void fillQueryDataScostamento(QueryTemplate query, Date data, int scostamento) {
        ElaborCalendar calendar = new ElaborCalendar(data);
        calendar.addGiorni(-scostamento);
        Date dataMin = calendar.getDate();
        calendar = new ElaborCalendar(data);
        calendar.addGiorni(scostamento);
        Date dataMax = calendar.getDate();
        query.replace(":data_min:", dataMin, DATE_FORMAT_MISURE);
        query.replace(":data_max:", dataMax, DATE_FORMAT_MISURE);
    }

    @Override
    public List<Mno> getPnoSoTardivo(Date data, int scostamento, String codicePod) {
        QueryTemplate query = new QueryTemplate(this.queryPnoSoTardivo);
        query.replace(":codice_pod:", codicePod);
        JdbcMisureDao.fillQueryDataScostamento(query, data, scostamento);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    private static QueryTemplate fillQueryMisuraPraticaTardiva(String codicePod, Date data, Iterable<String> tipiDato, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codice_pod:", codicePod);
        query.replace(":data:", data, DATE_FORMAT_MISURE);
        query.replace(":tipi:", tipiDato);
        return query;
    }

    private static QueryTemplate fillQueryMisuraPraticaTardivaScostamento(String codicePod, Date data, int scostamento, Iterable<String> tipiDato, Iterable<String> raccolte, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codice_pod:", codicePod);
        query.replace(":tipi:", tipiDato);
        query.replace(":raccolte:", raccolte);
        JdbcMisureDao.fillQueryDataScostamento(query, data, scostamento);
        return query;
    }

    @Override
    public Mno getPnoPraticaTardiva(String codicePod, Date data, Iterable<String> tipiDato) throws DataNotFoundException {
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardiva(codicePod, data, tipiDato, this.queryPnoPraticaTardivaLetture);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecord(query, creator, "misure_pod_non_orari", codicePod);
    }

    @Override
    public Mno getPdo2GRPraticaTardiva(String codicePod, Date data, Iterable<String> tipiDato) throws DataNotFoundException {
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardiva(codicePod, data, tipiDato, this.queryPdo2GRPraticaTardivaLetture);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecord(query, creator, "misure_pod_orari", codicePod);
    }

    @Override
    public Mno getPnoLateProcessing(String codicePod, Date data, int scostamento, Iterable<String> tipiDato) throws DataNotFoundException {
        MnoCreator creator;
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardivaScostamento(codicePod, data, scostamento, tipiDato, new ArrayList<String>(), this.queryPnoLateProcessing);
        List<Mno> records = this.getRecords(query, creator = new MnoCreator(true));
        if (records.isEmpty()) {
            throw new DataNotFoundException("misure_pod_non_orari", codicePod, -1);
        }
        return records.get(0);
    }

    @Override
    public Mno getPnoCP1LateProcessing(String codicePod, Date data, Iterable<String> tipiDato) throws DataNotFoundException {
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardiva(codicePod, data, tipiDato, this.queryPnoCP1LateProcessing);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecord(query, creator, "misure_pod_non_orari", codicePod);
    }

    @Override
    @Deprecated
    public Mno getVnoTardiva(String codicePod, Date dataPratica, int scostamento) throws DataNotFoundException {
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardivaScostamento(codicePod, dataPratica, scostamento, new ArrayList<String>(), new ArrayList<String>(), this.queryVnoLateProcessing);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecord(query, creator, "misure_pod_non_orari", codicePod);
    }

    @Override
    public Mno getPdo2GRLateProcessing(String codicePod, Date data, int scostamento, Iterable<String> tipiDato) throws DataNotFoundException {
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardivaScostamento(codicePod, data, scostamento, tipiDato, new ArrayList<String>(), this.queryPdo2GRLateProcessing);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        return this.getRecord(query, creator, "misure_pod_orari", codicePod);
    }

    @Override
    public Mno getPdo2GRCP1LateProcessing(String codicePod, Date data, Iterable<String> tipiDato) throws DataNotFoundException {
        Pdo2GCreator creator;
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardiva(codicePod, data, tipiDato, this.queryPdo2GRCP1LateProcessing);
        List<Mno> items = this.getRecords(query, creator = new Pdo2GCreator(true));
        int size = items.size();
        if (size == 0) {
            throw new DataNotFoundException("misure pod orari", codicePod, -1);
        }
        return items.get(0);
    }

    @Override
    public Mno getMnoPraticaTardiva(String codicePod, Date dataPratica, int scostamento, Iterable<String> flussi, Iterable<StatoMisure> stati, Iterable<String> tipiDato, Iterable<String> raccolte, String order) throws DataNotFoundException {
        String template = this.queryMnoPraticaTardiva.replaceAll(":order:", order).replaceAll("<tipi-clause>", "");
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardivaScostamento(codicePod, dataPratica, scostamento, tipiDato, raccolte, template);
        query.replace(":flussi:", flussi);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        MnoCreator creator = new MnoCreator(true);
        List<Mno> mno = this.getRecords(query, creator);
        if (mno.isEmpty()) {
            String key = String.valueOf(codicePod) + "|" + DATE_FORMAT_MISURE.format(dataPratica) + "|+-" + scostamento;
            throw new DataNotFoundException("misure_pod_non_orari", key, 0);
        }
        return mno.get(0);
    }

    @Override
    public Mno getMo2GRPraticaTardiva(String codicePod, Date dataPratica, int scostamento, Iterable<String> flussi, Iterable<StatoMisure> stati, Iterable<String> tipiDato, Iterable<String> raccolte, String order) throws DataNotFoundException {
        String template = this.queryMo2GRPraticaTardiva.replaceAll(":order:", order).replaceAll("<tipi-clause>", "");
        QueryTemplate query = JdbcMisureDao.fillQueryMisuraPraticaTardivaScostamento(codicePod, dataPratica, scostamento, tipiDato, raccolte, template);
        query.replace(":flussi:", flussi);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        List<Mno> mno = this.getRecords(query, creator);
        if (mno.isEmpty()) {
            String key = String.valueOf(codicePod) + "|" + DATE_FORMAT_MISURE.format(dataPratica) + "|+-" + scostamento;
            throw new DataNotFoundException("misure_pod_non_orari", key, 0);
        }
        return mno.get(0);
    }

    @Override
    public Misure<Mno> getVnos(String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryVno, "");
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, pod);
        QueryTemplate query = new QueryTemplate(template);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati", codici);
        JdbcMisureDao.replaceRaccolte(query, "");
        MnoCreator creator = new MnoCreator(true);
        Misure<Mno> misure = new Misure<Mno>("vno");
        this.buildClassifier(misure, query, creator);
        return misure;
    }

    @Override
    public Misure<Mno> getPdo2GRV(String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPdo2GRV, pod);
        QueryTemplate query = new QueryTemplate(template);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati", codici);
        Pdo2GCreator creator = new Pdo2GCreator(true);
        Misure<Mno> misure = new Misure<Mno>("pdo2grv");
        this.buildClassifier(misure, query, creator);
        return misure;
    }

    @Override
    public List<Mno> getMnoXml(String azienda, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso tipo, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryMnoXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, stato);
        JdbcMisureDao.replaceRaccolte(query, raccolta);
        query.replace(":flusso:", tipo.name());
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getVnosPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryVnoXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, 0);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getVnos(String codPratAtt) {
        QueryTemplate query = new QueryTemplate(this.queryVnoPratica);
        query.replace(":codpratatt", codPratAtt);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getPnoTecniche(int anno, Month mese, String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replacePodClause(this.queryPnoTecnicheMese, pod);
        return this.getPnosMese(anno, mese, template, stati);
    }

    @Override
    public List<Mno> getPnoSospette(int anno, Month mese, String pod) {
        String template = JdbcMisureDao.replacePodClause(this.queryPnoSospette, pod);
        QueryTemplate query = new QueryTemplate(template);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        calendar.addMesi(1);
        Date after = calendar.getDate();
        query.replace(":after_date", after, DATE_FORMAT_MISURE);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    private <T> List<T> getPnoXml(String queryTemplate, Iterable<Integer> stati, Date dataInizio, Date dataFine, Iterable<String> flussi, RecordCreator<T> creator) {
        QueryTemplate query = new QueryTemplate(queryTemplate);
        query.replace(":stati", stati);
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        return this.getRecords(query, creator);
    }

    private List<Mno> getPnosMese(int anno, Month mese, String queryTemplate, Iterable<StatoMisure> stati) {
        QueryTemplate query = new QueryTemplate(queryTemplate);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date data = calendar.getDate();
        query.replace(":data:", data, DATE_MONTH_FORMAT);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati", codici);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getSnm(String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnm, "");
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, pod);
        QueryTemplate query = new QueryTemplate(template);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati", codici);
        JdbcMisureDao.replaceRaccolte(query, "");
        query.replace(":flussi", StrategyHelper.SNM_ALL);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getSnmXml(String azienda, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnm, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        List<String> flussi = Arrays.asList(flusso.name());
        JdbcMisureDao.replaceStati(query, stato);
        JdbcMisureDao.replaceRaccolte(query, raccolta);
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getSnmPod(String codicePod, String azienda, Date dataInizio, Date dataFine) {
        TipoFlusso flusso = TipoFlusso.SNM;
        return this.getSnmXmlPod(codicePod, azienda, dataInizio, dataFine, flusso);
    }

    @Override
    public List<Mno> getSnm2GPod(String codicePod, String azienda, Date dataInizio, Date dataFine) {
        TipoFlusso flusso = TipoFlusso.SNM2G;
        return this.getSnmXmlPod(codicePod, azienda, dataInizio, dataFine, flusso);
    }

    private List<Mno> getSnmXmlPod(String codicePod, String azienda, Date dataInizio, Date dataFine, TipoFlusso flusso) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnmXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        List<String> flussi = Arrays.asList(flusso.name());
        JdbcMisureDao.replaceStati(query, 0);
        query.replace(":flussi", flussi);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public ListMapKey<String, Mno> getSmis(String reseller, String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySmis, reseller);
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, pod);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        return this.getSmis(codici, template);
    }

    @Override
    public ListMapKey<String, Mno> getSmisXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaXmlClause(this.querySmis, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_SMIS_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        QueryTemplate query = new QueryTemplate(template);
        ElaborCalendar calendar = new ElaborCalendar(dataFine);
        calendar.addGiorni(1);
        Date dataExtra = calendar.getDate();
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":data_extra:", dataExtra, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        DefaultListMapKey<String, Mno> smis = new DefaultListMapKey<String, Mno>();
        this.buildClassifier(smis, query, creator);
        return smis;
    }

    @Override
    public ListMapKey<String, Mno> getSmisPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaXmlClause(this.querySmis, azienda);
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_SMIS_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        ElaborCalendar calendar = new ElaborCalendar(dataFine);
        calendar.addGiorni(1);
        Date dataExtra = calendar.getDate();
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":data_extra:", dataExtra, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        DefaultListMapKey<String, Mno> smis = new DefaultListMapKey<String, Mno>();
        this.buildClassifier(smis, query, creator);
        return smis;
    }

    private ListMapKey<String, Mno> getSmis(Iterable<Integer> stati, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        MnoCreator creator = new MnoCreator(true);
        DefaultListMapKey<String, Mno> smis = new DefaultListMapKey<String, Mno>();
        this.buildClassifier(smis, query, creator);
        return smis;
    }

    @Override
    public List<Snf> getSnfs(String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnf, "");
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, pod);
        return this.getSnf(null, BasicDaoHelper.buildCodiciStatoMisure(stati), template);
    }

    @Override
    public List<Snf> getSnfXml(TipoFlusso tipoFlusso, String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnfXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_FUN_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codice_flusso:", tipoFlusso.name());
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        SnfCreator creator = new SnfCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Snf> getF2gPod(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        TipoFlusso flusso = TipoFlusso.F2G;
        return this.getSnfXmlPod(codicePod, dataInizio, dataFine, azienda, flusso);
    }

    @Override
    public List<Snf> getSnfPod(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        TipoFlusso flusso = TipoFlusso.SNF;
        return this.getSnfXmlPod(codicePod, dataInizio, dataFine, azienda, flusso);
    }

    private List<Snf> getSnfXmlPod(String codicePod, Date dataInizio, Date dataFine, String azienda, TipoFlusso flusso) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnfXml, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_FUN_XML);
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":codice_flusso:", flusso.name());
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        SnfCreator creator = new SnfCreator();
        return this.getRecords(query, creator);
    }

    private List<Snf> getSnf(Date data, Iterable<Integer> stati, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":data:", data, DATE_FORMAT_MISURE);
        query.replace(":stati", stati);
        SnfCreator creator = new SnfCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Sof> getSofs(String pod, Iterable<StatoMisure> stati) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySof, "");
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "");
        template = JdbcMisureDao.replacePodClause(template, pod);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        return this.getSofs(codici, template);
    }

    @Override
    public List<Sof> getSofXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySof, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_FUN_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getSofsXml(stati, dataInizio, dataFine, template);
    }

    @Override
    public List<Sof> getSofPod(String codicePod, String azienda, Date dataInizio, Date dataFine) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySof, azienda);
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_FUN_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        return this.getSofsXml(stati, dataInizio, dataFine, template);
    }

    private List<Sof> getSofsXml(Iterable<Integer> stati, Date dataInizio, Date dataFine, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        SofCreator creator = new SofCreator();
        return this.getRecords(query, creator);
    }

    private List<Sof> getSofs(Iterable<Integer> stati, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        SofCreator creator = new SofCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getRnoXml(TipoFlusso flusso, String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRnoXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getRnosXml(flusso, stati, dataInizio, dataFine, template);
    }

    private List<Mno> getRnosXml(TipoFlusso flusso, Iterable<Integer> stati, Date dataInizio, Date dataFine, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice_flusso:", flusso.name());
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Rno> getRno(String azienda, String pod) {
        String template = JdbcMisureDao.replaceAziendaClauseCdAnagra(this.queryRno, azienda);
        template = JdbcMisureDao.replacePodClause(template, pod);
        template = JdbcMisureDao.replaceGiadaDbName(template, this.configuration.getGiadaDbUser());
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(StrategyHelper.STATI);
        RnoCreator creator = new RnoCreator(true);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", codici);
        return this.getRecords(query, creator);
    }

    @Override
    public SafeMap<String, Mno> getPnosRiallineamento(int anno, Month mese) {
        List<Mno> pnos = this.getPnosMese(anno, mese, this.queryPnoRiallineamento, StrategyHelper.STATI);
        SimpleSafeMap<String, Mno> map = new SimpleSafeMap<String, Mno>("pnos");
        map.addAll(pnos);
        return map;
    }

    @Override
    public boolean recordStatoSwitch(StatoContainer status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoSwitchHandler handler = new RecordStatoSwitchHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordStatoLetture(StatoContainer status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoLettureHandler handler = new RecordStatoLettureHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordLetture(ServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordLettureHandler handler = new RecordLettureHandler(connection, this.configuration, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordStatoConsolidamento(StatoContainer status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoConsolidamentoHandler handler = new RecordStatoConsolidamentoHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordStatoTariffe(ServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoTariffeHandler handler = new RecordStatoTariffeHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordStatoVolture(ServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoVoltureHandler handler = new RecordStatoVoltureHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public boolean recordStatoMisure(ServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordStatoMisureHandler handler = new RecordStatoMisureHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public SafeListMap<String, Prestazione> getPrestazioni() {
        QueryTemplate query = new QueryTemplate("SELECT * FROM prestazioni ORDER BY codice_servizio, codice_prestazione, codice_flusso, progressivo");
        PrestazioneCreator creator = new PrestazioneCreator();
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("prestazione");
        this.buildClassifier(prestazioni, query, creator);
        return prestazioni;
    }

    @Override
    public StatoPod getStatoPod(String servizio, String prestazione, String flusso, String codicePod, Date dataMisura, String stato) throws DataNotFoundException {
        String key = String.valueOf(servizio) + "|" + prestazione + "|" + flusso + "|" + codicePod + "|" + dataMisura + "|" + stato;
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE cdserviz=:servizio AND cdunipre=:cdunipre AND cdflusso=:cdflusso AND pod=:pod AND data_movimento=:data_movimento AND stato=:stato");
        query.replace(":servizio", servizio);
        query.replace(":cdunipre", prestazione);
        query.replace(":cdflusso", flusso);
        query.replace(":pod", codicePod);
        query.replace(":data_movimento", dataMisura, DATE_FORMAT_DIESIS);
        query.replace(":stato", stato);
        StatoPodCreator creator = new StatoPodCreator();
        return this.getRecord(query, creator, "statopod.notfound", key);
    }

    @Override
    public StatoPod getLastStatoPod(String servizio, String codicePod, String flusso, Date dataMisura, String statoRic) throws DataNotFoundException {
        QueryTemplate query;
        String key = String.valueOf(servizio) + "|" + codicePod + "|" + flusso + "|" + dataMisura + "|" + statoRic;
        StatoPod statoPod = this.getStatoPod(servizio, null, codicePod, key, query = new QueryTemplate("SELECT * FROM stato_pod WHERE cdserviz=:servizio AND pod=:pod order by data_movimento DESC, nuprogre DESC"));
        if (!(statoPod.getCdFlusso().equals(flusso) && statoPod.getDataMovimento().equals(dataMisura) && statoPod.getStatoRic().equals(statoRic))) {
            int errore = ErroriElaborazione.MOVIMENTORIFERIMENTO_NOTFOUND.ordinal();
            throw new DataNotFoundException("statopod.notfound", key, errore);
        }
        return statoPod;
    }

    @Override
    public StatoPod getStatoPod(String servizio, String codicePod, String cpGestore) throws DataNotFoundException {
        String key = String.valueOf(servizio) + "|" + codicePod + "|" + cpGestore;
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE cdunipre not in (:cdunipre:) AND cdserviz=:servizio AND pod=:pod AND CP_GESTORE=:codicepratica order by data_movimento DESC, nuprogre DESC");
        query.replace(":cdunipre:", this.prestazioniIgnorate);
        return this.getStatoPod(servizio, cpGestore, codicePod, key, query);
    }

    @Override
    public StatoPod getStatoPodFlusso(String servizio, String[] flussi, String codicePod, Date dataMovimento) throws DataNotFoundException {
        String key = String.valueOf(servizio) + "|" + flussi[0] + "|" + codicePod + "|" + dataMovimento;
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE cdunipre not in (:cdunipre:) AND cdserviz=:servizio AND pod=:pod AND cdflusso in (:flussi:) AND data_movimento=:data_movimento ORDER BY nuprogre DESC");
        query.replace(":flussi:", Arrays.asList(flussi));
        query.replace(":data_movimento", dataMovimento, DATE_FORMAT_DIESIS);
        query.replace(":cdunipre:", this.prestazioniIgnorate);
        return this.getStatoPod(servizio, null, codicePod, key, query);
    }

    @Override
    public StatoPod getStatoPodGestore(String servizio, String codicePrestazione, String codicePod, String cpGestore) throws DataNotFoundException {
        String key = String.valueOf(servizio) + "|" + codicePrestazione + "|" + codicePod + "|" + cpGestore;
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE cdserviz=:servizio AND cdunipre=:cdunipre AND pod=:pod AND CP_GESTORE=:codicepratica ORDER BY data_movimento DESC, nuprogre DESC");
        query.replace(":cdunipre", codicePrestazione);
        return this.getStatoPod(servizio, cpGestore, codicePod, key, query);
    }

    @Override
    public StatoPod getStatoPodUtente(String servizio, String codicePrestazione, String azienda, String codicePod, String cpUtente) throws DataNotFoundException {
        String key = String.valueOf(servizio) + "|" + codicePrestazione + "|" + codicePod + "|" + cpUtente;
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod, map_cputente WHERE map_cputente.cdaziend=:azienda: AND map_cputente.cputente_out=:codicepratica AND stato_pod.cdserviz=:servizio AND stato_pod.cdunipre=:cdunipre: AND stato_pod.pod=:pod AND stato_pod.cp_utente=map_cputente.cputente_in ORDER BY data_movimento DESC, nuprogre DESC");
        query.replace(":cdunipre:", codicePrestazione);
        query.replace(":azienda:", azienda);
        return this.getStatoPod(servizio, cpUtente, codicePod, key, query);
    }

    private StatoPod getStatoPod(String servizio, String codicePratica, String codicePod, String key, QueryTemplate query) throws DataNotFoundException {
        query.replace(":servizio", servizio);
        query.replace(":pod", codicePod);
        query.replace(":codicepratica", codicePratica);
        StatoPodCreator creator = new StatoPodCreator();
        List<JdbcStatoPod> records = this.getRecords(query, creator);
        if (records.isEmpty()) {
            int errore = ErroriElaborazione.MOVIMENTORIFERIMENTO_NOTFOUND.ordinal();
            throw new DataNotFoundException("statopod.notfound", key, errore);
        }
        return records.get(0);
    }

    @Override
    public JdbcStatoPod getStatoPod(String servizio, String codicePod, Date dataAttivazione) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE  cdunipre not in (:cdunipre:) AND  cdserviz=:servizio AND  pod=:pod AND  stato_ric in('E') AND  data_attivazione<=:data: AND  NOT FLANNRIC in (1) ORDER BY  data_attivazione DESC,  data_movimento DESC,  nuprogre DESC");
        query.replace(":cdunipre:", this.prestazioniIgnorate);
        return this.getStatoPod(servizio, "", codicePod, dataAttivazione, query);
    }

    @Override
    public StatoPod getStatoPodChiusura(String servizio, String codicePrestazione, String codicePod, Date data, StatoPod tecStatoPod) throws DataNotFoundException {
        StatoPod trueTecStatoPod = tecStatoPod == null ? this.getStatoPod(servizio, codicePod, data) : tecStatoPod;
        JdbcStatoPod praticheStatoPod = this.getPraticheStatoPod(servizio, codicePrestazione, codicePod, data);
        String cpGestore = praticheStatoPod.getCpGestore();
        String cpUtente = praticheStatoPod.getCpUtente();
        Date dataPrestazione = praticheStatoPod.getDataPrestazione();
        return new WrapStatoPod(trueTecStatoPod, cpGestore, cpUtente, dataPrestazione);
    }

    @Override
    public StatoPod getStatoPodApertura(String servizio, String codicePrestazione, String codicePod, Date data, StatoPod tecStatoPod) throws DataNotFoundException {
        StatoPod trueTecStatoPod = tecStatoPod == null ? this.getStatoPod(servizio, codicePod, data) : tecStatoPod;
        JdbcStatoPod statoPod = this.getPraticheStatoPod(servizio, codicePrestazione, codicePod, data);
        JdbcMisureDao.mergeDatiTecnici(statoPod, trueTecStatoPod);
        return statoPod;
    }

    private static void mergeDatiTecnici(JdbcStatoPod statoPod, StatoPod trueTecStatoPod) {
        statoPod.setNuCifreA(trueTecStatoPod.getNuCifreA());
        statoPod.setNuCifreR(trueTecStatoPod.getNuCifreR());
        statoPod.setNuCifreP(trueTecStatoPod.getNuCifreP());
        statoPod.setNuCifreBio(trueTecStatoPod.getNuCifreBio());
        statoPod.setModContatoreA(trueTecStatoPod.getModContatoreA());
        statoPod.setModContatoreR(trueTecStatoPod.getModContatoreR());
        statoPod.setModContatoreP(trueTecStatoPod.getModContatoreP());
        statoPod.setModContatoreBio(trueTecStatoPod.getModContatoreBio());
        statoPod.setFlMisCon(trueTecStatoPod.getFlmisCon());
        statoPod.setFlMisRea(trueTecStatoPod.getFlmisRea());
        statoPod.setFlMisPot(trueTecStatoPod.getFlmisPot());
        statoPod.setFlMisBio(trueTecStatoPod.isFlMisBio());
        statoPod.setInMisCon(trueTecStatoPod.getInmisCon());
        statoPod.setInMisRea(trueTecStatoPod.getInmisRea());
        statoPod.setInMisPot(trueTecStatoPod.getInmisPot());
        statoPod.setInMisBio(trueTecStatoPod.getInMisBio());
        statoPod.setNuMatrA(trueTecStatoPod.getNuMatrA());
        statoPod.setNuMatrR(trueTecStatoPod.getNuMatrR());
        statoPod.setNuMatrP(trueTecStatoPod.getNuMatrP());
        statoPod.setNuMatrBio(trueTecStatoPod.getNuMatricBio());
        statoPod.setFlAzzConA(trueTecStatoPod.isFlazzconA());
        statoPod.setFlAzzConR(trueTecStatoPod.isFlazzconR());
        statoPod.setFlAzzConP(trueTecStatoPod.isFlazzconP());
        statoPod.setFlAzzConBio(trueTecStatoPod.isFlAzzConBio());
    }

    private JdbcStatoPod getPraticheStatoPod(String servizio, String codicePrestazione, String codicePod, Date data) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT * FROM stato_pod WHERE  cdserviz = :servizio AND  pod = :pod AND  cdunipre = :prestazione AND  data_attivazione = :data: ORDER BY nuprogre DESC");
        return this.getStatoPod(servizio, codicePrestazione, codicePod, data, query);
    }

    private JdbcStatoPod getStatoPod(String servizio, String codicePrestazione, String codicePod, Date data, QueryTemplate query) throws DataNotFoundException {
        query.replace(":servizio", servizio);
        query.replace(":prestazione", codicePrestazione);
        query.replace(":pod", codicePod);
        query.replace(":data:", data, DATE_FORMAT_DIESIS);
        StatoPodCreator creator = new StatoPodCreator();
        List<JdbcStatoPod> records = this.getRecords(query, creator);
        if (records.isEmpty()) {
            int errore = ErroriElaborazione.MOVIMENTORIFERIMENTO_NOTFOUND.ordinal();
            throw new DataNotFoundException("statopod.notfound", String.valueOf(servizio) + "|" + codicePrestazione + "|" + codicePod + "|" + StrategyHelper.getDataFormat().format(data), errore);
        }
        JdbcStatoPod statoPod = records.get(0);
        return statoPod;
    }

    @Override
    public int getNuprogre(String servizio, String codicePod, Date dataMovimento) {
        QueryTemplate condition = new QueryTemplate("pod=:pod AND data_movimento=:data:");
        condition.replace(":pod", codicePod);
        condition.replace(":data:", DATE_FORMAT_DIESIS.format(dataMovimento));
        return this.getFieldMaxCondition("stato_pod", "nuprogre", condition);
    }

    @Override
    public List<Mno2GE> get2geaXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.query2gea, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, false, dataInizio, dataFine, template, TipoDettaglioOrario.EA);
    }

    @Override
    @Deprecated
    public List<Mno2GE> getPdo2gREaXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querypdo2grea, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replacePodClause(template, pod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, true, dataInizio, dataFine, template, TipoDettaglioOrario.EA);
    }

    @Override
    public List<Mno2GE> getPnoEAXml(String azienda, TipoFlusso tipo, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition) {
        return this.getMisureEXml(azienda, tipo, false, "", raccolta, stato, statoEsportazione, dataInizio, dataFine, pod, partition, "A", this.querypnoea);
    }

    @Override
    public List<Mno2GE> getPnoERXml(String azienda, TipoFlusso tipo, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition) {
        return this.getMisureEXml(azienda, tipo, false, "", raccolta, stato, statoEsportazione, dataInizio, dataFine, pod, partition, "R", this.querypnoer);
    }

    @Override
    public List<Mno2GE> getPdoEAXml(String azienda, TipoFlusso tipo, String regime, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition) {
        return this.getMisureEXml(azienda, tipo, true, regime, raccolta, stato, statoEsportazione, dataInizio, dataFine, pod, partition, "A", this.querypdoea);
    }

    @Override
    public List<Mno2GE> getPdoERXml(String azienda, TipoFlusso tipo, String regime, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition) {
        return this.getMisureEXml(azienda, tipo, true, regime, raccolta, stato, statoEsportazione, dataInizio, dataFine, pod, partition, "R", this.querypdoer);
    }

    private List<Mno2GE> getMisureEXml(String azienda, TipoFlusso tipo, boolean orario, String regime, String raccolta, int stato, String statoEsportazione, Date dataInizio, Date dataFine, String pod, Partition partition, String tipoSegnante, String query) {
        String template = JdbcMisureDao.replaceAziendaClause(query, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replacePodClause(template, pod, partition);
        template = JdbcMisureDao.replaceRaccoltaClause(template, raccolta);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisureEXml(stati, tipo, orario, regime, dataInizio, dataFine, tipoSegnante, template);
    }

    private List<Mno2GE> getMisureEXml(Iterable<Integer> stati, TipoFlusso tipoFlusso, boolean orario, String regime, Date dataInizio, Date dataFine, String tipoSegnante, String template) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":stati", stati);
        query.replace(":flusso", tipoFlusso.name());
        query.replace(":regime", regime);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        Mno2GECreator creator = new Mno2GECreator(tipoSegnante, orario);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno2GE> get2geaPod(String codicePod, String azienda, Date dataInizio, Date dataFine, TipoFlusso tipo) {
        String template = JdbcMisureDao.replaceAziendaClause(this.query2gea, azienda);
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        return this.getMisure2gEXml(stati, tipo, false, dataInizio, dataFine, template, TipoDettaglioOrario.EA);
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2gerXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.query2ger, azienda);
        template = template.replace(":tipo_rea", "T");
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, orario, dataInizio, dataFine, template, TipoDettaglioOrario.ERT);
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2gercXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        TipoDettaglioOrario tipo = TipoDettaglioOrario.ERC;
        String template = JdbcMisureDao.replaceAziendaClause(this.query2ger, azienda);
        template = template.replace(":tipo_rea", tipo.getTipoReattiva());
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, orario, dataInizio, dataFine, template, tipo);
    }

    @Override
    @Deprecated
    public List<Mno2GE> get2geriXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, boolean orario, String codicePod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.query2ger, azienda);
        TipoDettaglioOrario tipo = TipoDettaglioOrario.ERI;
        template = template.replace(":tipo_rea", tipo.getTipoReattiva());
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, orario, dataInizio, dataFine, template, tipo);
    }

    @Override
    @Deprecated
    public List<Mno2GE> getPdo2gRErXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querypdo2grer, azienda);
        TipoDettaglioOrario tipo = TipoDettaglioOrario.ERT;
        template = template.replace(":tipo_rea", tipo.getTipoReattiva());
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, pod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, true, dataInizio, dataFine, template, tipo);
    }

    @Override
    @Deprecated
    public List<Mno2GE> getPdo2gRERcXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querypdo2grer, azienda);
        TipoDettaglioOrario tipo = TipoDettaglioOrario.ERC;
        template = template.replace(":tipo_rea", tipo.getTipoReattiva());
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, pod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, true, dataInizio, dataFine, template, tipo);
    }

    @Override
    @Deprecated
    public List<Mno2GE> getPdo2gREriXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String pod, Partition partition) {
        String template = JdbcMisureDao.replaceAziendaClause(this.querypdo2grer, azienda);
        TipoDettaglioOrario tipo = TipoDettaglioOrario.ERI;
        template = template.replace(":tipo_rea", tipo.getTipoReattiva());
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_PDO_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, pod, partition);
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        return this.getMisure2gEXml(stati, flusso, true, dataInizio, dataFine, template, tipo);
    }

    @Override
    public List<Mno2GE> get2gerPod(String codicePod, String azienda, Date dataInizio, Date dataFine, TipoFlusso tipo, boolean orario) {
        String template = JdbcMisureDao.replaceAziendaClause(this.query2ger, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        TipoDettaglioOrario tipoDettaglio = TipoDettaglioOrario.ERT;
        template = JdbcMisureDao.replaceExportClause(template, tipoDettaglio.getTipoReattiva());
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<Integer> stati = JdbcMisureDao.getStati(0);
        return this.getMisure2gEXml(stati, tipo, orario, dataInizio, dataFine, template, tipoDettaglio);
    }

    @Override
    @Deprecated
    public Mno2GE getPdo2geaXml(String id) throws DataNotFoundException {
        return this.getpno2geXml(id, TipoDettaglioOrario.EA, this.querypdo2geaSingle, "misure_pod_orari_ea");
    }

    @Override
    @Deprecated
    public Mno2GE getPdo2gerXml(String id) throws DataNotFoundException {
        return this.getpno2geXml(id, TipoDettaglioOrario.ERT, this.querypdo2gerSingle, "misure_pod_orari_er");
    }

    @Override
    @Deprecated
    public Mno2GE getPdo2gercXml(String id) {
        return this.getFacoltativi2geXml(id, TipoDettaglioOrario.ERC, true, this.querypdo2gerSingle, "misure_pod_orari_er");
    }

    @Override
    @Deprecated
    public Mno2GE getPdo2geriXml(String id) {
        return this.getFacoltativi2geXml(id, TipoDettaglioOrario.ERI, true, this.querypdo2gerSingle, "misure_pod_orari_er");
    }

    @Override
    @Deprecated
    public Mno2GE getPno2geaXml(String id) throws DataNotFoundException {
        return this.getpno2geXml(id, TipoDettaglioOrario.EA, this.querypno2geaSingle, "misure_pod_non_orari_ea");
    }

    @Override
    @Deprecated
    public Mno2GE getPno2gerXml(String id) throws DataNotFoundException {
        return this.getpno2geXml(id, TipoDettaglioOrario.ERT, this.querypno2gerSingle, "misure_pod_non_orari_er");
    }

    @Override
    @Deprecated
    public Mno2GE getPno2gercXml(String id) {
        return this.getFacoltativi2geXml(id, TipoDettaglioOrario.ERC, false, this.querypno2gerSingle, "misure_pod_non_orari_er");
    }

    @Override
    @Deprecated
    public Mno2GE getPno2geriXml(String id) {
        return this.getFacoltativi2geXml(id, TipoDettaglioOrario.ERI, false, this.querypno2gerSingle, "misure_pod_non_orari_er");
    }

    private Mno2GE getpno2geXml(String id, TipoDettaglioOrario tipo, String template, String tabella) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":id", id);
        query.replace(":tipo_rea", tipo.getTipoReattiva());
        Mno2GECreator creator = new Mno2GECreator(tipo.getTipoSegnante(), false);
        List<Mno2GE> records = this.getRecords(query, creator);
        return JdbcMisureDao.getSingle(id, records, tabella);
    }

    private Mno2GE getFacoltativi2geXml(String id, TipoDettaglioOrario tipo, boolean orario, String template, String tabella) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":id", id);
        query.replace(":tipo_rea", tipo.getTipoReattiva());
        String tipoSegnante = tipo.getTipoSegnante();
        Mno2GECreator creator = new Mno2GECreator(tipoSegnante, orario);
        List<Mno2GE> records = this.getRecords(query, creator);
        return JdbcMisureDao.getSingleFacoltativo(id, records, tabella);
    }

    private List<Mno2GE> getMisure2gEXml(Iterable<Integer> stati, TipoFlusso flusso, boolean orario, Date dataInizio, Date dataFine, String template, TipoDettaglioOrario tipo) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":flusso", flusso.name());
        query.replace(":stati", stati);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        String tipoSegnante = tipo.getTipoSegnante();
        Mno2GECreator creator = new Mno2GECreator(tipoSegnante, orario);
        return this.getRecords(query, creator);
    }

    @Override
    public ListMap<String, Mno> getRsnRnv(int anno, Month mese, String pod) {
        String template = JdbcMisureDao.replacePodClause(this.queryRsnRnv, pod);
        QueryTemplate query = new QueryTemplate(template);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        query.replace(":data:", endDate, DATE_FORMAT_MISURE);
        MnoCreator creator = new MnoCreator(true);
        DefaultListMapKey<String, Mno> rsnRnv = new DefaultListMapKey<String, Mno>();
        this.buildClassifier(rsnRnv, query, creator);
        return rsnRnv;
    }

    @Override
    public List<Mno> getRnvXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRnvXml, azienda);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, stato);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice_flusso:", flusso.name());
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getRsnXml(String azienda, int stato, String statoEsportazione, Date dataInizio, Date dataFine, TipoFlusso flusso, String codicePod) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRsnXml, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replaceExportClause(template, statoEsportazione);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, stato);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        query.replace(":codice_flusso:", flusso.name());
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getRsnPodXml(String codicePod, Date dataInizio, Date dataFine, String azienda) {
        String template = JdbcMisureDao.replaceAziendaClause(this.queryRsnXmlPod, azienda);
        template = JdbcMisureDao.replaceDateClause(template, DATE_CLAUSE_XML);
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        JdbcMisureDao.replaceStati(query, 0);
        query.replace(":data_inizio:", dataInizio, DATE_FORMAT_DIESIS);
        query.replace(":data_fine:", dataFine, DATE_FORMAT_DIESIS);
        MnoCreator creator = new MnoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public Map<String, PraticaVolo> getVirtualPiv() {
        QueryTemplate query = new QueryTemplate("select * from stato_pod where cdunipre='AE1' and stato_ric ='P'");
        HashMap map = new HashMap();
        String idCalArera = this.configuration.getIdCalendarioArera();
        VirtualPivCreator creator = new VirtualPivCreator(idCalArera);
        return this.buildMap(map, query, creator);
    }

    private static String replaceClause(String template, String placeHolder, String field, String value) {
        String clause = StringUtils.isEmpty(value) ? "" : String.valueOf(field) + "='" + value.trim() + "' AND";
        return template.replaceAll(placeHolder, clause);
    }

    private static String replaceGiadaDbName(String template, String giadaDbName) {
        return template.replaceAll(":giada-db:", giadaDbName);
    }

    private static String replacePodClause(String template, String pod, Partition partition) {
        return partition != null && StringUtils.isEmpty(pod) ? JdbcMisureDao.replacePodClause(template, partition) : JdbcMisureDao.replacePodClause(template, pod);
    }

    private static String replacePodClause(String template, Partition partition) {
        String prefix = partition.getPrefix();
        int prefixLength = prefix.length();
        String clause = "substr(pod_id, 1, " + prefixLength + ") = '" + prefix + "' AND";
        return template.replaceAll("pod-clause", clause);
    }

    private static String replacePodClause(String template, String pod) {
        return JdbcMisureDao.replaceClause(template, "pod-clause", "pod_id", pod);
    }

    private static String replaceRaccoltaClause(String template, String raccolta) {
        return JdbcMisureDao.replaceClause(template, "raccolta-clause", "raccolta", raccolta);
    }

    private static String replaceRegimeClause(String template, String regime) {
        return JdbcMisureDao.replaceClause(template, "regime-clause", "regime", regime);
    }

    private static String replaceAziendaClauseCdAnagra(String template, String azienda) {
        String fixAzienda = azienda.equals("*") ? "" : azienda;
        return JdbcMisureDao.replaceClause(template, "azienda-clause", "cdanagra", fixAzienda);
    }

    private static String replaceAziendaClause(String template, String azienda) {
        return JdbcMisureDao.replaceClause(template, "azienda-clause", "cdaziend", azienda);
    }

    private static String replaceAziendaXmlClause(String template, String azienda) {
        String trim;
        String clause = azienda == null ? "" : String.valueOf((trim = azienda.trim()).isEmpty() ? "cdaziend <> '" : "cdaziend='" + trim) + "' AND";
        return template.replaceAll("azienda-clause", clause);
    }

    private static String replaceExportClause(String template, String statoEsportazione) {
        return JdbcMisureDao.replaceClause(template, "export-clause", "flexport", statoEsportazione);
    }

    private static String replaceDateClause(String template, String clause) {
        return template.replaceAll("date-clause", clause);
    }

    private static void replaceStati(QueryTemplate query, int stato) {
        List<Integer> stati = JdbcMisureDao.getStati(stato);
        query.replace(":stati", stati);
    }

    private static List<Integer> getStati(int stato) {
        List<Integer> stati = stato == 0 ? BasicDaoHelper.buildCodiciStatoMisure(StrategyHelper.STATI_ALL) : Arrays.asList(stato);
        return stati;
    }

    private static void replaceRaccolte(QueryTemplate query, String raccolta) {
        List<String> raccolte = raccolta.isEmpty() ? Arrays.asList("P", "T", "V", "S", " ") : Arrays.asList(raccolta);
        query.replace(":raccolte:", raccolte);
    }

    @Override
    public Snf getSnf(String codicePod, Date data, boolean unique) throws DataNotFoundException {
        String template = JdbcMisureDao.replaceAziendaClause(this.querySnf, "");
        template = JdbcMisureDao.replaceExportClause(template, "");
        template = JdbcMisureDao.replaceDateClause(template, "to_char(data_inizio,'yyyy-mm-dd')<=:data: AND ");
        template = JdbcMisureDao.replacePodClause(template, codicePod);
        List<StatoMisure> stati = Arrays.asList(StatoMisure.ELABORATO);
        List<Snf> snf = this.getSnf(data, BasicDaoHelper.buildCodiciStatoMisure(stati), template);
        String key = String.valueOf(codicePod) + "/" + data;
        switch (snf.size()) {
            case 0: {
                throw new DataNotFoundException("snf.notfound", key, ErroriElaborazione.SNF_NOTFOUND.ordinal());
            }
            case 1: {
                break;
            }
            default: {
                if (!unique) break;
                throw new DataNotFoundException("snf.toomany", key, ErroriElaborazione.SNF_TOOMANY.ordinal());
            }
        }
        int last = snf.size() - 1;
        return snf.get(last);
    }

    @Override
    public void updateMatricolaStatoPod(String codicePod, String fittizia, String matricola) {
        String[] stringArray = new String[]{"numatric_a", "numatric_r", "numatric_p", "numatric_b"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String fieldName = stringArray[n3];
            String template = "update stato_pod set :numatric:=:matricola: where :numatric:=:fittizia: and pod=:codice_pod:";
            template = template.replaceAll(":numatric:", fieldName);
            QueryTemplate query = new QueryTemplate(template);
            query.replace(":matricola:", matricola);
            query.replace(":fittizia:", fittizia);
            query.replace(":codice_pod:", codicePod);
            this.executeUpdateNoControl(query);
            ++n3;
        }
    }

    @Override
    public Mno getVno(String codicePod, Date dataPrestazione) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("select * from misure_pod_non_orari where pod_id = :codicePod: AND cod_flusso in('VNO', 'VNO2G') AND stato in (4,5) AND to_char(data_prestazione, 'yyyy-mm-dd') = :data:");
        query.replace(":codicePod:", codicePod);
        query.replace(":data:", dataPrestazione, DATE_FORMAT_MISURE);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecord(query, creator, "", "");
    }

    @Override
    public Mno getVno(String codicePod, Date dataPrestazione, String codiceDisp) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("select * from misure_pod_non_orari where pod_id = :codicePod: AND cod_flusso in('VNO', 'VNO2G') AND stato in (4,5) AND to_char(data_prestazione, 'yyyy-mm-dd') = :data: AND contratto_dispacciamento = :codice_disp:");
        query.replace(":codicePod:", codicePod);
        query.replace(":data:", dataPrestazione, DATE_FORMAT_MISURE);
        query.replace(":codice_disp:", codiceDisp);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecord(query, creator, "", "");
    }

    @Override
    public Mno getVno(Mno rno) throws DataNotFoundException {
        return this.getRettificaSenzaMisura(rno, "to_char(data_misura,'yyyy-mm-dd')=:dataMisura: and ", FLUSSI_VNO, ErroriElaborazione.RNO_SENZA_VNO);
    }

    @Override
    public Mno getSnm(Mno snm) throws DataNotFoundException {
        return this.getRettificaSenzaMisura(snm, "(to_char(data_misura,'yyyy-mm-dd')=:dataMisura: OR cod_pratica_attivazione=:cp:) and ", FLUSSI_SNM, ErroriElaborazione.RNO_SENZA_SNM);
    }

    private Mno getRettificaSenzaMisura(Mno mno, String clause, String[] flussiArray, ErroriElaborazione errore) throws DataNotFoundException, MultipleRowException {
        String codicePod = mno.getCodicePod();
        Date dataMisura = mno.getDataMisura();
        QueryTemplate query = new QueryTemplate("select * from misure_pod_non_orari where pod_id = :codicePod: and " + clause + "cod_flusso in(:flussi:) and " + "stato = 8 ");
        query.replace(":codicePod:", codicePod);
        query.replace(":dataMisura:", dataMisura, DATE_FORMAT_MISURE);
        query.replace(":cp:", mno.getCodPratAtt());
        List<String> flussi = Arrays.asList(flussiArray);
        query.replace(":flussi:", flussi);
        MnoCreator creator = new MnoCreator(false);
        String message = errore.getMessage();
        int ordinal = errore.ordinal();
        return this.getRecord(query, creator, message, codicePod, ordinal);
    }

    @Override
    public void saveVoltureIV(List<PraticaVolo> pivVoltureIV) {
        for (PraticaVolo pratica : pivVoltureIV) {
            QueryTemplate query = new QueryTemplate("INSERT INTO flussi_interni (CODICE_PRESTAZIONE,CODICE_FLUSSO,POD_ID,COD_PRATICA_UTENTE,DATA_INIZIO,TRATTAMENTO_POD,STATO,COD_ERRORE,DESC_ERRORE,CDAZIEND) VALUES(:cdprerif:,'D65',:pod:,:cod_prat_att:,to_date(:data:,'yyyy-mm-dd'),'F',4,0,'',:azienda:)");
            try {
                SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
                query.replace(":cdprerif:", pratica.getCodicePrestazione());
                query.replace(":pod:", pratica.getCodicePod());
                query.replace(":cod_prat_att:", pratica.getCodPratAtt());
                query.replace(":data:", specificaTecnica.getData(), DATE_FORMAT_MISURE);
                query.replace(":azienda:", pratica.getCodiceReseller());
                this.executeInsert(query);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, List<VolturaIV>> getVoltureIV(String onlyPod) {
        String template = JdbcMisureDao.replacePodClause(this.queryVoltureIV, onlyPod);
        QueryTemplate query = new QueryTemplate(template);
        List<VolturaIV> records = this.getRecords(query, new VoltureIVCreator());
        LinkedHashMap<String, List<VolturaIV>> map = new LinkedHashMap<String, List<VolturaIV>>();
        AziendaExtractor extractor = new AziendaExtractor();
        ListVolturaIVBuilder builder = new ListVolturaIVBuilder();
        StructuresHelper.buildCollectionsMap(map, records, extractor, builder);
        return map;
    }

    @Override
    public VolturaIV getVolturaIV(String codicePod, Date data) throws DataNotFoundException, MultipleRowException {
        String template = JdbcMisureDao.replacePodClause(this.queryVolturaIV, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":data:", DATE_FORMAT_MISURE.format(data));
        VoltureIVCreator creator = new VoltureIVCreator();
        String key = String.valueOf(codicePod) + "|" + data;
        return this.getRecord(query, creator, null, key, true);
    }

    @Override
    public boolean verifyPdos(String codicePod, int anno, Month mese) {
        List<Pdo> pdo = this.getPdoFinoMese(anno, mese, "", codicePod, StrategyHelper.STATI);
        return !pdo.isEmpty();
    }

    @Override
    public SetMap<Date, DatiMisura> getMesiRettifiche(int anno, Month mese, String onlyPod, Destinatari destinatari) {
        TreeSetMapKey<Date, DatiMisura> mesiRettifiche = new TreeSetMapKey<Date, DatiMisura>();
        this.fillMesiRettificheNonorari(anno, mese, destinatari, onlyPod, mesiRettifiche);
        this.fillMesiRettificheOrari(anno, mese, destinatari, onlyPod, mesiRettifiche);
        return mesiRettifiche;
    }

    @Override
    @Deprecated
    public Map<String, DatiMisura> getLastMisure(Set<String> podSet, Destinatari destinatari) {
        String template = "SELECT pod_id, max(data_misura) as data FROM misure_pod_non_orari mpno LEFT JOIN misure_pod_non_orari_tar mpnot on (mpno.id=mpnot.id) WHERE  pod_id in (:codici:) AND  cod_flusso in ('PNO', 'RNO', 'PNO2G', 'RNO2G', 'VNO') AND  destinatari-clause GROUP BY pod_id ORDER BY pod_id";
        template = JdbcMisureDao.replaceDestinatariClause(destinatari, template, StrategyHelper.ELABORATO);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codici:", podSet);
        LastMisuraCreator creator = new LastMisuraCreator();
        HashMap<String, DatiMisura> map = new HashMap<String, DatiMisura>();
        CodicePodExtractor extractor = new CodicePodExtractor();
        this.buildMap(map, query, creator, extractor);
        return map;
    }

    private void fillMesiRettificheOrari(int anno, Month mese, Destinatari destinatari, String onlyPod, SetMapKey<Date, DatiMisura> mesiRettifiche) {
        String template = "SELECT anno, mese, pod_id FROM misure_pod_orari WHERE  pod-clause  (anno<:anno: OR (anno=:anno: AND mese<=:mese:)) AND  cod_flusso in ('PDO', 'RFO', 'PDO2G', 'RFO2G') AND  destinatari-clause GROUP BY anno, mese, pod_id ORDER BY anno, mese, pod_id";
        template = JdbcMisureDao.replacePodClause(template, onlyPod);
        template = JdbcMisureDao.replaceDestinatariClause(destinatari, template, StrategyHelper.STATI);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        DatiRettificaCreator creator = new DatiRettificaCreator();
        this.buildClassifier(mesiRettifiche, query, creator);
    }

    private void fillMesiRettificheNonorari(int anno, Month mese, Destinatari destinatari, String onlyPod, SetMapKey<Date, DatiMisura> mesiRettifiche) {
        String template = "SELECT\tto_char(data_misura, 'yyyy') as anno, to_char(data_misura, 'mm') as mese, pod_id FROM misure_pod_non_orari mpno LEFT JOIN misure_pod_non_orari_tar mpnot on (mpno.id=mpnot.id) WHERE  pod-clause  cod_flusso in ('PNO', 'RNO', 'PNO2G', 'RNO2G') AND  to_char(data_misura, 'yyyy-mm') <= :annomese: AND  destinatari-clause GROUP BY to_char(data_misura, 'yyyy'), to_char(data_misura, 'mm'), pod_id ORDER BY to_char(data_misura, 'yyyy'), to_char(data_misura, 'mm'), pod_id";
        template = JdbcMisureDao.replacePodClause(template, onlyPod);
        template = JdbcMisureDao.replaceDestinatariClause(destinatari, template, StrategyHelper.STATI);
        QueryTemplate query = new QueryTemplate(template);
        String annomese = JdbcMisureDao.formatAnnoMese(anno, mese);
        query.replace(":annomese:", annomese);
        DatiRettificaCreator creator = new DatiRettificaCreator();
        this.buildClassifier(mesiRettifiche, query, creator);
    }

    private static String formatAnnoMese(int anno, Month mese) {
        return String.valueOf(anno) + "-" + StrategyHelper.getMeseNumFormat().format(mese.getIndex());
    }

    @Override
    public List<AliquotaPerdite> getAliquotePerdite() {
        QueryTemplate query = new QueryTemplate("select * from aliquote_perdite order by data");
        AliquotePerditeCreator creator = new AliquotePerditeCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public PraMensile getPraEsatto(String pivaDistributore, int idZona, int anno, Month mese) throws DataNotFoundException {
        SafeMap<Date, PraGiornaliero> pra = this.getPraMeseEsatto(pivaDistributore, idZona, anno, mese);
        PraMensile praMensile = JdbcMisureDao.isCompletePra(pra, pra.size(), anno, mese) ? new PraMensile(anno, mese, pra) : this.getPraRicalendarizzato(pivaDistributore, idZona, anno, mese);
        return praMensile;
    }

    @Override
    public PraMensile getPraRicalendarizzato(String pivaDistributore, int idZona, int anno, Month mese) throws DataNotFoundException {
        List<PraGiornaliero> pra = this.ricalendarizzazione(pivaDistributore, idZona, anno, mese);
        return new PraMensile(anno, mese, pra);
    }

    private List<Ricalendarizzazione> getRicalendarizzazione(int anno, Month mese) {
        QueryTemplate query = new QueryTemplate("SELECT * FROM ricalendarizzazione  WHERE to_char(data_reale, 'yyyymm') = :anno_mese:  ORDER BY data_reale");
        Date annoMese = CalendarTools.getDate(anno, mese, 1);
        query.replace(":anno_mese:", annoMese, StrategyCommonHelper.getAnnoMeseDateFormat());
        RicalendarizzazioneCreator creator = new RicalendarizzazioneCreator();
        return this.getRecords(query, creator);
    }

    private List<PraGiornaliero> ricalendarizzazione(String pivaDistributore, int idZona, int anno, Month mese) throws DataNotFoundException {
        List<Ricalendarizzazione> ricalMese = this.getRicalendarizzazione(anno, mese);
        Date date = CalendarTools.getDate(anno, mese, 1);
        if (!JdbcMisureDao.isComplete(ricalMese.size(), anno, mese)) {
            ErroriElaborazione errore = ErroriElaborazione.INVALID_RICALENDARIZZAZIONE;
            String message = errore.getMessage();
            DateFormat meseAnnoFormat = StrategyHelper.getMeseAnnoFormat();
            String key = meseAnnoFormat.format(date);
            int error = errore.ordinal();
            throw new DataNotFoundException(message, key, error);
        }
        Date maxDate = new Date(0L);
        Date minDate = CalendarTools.getEndOfTime();
        for (Ricalendarizzazione current : ricalMese) {
            Date dataRical = current.getDataRical();
            minDate = CalendarTools.min(minDate, dataRical);
            maxDate = CalendarTools.max(maxDate, dataRical);
        }
        boolean orario = minDate.before(CalendarTools.getDate(2025, Month.JANUARY, 1));
        SafeMap<Date, PraGiornaliero> rifPra = this.getPra(pivaDistributore, idZona, minDate, maxDate, orario);
        ArrayList<PraGiornaliero> pra = new ArrayList<PraGiornaliero>();
        for (Ricalendarizzazione current : ricalMese) {
            Date dataRical = current.getDataRical();
            Date dataReale = current.getDataReale();
            PraGiornaliero praRical = ((PraGiornaliero)rifPra.get(dataRical)).newPra(dataReale);
            praRical.setDate(dataReale);
            pra.add(praRical);
        }
        if (!JdbcMisureDao.isCompletePra(pra, pra.size(), anno, mese)) {
            ErroriElaborazione errore = ErroriElaborazione.INVALID_PRA;
            String message = errore.getMessage();
            DateFormat meseAnnoFormat = StrategyHelper.getMeseAnnoFormat();
            String key = meseAnnoFormat.format(date);
            int error = errore.ordinal();
            throw new DataNotFoundException(message, key, error);
        }
        return pra;
    }

    public SafeMap<Date, PraGiornaliero> getPra(String pivaDistributore, int idZona, Date minDate, Date maxDate, boolean orario) {
        SafeMap<Date, PraGiornaliero> rifPra = orario ? this.getPraOrario(pivaDistributore, idZona, minDate, maxDate) : this.getPraQuartorarioConverted(pivaDistributore, idZona, minDate, maxDate);
        return rifPra;
    }

    private static boolean isCompletePra(Iterable<PraGiornaliero> pra, int size, int anno, Month mese) {
        boolean ok = JdbcMisureDao.isComplete(size, anno, mese);
        if (ok) {
            int giorno = 0;
            for (PraGiornaliero praGiornaliero : pra) {
                int hoursOfDay;
                double[] values = praGiornaliero.getValues();
                ok &= values.length == (hoursOfDay = CalendarTools.getHoursOfDay(anno, mese, ++giorno));
            }
        }
        return ok;
    }

    private static boolean isComplete(int size, int anno, Month mese) {
        int daysOfMonth = CalendarTools.getDaysOfMonth(anno, mese);
        return size == daysOfMonth;
    }

    private SafeMap<Date, PraGiornaliero> getPraOrario(String pivaDistributore, int idZona, Date startDate, Date endDate) {
        QueryTemplate query = new QueryTemplate("SELECT * FROM prelievi_residui_area WHERE piva_distributore = :piva_distributore: AND zona_id = :id_zona: AND to_char(data_riferimento, 'yyyy-mm-dd') >= :start_date: AND to_char(data_riferimento, 'yyyy-mm-dd') <= :end_date: ORDER BY data_riferimento");
        query.replace(":piva_distributore:", pivaDistributore);
        query.replace(":id_zona:", idZona);
        DateFormat formatter = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":start_date:", startDate, formatter);
        query.replace(":end_date:", endDate, formatter);
        PraGiornalieroCreator creator = new PraGiornalieroCreator(false);
        ErrorWrapper error = new ErrorWrapper(ErroriElaborazione.INVALID_PRA);
        DefaultSafeMap map = new DefaultSafeMap(error);
        return this.buildMap(map, query, creator);
    }

    private SafeMap<Date, PraGiornaliero> getPraQuartorarioConverted(String pivaDistributore, int idZona, Date minDate, Date maxDate) {
        SafeMap<Date, PraGiornaliero> praQuartorario = this.getPraQuartorario(pivaDistributore, idZona, minDate, maxDate);
        return JdbcMisureDao.convertOrario(praQuartorario);
    }

    private static SafeMap<Date, PraGiornaliero> convertOrario(SafeMap<Date, PraGiornaliero> praQuartorario) {
        ErrorWrapper error = new ErrorWrapper(ErroriElaborazione.INVALID_PRA);
        DefaultSafeMap<Date, PraGiornaliero> praOrario = new DefaultSafeMap<Date, PraGiornaliero>(error);
        for (Map.Entry entry : praQuartorario.entrySet()) {
            Date date = (Date)entry.getKey();
            PraGiornaliero praGiornalieroQuartorario = (PraGiornaliero)entry.getValue();
            PraGiornaliero praGiornalieroOrario = JdbcMisureDao.convertOrario(praGiornalieroQuartorario);
            praOrario.add(date, praGiornalieroOrario);
        }
        return praOrario;
    }

    private static PraGiornaliero convertOrario(PraGiornaliero praGiornalieroQuartorario) {
        int idZona = praGiornalieroQuartorario.getIdZona();
        Date date = praGiornalieroQuartorario.getDate();
        double[] valuesQuartorari = praGiornalieroQuartorario.getValues();
        double[] valuesOrari = JdbcMisureDao.convertOrario(valuesQuartorari);
        return new PraGiornaliero(idZona, date, valuesOrari);
    }

    private static double[] convertOrario(double[] valuesQuartorari) {
        int size = valuesQuartorari.length / 4;
        double[] valuesOrari = new double[size];
        int index = 0;
        double[] dArray = valuesQuartorari;
        int n2 = valuesQuartorari.length;
        int n3 = 0;
        while (n3 < n2) {
            double value = dArray[n3];
            int n4 = index / 4;
            valuesOrari[n4] = valuesOrari[n4] + value;
            ++index;
            ++n3;
        }
        return valuesOrari;
    }

    private SafeMap<Date, PraGiornaliero> getPraQuartorario(String pivaDistributore, int idZona, Date startDate, Date endDate) {
        QueryTemplate query = new QueryTemplate("SELECT pra.*, data as data_riferimento FROM prelievi_residui_area_m15 pra WHERE piva_distrib = :piva_distributore: AND zona_id = :id_zona: AND to_char(data, 'yyyy-mm-dd') >= :start_date: AND to_char(data, 'yyyy-mm-dd') <= :end_date: ORDER BY data");
        query.replace(":piva_distributore:", pivaDistributore);
        query.replace(":id_zona:", idZona);
        DateFormat formatter = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":start_date:", startDate, formatter);
        query.replace(":end_date:", endDate, formatter);
        PraGiornalieroCreator creator = new PraGiornalieroCreator(true);
        ErrorWrapper error = new ErrorWrapper(ErroriElaborazione.INVALID_PRA);
        DefaultSafeMap map = new DefaultSafeMap(error);
        return this.buildMap(map, query, creator);
    }

    private SafeMap<Date, PraGiornaliero> getPraMeseEsatto(String pivaDistributore, int idZona, int anno, Month mese) {
        Date dataInizio = CalendarTools.getDate(anno, mese, 1);
        Date dataFine = CalendarTools.getEndOfMonth(dataInizio);
        boolean orario = dataInizio.before(CalendarTools.getDate(2026, Month.JANUARY, 1));
        return this.getPra(pivaDistributore, idZona, dataInizio, dataFine, orario);
    }

    @Override
    public SafeMap<String, Comune> getComuniMap() {
        ErrorWrapper mapError = new ErrorWrapper(ErroriElaborazione.COMUNE_NOTFOUND);
        DefaultSafeMap<String, Comune> comuniMap = new DefaultSafeMap<String, Comune>(mapError);
        QueryTemplate query = new QueryTemplate("select * from comuni");
        ComuneCreator creator = new ComuneCreator();
        this.buildMap(comuniMap, query, creator);
        return comuniMap;
    }

    @Override
    public boolean recordTariffeElaborate(ServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        RecordTariffeElaborateHandler handler = new RecordTariffeElaborateHandler(connection, status);
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        return this.executeMultiUpdate(handler, exceptionHandler);
    }

    @Override
    public Set<String> getPodTariffeElaborate(Set<String> podCandidatiScivoloBatch, int anno, Month mese, Destinatari destinatari) {
        QueryTemplate query = new QueryTemplate("SELECT * FROM tariffe_elaborate WHERE  pod in (:codicipod:)  AND dispatcher = :dispatcher:  AND to_char(data_inizio, 'yyyy-mm') = :annomese:");
        query.replace(":codicipod:", podCandidatiScivoloBatch);
        query.replace(":dispatcher:", destinatari.isDispatcher() ? "1" : "0");
        query.replace(":annomese:", JdbcMisureDao.formatAnnoMese(anno, mese));
        KeyTariffaElaborataCreator creator = new KeyTariffaElaborataCreator();
        return this.getSet(query, creator);
    }

    @Override
    public List<Lettura> getLetture(String codicePod, Date data) {
        Date startDate = CalendarTools.previousDay(data);
        Date endDate = CalendarTools.getNextMese(data);
        QueryTemplate query = new QueryTemplate("SELECT * FROM letture LEFT JOIN misure_pod_non_orari_tar mpnot ON (id_riferimento = mpnot.id) WHERE pod = :codicePod: AND to_char(data, 'yyyy-mm-dd') >= :start_date: AND to_char(data, 'yyyy-mm-dd') < :end_date:  AND tipo != 'S' ORDER BY data");
        query.replace(":codicePod:", codicePod);
        DateFormat formatter = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":start_date:", startDate, formatter);
        query.replace(":end_date:", endDate, formatter);
        LettureCreator creator = new LettureCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public Map<String, DistributoreSotteso> getPivaMap() {
        HashMap<String, DistributoreSotteso> pivaMap = new HashMap<String, DistributoreSotteso>();
        QueryTemplate query = new QueryTemplate("SELECT * FROM ANAGR_DISTR_SOTT");
        DistributoreSottesoCreator creator = new DistributoreSottesoCreator();
        this.buildMap(pivaMap, query, creator);
        return pivaMap;
    }

    @Override
    public Map<String, Multipunto> getMultiPodMap(int anno, Month mese) {
        ListMap<String, MultipuntoOption> optionsMap = this.getMultipuntoOptions(anno, mese);
        QueryTemplate query = new QueryTemplate("SELECT trim(pod) as key, cod_raggruppamento, dtinicom, dtfincom FROM multipunto_ass WHERE    to_char(dtinicom, 'yyyy-mm-dd') < :end-date: AND    (dtfincom is null OR to_char(dtfincom, 'yyyy-mm-dd') >= :start-date:)");
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        Date startDate = CalendarTools.getDate(anno, mese, 1);
        query.replace(":start-date:", startDate, dateFormat);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        query.replace(":end-date:", endDate, dateFormat);
        MultipuntoEntryCreator creator = new MultipuntoEntryCreator();
        List<MultipuntoEntry> records = this.getRecords(query, creator);
        HashMap<String, List<MultipuntoEntry>> entryMap = new HashMap<String, List<MultipuntoEntry>>();
        RaggruppamentoExtractor extractor = new RaggruppamentoExtractor();
        MultipuntoListBuilder builder = new MultipuntoListBuilder();
        StructuresHelper.buildCollectionsMap(entryMap, records, extractor, builder);
        return JdbcMisureDao.buildMultipuntoMap(entryMap, optionsMap);
    }

    private static Map<String, Multipunto> buildMultipuntoMap(Map<String, List<MultipuntoEntry>> entryMap, ListMap<String, MultipuntoOption> optionsMap) {
        HashMap<String, Multipunto> multipuntoMap = new HashMap<String, Multipunto>();
        for (Map.Entry<String, List<MultipuntoEntry>> entry : entryMap.entrySet()) {
            String raggruppamento = entry.getKey();
            List<MultipuntoEntry> entries = entry.getValue();
            ArrayList<MultipuntoOption> options = (ArrayList<MultipuntoOption>)optionsMap.get(raggruppamento);
            if (options == null) {
                options = new ArrayList<MultipuntoOption>();
            }
            multipuntoMap.put(raggruppamento, new Multipunto(raggruppamento, entries, options));
        }
        return multipuntoMap;
    }

    private ListMap<String, MultipuntoOption> getMultipuntoOptions(int anno, Month mese) {
        DefaultListMapKey<String, MultipuntoOption> map = new DefaultListMapKey<String, MultipuntoOption>();
        QueryTemplate query = new QueryTemplate("SELECT * FROM multipunto_opz  WHERE    to_char(dtvalidi,'yyyy-mm-dd')<=:inizio:    AND (dtscaden is null OR to_char(dtscaden,'yyyy-mm-dd')>=:fine:)");
        Date inizio = CalendarTools.getDate(anno, mese, 1);
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":inizio:", inizio, dateFormat);
        Date fine = CalendarTools.getNextMese(anno, mese);
        query.replace(":fine:", fine, dateFormat);
        MultiPuntoOptionCreator creator = new MultiPuntoOptionCreator();
        this.buildClassifier(map, query, creator);
        return map;
    }

    @Override
    public Set<Date> getOrePicco(int anno, Month mese) {
        QueryTemplate query = new QueryTemplate("select * from ore_picco where anno=:anno: AND mese=:mese:");
        query.replace(":anno:", anno);
        query.replace(":mese:", mese.getIndex());
        DateCreator creator = new DateCreator();
        return new HashSet<Date>(this.getRecords(query, creator));
    }

    @Override
    public List<ValorePicco> getValoriPicco() {
        QueryTemplate query = new QueryTemplate("SELECT * FROM valori_picco ORDER BY start_date");
        ValorePiccoCreator creator = new ValorePiccoCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Integer> getSubapplicazioni(Applicazione applicazione, int anno, Month mese) {
        return this.getSubapplicazioni("applicazioni_sub", applicazione, anno, mese);
    }

    @Override
    public List<Mno> getMnoPrestazione(String codicePod, Date dataPratica, Iterable<StatoMisure> stati, Iterable<String> flussi) {
        QueryTemplate query = new QueryTemplate(this.queryMnoPrestazioni);
        query.replace(":codice_pod:", codicePod);
        query.replace(":data_prestazione:", dataPratica, DATE_FORMAT_MISURE);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        query.replace(":flussi:", flussi);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public List<Mno> getMnoPrestazione(int anno, Month mese, Iterable<StatoMisure> stati, Iterable<String> flussi) {
        QueryTemplate query = new QueryTemplate(this.queryMnoPrestazioniOrfane);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        query.replace(":end_date:", endDate, DATE_FORMAT_MISURE);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        query.replace(":flussi:", flussi);
        MnoCreator creator = new MnoCreator(true);
        return this.getRecords(query, creator);
    }
}

