/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.dao.JdbcIndiciDao;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.NotDeletableException;

public class JdbcIndiciDaoTest
extends TestCase {
    public void testGetIndici() throws NotDeletableException, IOException {
        TestConfiguration configuration = new TestConfiguration();
        JdbcIndiciDao dao = new JdbcIndiciDao(configuration);
        JdbcIndiciDaoTest.resetDb(dao);
        List<IndiceOrario> indici = dao.getIndici(2017, Month.APRIL);
        JdbcIndiciDaoTest.assertTrue(indici.isEmpty());
        JdbcIndiciDaoTest.fillDb(dao);
        indici = dao.getIndici(2017, Month.APRIL);
        JdbcIndiciDaoTest.assertEquals(720, indici.size());
        JdbcIndiciDaoTest.assertEquals(2, indici.get(0).getMercato());
        JdbcIndiciDaoTest.assertEquals(3, indici.get(1).getZona());
        JdbcIndiciDaoTest.assertEquals(CalendarTools.getDate(2017, Month.APRIL, 1).getTime(), indici.get(2).getData().getTime());
        JdbcIndiciDaoTest.assertEquals(4, indici.get(3).getOra());
        JdbcIndiciDaoTest.assertEquals(5.0, indici.get(4).getPrezzo(), 0.0);
        JdbcIndiciDaoTest.assertEquals(2, indici.get(719).getMercato());
        JdbcIndiciDaoTest.assertEquals(3, indici.get(719).getZona());
        JdbcIndiciDaoTest.assertEquals(CalendarTools.getDate(2017, Month.APRIL, 30).getTime(), indici.get(719).getData().getTime());
        JdbcIndiciDaoTest.assertEquals(24, indici.get(719).getOra());
        JdbcIndiciDaoTest.assertEquals(720.0, indici.get(719).getPrezzo(), 0.0);
    }

    private static void resetDb(JdbcIndiciDao dao) throws NotDeletableException {
        dao.executeDelete("delete from indici");
    }

    private static void fillDb(JdbcIndiciDao dao) {
        String insert = "";
        int giorno = 1;
        while (giorno <= 30) {
            int ora = 1;
            while (ora <= 24) {
                insert = String.valueOf(insert) + "insert into indici values('2','3','2017-04-" + giorno + "','" + ora + "','" + giorno * ora + "');";
                ++ora;
            }
            ++giorno;
        }
        dao.execute(insert);
    }
}

