/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.JdbcGiadaDao;
import biz.elabor.prebilling.dao.creator.IndiceOrarioCreator;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.CurvaIndiciMensile;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.services.StrategyHelper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.ConnectionManager;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class JdbcIndiciDao
extends ConnectionManager
implements IndiciDao {
    private static final DateFormat ANNO_MESE_FORMAT = new SimpleDateFormat("yyyy-MM");
    private String queryIndici;

    public JdbcIndiciDao(PrebillingConfiguration configuration) throws IOException {
        super(configuration.getIndiciHost(), configuration.getIndiciDbmsType(), configuration.getIndiciDbName(), configuration.getIndiciDbUser(), configuration.getIndiciDbPassword());
        ClassLoader classLoader = JdbcGiadaDao.class.getClassLoader();
        this.queryIndici = JdbcIndiciDao.loadTemplate(classLoader, "query-indici.sql");
    }

    @Override
    public List<IndiceOrario> getIndici(int anno, Month mese) {
        QueryTemplate query = new QueryTemplate(this.queryIndici);
        IndiceOrarioCreator creator = new IndiceOrarioCreator();
        java.util.Date date = CalendarTools.getDate(anno, mese, 1);
        query.replace(":anno_mese", date, ANNO_MESE_FORMAT);
        return this.getRecords(query, creator);
    }

    @Override
    public void upsertIndiciMensili(Offerta offerta, CurvaIndiciMensile newCurvaMensile, CurvaIndiciMensile oldCurvaMensile, TalkManager talkManager) {
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        boolean ok = true;
        try {
            try {
                this.startTransaction();
                for (CurvaIndiciGiornaliera newCurvaGiorno : newCurvaMensile) {
                    int giornoIndex = newCurvaMensile.indexOf(newCurvaGiorno);
                    CurvaIndiciGiornaliera oldCurvaGiorno = oldCurvaMensile == null ? null : (CurvaIndiciGiornaliera)oldCurvaMensile.get(giornoIndex);
                    for (IndiceOrario newIndiceOrario : newCurvaGiorno) {
                        int oraIndex = newCurvaGiorno.indexOf(newIndiceOrario);
                        int ora = oraIndex + 1;
                        IndiceOrario oldIndiceOrario = oldCurvaGiorno == null ? null : (IndiceOrario)oldCurvaGiorno.get(oraIndex);
                        ok &= this.upsertIndiceOrario(mercato, zona, ora, newIndiceOrario, oldIndiceOrario);
                    }
                }
                this.commit();
                if (!ok) {
                    Message sentence = new Message("compute.tariffe", "indice.perseo.changed");
                    DateFormat dateFormat = StrategyHelper.getMeseAnnoFormat();
                    int anno = newCurvaMensile.getAnno();
                    Month mese = newCurvaMensile.getMese();
                    java.util.Date data = CalendarTools.getDate(anno, mese, 1);
                    String meseStr = dateFormat.format(data);
                    sentence.addParam(String.valueOf(mercato) + "/" + zona + " - " + meseStr);
                    talkManager.addSentence(sentence);
                }
            }
            catch (SQLException exc) {
                throw new RuntimeException(exc);
            }
        }
        finally {
            this.rollback();
        }
    }

    private boolean upsertIndiceOrario(int mercato, int zona, int ora, IndiceOrario newIndice, IndiceOrario oldIndice) throws SQLException {
        boolean ok = true;
        if (oldIndice == null) {
            this.insertIndiceOrario(mercato, zona, ora, newIndice);
        } else if (oldIndice.getPrezzo() != newIndice.getPrezzo()) {
            this.updateIndiceOrario(mercato, zona, ora, newIndice);
            ok = false;
        }
        return ok;
    }

    private void updateIndiceOrario(int mercato, int zona, int ora, IndiceOrario indice) throws SQLException {
        String query = "UPDATE Esiti_GME_EE set prezzo=? WHERE mercato_id=? AND zona_id=? AND data=? AND ora=?";
        this.executeQuery(query, mercato, zona, ora, indice);
    }

    private void insertIndiceOrario(int mercato, int zona, int ora, IndiceOrario indice) throws SQLException {
        String query = "INSERT into Esiti_GME_EE (prezzo, id, mercato_id, zona_id, data, ora) SELECT ?, COALESCE(max(id),0)+1, ?, ?, ?, ? FROM Esiti_GME_EE";
        this.executeQuery(query, mercato, zona, ora, indice);
    }

    public void executeQuery(String query, int mercato, int zona, int ora, IndiceOrario indice) throws SQLException {
        Connection connection = this.getConnection();
        Throwable throwable = null;
        Object var8_9 = null;
        try (PreparedStatement statement = connection.prepareStatement(query);){
            java.util.Date data = indice.getData();
            statement.setDouble(1, indice.getPrezzo());
            statement.setInt(2, mercato);
            statement.setInt(3, zona);
            statement.setDate(4, new Date(data.getTime()));
            statement.setInt(5, ora);
            statement.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

