/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.dao.JdbcGiadaDao;
import biz.elabor.prebilling.model.giada.RigaPod;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.db.QueryTemplate;

public class JdbcGiadaDaoTest
extends TestCase {
    public void testGetRighePod() throws IOException, NotDeletableException, DuplicateKeyException {
        TestConfiguration configuration = new TestConfiguration();
        JdbcGiadaDao dao = new JdbcGiadaDao(configuration);
        JdbcGiadaDaoTest.resetDb(dao);
        String cclettur = configuration.getCclettur();
        List<RigaPod> righePod = dao.getRighePod(2017, Month.MAY, cclettur);
        JdbcGiadaDaoTest.assertEquals(0, righePod.size());
        JdbcGiadaDaoTest.fillRighePodDb(dao);
        righePod = dao.getRighePod(2017, Month.MAY, cclettur);
        JdbcGiadaDaoTest.assertEquals(10, righePod.size());
        RigaPod rigaPod = righePod.get(0);
        String statoUtenza = rigaPod.getStatoUtenza();
        JdbcGiadaDaoTest.assertEquals("statoUtenza1", statoUtenza);
        boolean allineato = rigaPod.isAllineato();
        JdbcGiadaDaoTest.assertEquals(false, allineato);
        String dispatcher = rigaPod.getDispatcher();
        JdbcGiadaDaoTest.assertEquals("dispatcher", dispatcher);
    }

    private static void fillRighePodDb(JdbcGiadaDao dao) throws DuplicateKeyException {
        int index = 1;
        while (index <= 10) {
            QueryTemplate query = new QueryTemplate("insert into pod values(:codice,'1','2','3','1','2',:statoUtenza,'2017-01-01','2017-12-31','1','1','true','true','true','true','2016-12-31','2016-12-31','NO','2016-01-31','2016-01-31','dispatcher')");
            query.replace(":codice", index);
            query.replace(":statoUtenza", "statoUtenza" + index);
            dao.executeInsert(query);
            ++index;
        }
    }

    private static void resetDb(JdbcGiadaDao dao) throws NotDeletableException {
        dao.executeDelete("delete from contratti");
        dao.executeDelete("delete from pod");
    }
}

