/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DatiMisura;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.RecordCreator;

public class DatiMisuraCreator
implements RecordCreator<DatiMisura> {
    private final DateFormat annoMeseFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
    private final Date endDate;

    public DatiMisuraCreator(int anno, Month mese) {
        this.endDate = CalendarTools.getNextMese(anno, mese);
    }

    @Override
    public DatiMisura createRecord(ResultSet rs) throws SQLException {
        Date mese = BasicRecordCreatorHelper.getDate(rs, "anno_mese", this.annoMeseFormat);
        String codicePod = rs.getString("pod_id").trim();
        return mese.before(this.endDate) ? new DatiMisura(mese, codicePod) : null;
    }
}

