/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.ResultRecord;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractMultiUpdateHandler;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.misure.IdAziendaFlusso;
import java.sql.PreparedStatement;
import java.sql.SQLException;

abstract class AbstractResultMultiUpdateHandler<T extends IdAziendaFlusso>
extends AbstractMultiUpdateHandler<ResultRecord<T, PrebillingError>> {
    public AbstractResultMultiUpdateHandler(String campoStato, String campoCodErrore, String campoDescErrore, String tabella) {
        super(campoStato, campoCodErrore, campoDescErrore, "UPDATE " + tabella + " SET :stato=?, :cod_errore=?, :desc_errore=?, cdaziend=? WHERE id=?");
    }

    public AbstractResultMultiUpdateHandler(Funzionalita funzionalita, String tabella) {
        super(funzionalita, "UPDATE " + tabella + " SET :stato=?, :cod_errore=?, :desc_errore=?, cdaziend=? WHERE id=?");
    }

    @Override
    public boolean prepare(PreparedStatement ps, ResultRecord<T, PrebillingError> result, StatoMisure stato, String id) throws SQLException {
        IdAziendaFlusso misura = (IdAziendaFlusso)result.getRecord();
        PrebillingError errore = result.getErrore();
        ps.setInt(1, stato.getCodice());
        ps.setInt(2, errore.getCodice());
        ps.setString(3, result.getMessaggio());
        ps.setString(4, misura.getCdaziend());
        ps.setString(5, id);
        return true;
    }
}

