/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.model;

import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.FixingBandeManager;
import biz.elabor.prebilling.common.model.FixingSwapManager;
import biz.elabor.prebilling.common.model.FlatManager;
import biz.elabor.prebilling.common.model.FlatVariableManager;
import biz.elabor.prebilling.common.model.IgnoreManager;
import biz.elabor.prebilling.common.model.MultiploManager;
import biz.elabor.prebilling.common.model.NonFlatManager;
import biz.elabor.prebilling.common.model.ResiduoFlatManager;
import biz.elabor.prebilling.common.model.ResiduoNegativoManager;
import biz.elabor.prebilling.common.model.ResiduoNegativoMinoritarioManager;
import biz.elabor.prebilling.common.model.ResiduoNegativoSpreadManager;
import biz.elabor.prebilling.common.model.ResiduoPositivoManager;
import biz.elabor.prebilling.common.model.ResiduoPositivoSpreadManager;
import biz.elabor.prebilling.common.model.SpreadManager;
import biz.elabor.prebilling.common.model.TipoFlatManager;
import biz.elabor.prebilling.common.model.TipoFlatVisitor;
import java.util.List;

public enum TipoFlat {
    NON_FLAT(new NonFlatManager()),
    FLAT(new FlatManager()),
    RESIDUO(new ResiduoFlatManager()),
    RESIDUO_POSITIVO(new ResiduoPositivoManager()),
    RESIDUO_NEGATIVO(new ResiduoNegativoManager()),
    SPREAD(new SpreadManager()),
    RESIDUO_NEGATIVO_MINORITARIO(new ResiduoNegativoMinoritarioManager()),
    RESIDUO_POSITIVO_SPREAD(new ResiduoPositivoSpreadManager()),
    RESIDUO_NEGATIVO_SPREAD(new ResiduoNegativoSpreadManager()),
    FLAT_VARIABILE(new FlatVariableManager()),
    MULTIPLO(new MultiploManager()),
    IGNORE(new IgnoreManager()),
    FIXING_SWAP(new FixingSwapManager()),
    FIXING_BANDE(new FixingBandeManager());

    private TipoFlatManager manager;

    private TipoFlat(TipoFlatManager manager) {
        this.manager = manager;
    }

    public double getConsumoEfficace(double consumoReale, double consumoFlat, double emtaruni, double cdindneg) {
        return this.manager.getConsumoEfficace(consumoReale, consumoFlat, emtaruni, cdindneg);
    }

    public boolean isSpread() {
        return this.manager.isSpread();
    }

    public double getQtMisura(double varoreEffettivo, double valore) {
        return this.manager.getQtMisura(varoreEffettivo, valore);
    }

    public double getConsumoTotale(double reale, double flat) {
        return this.manager.getConsumoTotale(reale, flat);
    }

    public double getConsumoTariffa(double consumoReale, double consumoEfficace) {
        return this.manager.getConsumoTariffa(consumoReale, consumoEfficace);
    }

    public double getPrezzo(double reale, double flat, double spread, double consumoReale, double consumoFlat) {
        return this.manager.getPrezzo(reale, flat, spread, consumoReale, consumoFlat);
    }

    public String getCodiceIndiceEnergetico(Contratto contratto) {
        return this.manager.getCodiceIndiceEnergetico(contratto);
    }

    public double getPrezzoGiornoSpread(Contratto contratto) {
        double emspread = contratto.getEmspread();
        double emspreneg = contratto.getEmspreneg();
        return this.manager.getPrezzoGiornoSpread(emspread, emspreneg);
    }

    public double getPrezzoGiornoSpread(double emspread, double emspreneg) {
        return this.manager.getPrezzoGiornoSpread(emspread, emspreneg);
    }

    public boolean isMissingSbil(Contratto contratto) {
        return this.manager.isMissingSbil(contratto);
    }

    public boolean isApplicable(double consumoReale) {
        return this.manager.isApplicable(consumoReale);
    }

    public boolean isFixing() {
        return this.manager.isFixing();
    }

    public void accept(TipoFlatVisitor visitor) {
        this.manager.accept(visitor);
    }

    public double getCostoGiorno(double consumo, double prezzoGiorno, double costoGiornoFlat, int nCifre) {
        return this.manager.getCostoGiorno(consumo, prezzoGiorno, costoGiornoFlat, nCifre);
    }

    public boolean isFlat() {
        return this.equals((Object)FLAT);
    }

    public double getEmspread(Contratto contratto, double consumoTotaleFixingSwap, List<MultipuntoOption> opzioniFixingSwap) {
        return this.manager.getEmspread(contratto, consumoTotaleFixingSwap, opzioniFixingSwap);
    }

    public boolean isFixingSwap() {
        return this.equals((Object)FIXING_SWAP);
    }
}

