/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.RecordCreator;

public class MultiPuntoOptionCreator
implements RecordCreator<MultipuntoOption> {
    private static final Date ZERO_DATE = new Date(0L);
    private static final Date END_OF_TIME = CalendarTools.getEndOfTime();
    private final DateFormat STANDARD_DATE_FORMAT = StrategyCommonHelper.getStandardDateFormat();

    @Override
    public MultipuntoOption createRecord(ResultSet rs) throws SQLException {
        String codRaggruppamento = rs.getString("COD_RAGGRUPPAMENTO");
        double prezzo = rs.getDouble("PREZZO_FIX");
        double volume = rs.getDouble("VOLUME_FIX");
        Date dataValidita = BasicRecordCreatorHelper.getDate(rs, "DTVALIDI", this.STANDARD_DATE_FORMAT, ZERO_DATE);
        Date dataScadenza = BasicRecordCreatorHelper.getDate(rs, "DTSCADEN", this.STANDARD_DATE_FORMAT, END_OF_TIME);
        return new MultipuntoOption(codRaggruppamento, prezzo, volume, dataValidita, dataScadenza);
    }
}

