/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.AbstractJdbcPrebillingDao;
import biz.elabor.prebilling.common.model.Applicazione;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.db.DoubleCreator;
import org.homelinux.elabor.db.IntegerCreator;
import org.homelinux.elabor.db.QueryTemplate;

public abstract class AbstractJdbcMisureDao
extends AbstractJdbcPrebillingDao {
    private final DateFormat standardDateFormat = StrategyCommonHelper.getStandardDateFormat();

    public AbstractJdbcMisureDao(String host, DbmsType dbType, String dbName, String user, String password) {
        super(host, dbType, dbName, user, password);
    }

    @Override
    public long getNextValue() {
        long value;
        try {
            value = this.queryForInt("select identificativo_esecuzione.nextval from dual");
        }
        catch (DataNotFoundException exc) {
            throw new RuntimeException(exc);
        }
        return value;
    }

    protected List<Integer> getSubapplicazioni(String tabella, Applicazione applicazione, int anno, Month mese) {
        QueryTemplate query = new QueryTemplate("SELECT appl_sub FROM " + tabella + " " + "WHERE" + " tipo=:tipo:" + " AND to_char(dtinicom, 'yyyy-mm-dd') <= :date:" + " AND (dtfincom is null OR to_char(dtfincom, 'yyyy-mm-dd') > :date:) " + "ORDER BY appl_sub");
        query.replace(":tipo:", applicazione.getTipo());
        Date date = CalendarTools.getDate(anno, mese, 1);
        query.replace(":date:", date, this.standardDateFormat);
        IntegerCreator creator = new IntegerCreator();
        return this.getRecords(query, creator);
    }

    public Double getPrezzoScivolo(String servizio, String reseller, String indice, int anno, Month mese) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("SELECT qtindene FROM prezzi_scivolo WHERE servizio=:servizio: AND cdaziend=:reseller: AND indice=:indice: AND dtindene=to_date(:data:, 'yyyy-mm-dd')");
        query.replace(":servizio:", servizio);
        query.replace(":reseller:", reseller);
        query.replace(":indice:", indice);
        Date data = CalendarTools.getDate(anno, mese, 1);
        query.replace(":data:", data, this.standardDateFormat);
        DoubleCreator creator = new DoubleCreator();
        return this.getRecord(query, creator, null, indice);
    }
}

