/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common;

import biz.elabor.prebilling.common.FileCopyHelper;
import biz.elabor.prebilling.common.config.BasicPrebillingConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.file.NotDirectoryException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public abstract class AbstractFileCopyStrategy {
    protected final TalkManager talkManager;
    private final BasicPrebillingConfiguration configuration;

    protected abstract void copyDispatcher(String var1, Logger var2) throws NotDirectoryException, IOException;

    protected abstract File[] getResellerTmpFolders(String var1);

    protected abstract File getResellerFolder(String var1);

    protected abstract File getExecutionTmpFolder(String var1);

    public AbstractFileCopyStrategy(BasicPrebillingConfiguration configuration, TalkManager talkManager) {
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    protected boolean execute(String idEsecuzione, Logger logger) {
        boolean ok;
        try {
            this.copyDispatcher(idEsecuzione, logger);
            this.copyReseller(idEsecuzione, logger);
            this.copyCoda(idEsecuzione, logger);
            ok = true;
        }
        catch (IOException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("file.copy", "copy.error");
            sentence.addParam(message);
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            logger.log(Level.SEVERE, userMessage, exc);
            ok = false;
        }
        catch (NotDirectoryException exc) {
            Message sentence = new Message("file.copy", "not.directory");
            sentence.addParam(exc.getFile().getAbsolutePath());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            logger.log(Level.SEVERE, userMessage, exc);
            ok = false;
        }
        File tmpFolder = this.getExecutionTmpFolder(idEsecuzione);
        FileSystemTools.clean(tmpFolder);
        return ok;
    }

    private void copyReseller(String idEsecuzione, Logger logger) throws NotDirectoryException, IOException {
        File[] files = this.getResellerTmpFolders(idEsecuzione);
        if (files != null) {
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                String id = AbstractFileCopyStrategy.extractId(file.getName());
                File destination = this.getResellerFolder(id);
                destination.mkdirs();
                FileSystemTools.folderCopy(file, destination, logger);
                ++n3;
            }
        }
    }

    private void copyCoda(String idEsecuzione, Logger logger) throws NotDirectoryException, IOException {
        File source = FileCopyHelper.getCodaTmpFolder(this.configuration, idEsecuzione);
        if (source.exists()) {
            File destination = this.configuration.getCodaFolder();
            destination.mkdirs();
            AbstractFileCopyStrategy.addFileExtension(source, "tmp");
            FileSystemTools.folderCopy(source, destination, logger);
            AbstractFileCopyStrategy.removeFileExtension(destination, "tmp");
        }
    }

    private static void addFileExtension(File folder, String extension) throws IOException {
        File[] listFiles;
        File[] fileArray = listFiles = folder.listFiles();
        int n2 = listFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            if (file.isDirectory()) {
                AbstractFileCopyStrategy.addFileExtension(file, extension);
            } else {
                String path = String.valueOf(file.getAbsolutePath()) + "." + extension;
                File newFile = new File(path);
                file.renameTo(newFile);
            }
            ++n3;
        }
    }

    private static void removeFileExtension(File folder, String extension) throws IOException {
        File[] listFiles;
        File[] fileArray = listFiles = folder.listFiles();
        int n2 = listFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            if (file.isDirectory()) {
                AbstractFileCopyStrategy.removeFileExtension(file, extension);
            } else {
                String fullExtension;
                String path = file.getAbsolutePath();
                if (path.endsWith(fullExtension = "." + extension)) {
                    File newFile = new File(path.substring(0, path.lastIndexOf(fullExtension)));
                    file.renameTo(newFile);
                }
            }
            ++n3;
        }
    }

    private static String extractId(String name) {
        String[] split = name.split("-");
        return split[1];
    }
}

