/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling;

import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.Generazione;
import biz.elabor.prebilling.dao.NullMockPrebillingConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.homelinux.elabor.db.DbmsType;

public class TestConfiguration
extends NullMockPrebillingConfiguration {
    private boolean crm;
    private boolean trunking;

    public TestConfiguration() {
        this.trunking = false;
    }

    public TestConfiguration(boolean trunking) {
        this.trunking = trunking;
    }

    @Override
    public String getDefaultAzienda() {
        return "default";
    }

    @Override
    public String getVersion() {
        return "test";
    }

    @Override
    public File getInputFolder() {
        return new File("/tmp/prebilling-test/input");
    }

    @Override
    public File getMiddlewareOutputFolder() {
        return new File("/tmp/prebilling-test/middleware");
    }

    @Override
    public String getCdmeslet(String flusso, boolean stimata, boolean orario, boolean rettifica, boolean smis) {
        return stimata ? (orario ? "0050" : "0060") : "0000";
    }

    @Override
    public String getGiadaHost() {
        return "localhost";
    }

    @Override
    public DbmsType getGiadaType() {
        return DbmsType.POSTGRES;
    }

    @Override
    public String getGiadaDbName() {
        return "giada-test";
    }

    @Override
    public String getGiadaDbUser() {
        return "prebilling";
    }

    @Override
    public String getGiadaDbPassword() {
        return "prebilling";
    }

    @Override
    public String getIndiciHost() {
        return "localhost";
    }

    @Override
    public DbmsType getIndiciDbmsType() {
        return DbmsType.POSTGRES;
    }

    @Override
    public String getIndiciDbName() {
        return "indici-test";
    }

    @Override
    public String getIndiciDbUser() {
        return "prebilling";
    }

    @Override
    public String getIndiciDbPassword() {
        return "prebilling";
    }

    @Override
    public String getMisureHost() {
        return "localhost";
    }

    @Override
    public DbmsType getMisureType() {
        return DbmsType.POSTGRES;
    }

    @Override
    public String getMisureDbName() {
        return "misure-test";
    }

    @Override
    public String getMisureDbUser() {
        return "prebilling";
    }

    @Override
    public String getMisureDbPassword() {
        return "prebilling";
    }

    @Override
    public boolean hasPiv() {
        return false;
    }

    @Override
    public String getPrebillingHost() {
        return "localhost";
    }

    @Override
    public DbmsType getPrebillingType() {
        return DbmsType.POSTGRES;
    }

    @Override
    public String getPrebillingDbName() {
        return "prebilling-test";
    }

    @Override
    public String getPrebillingDbUser() {
        return "prebilling";
    }

    @Override
    public String getPrebillingDbPassword() {
        return "prebilling";
    }

    @Override
    public String getCifreStd() {
        return "5";
    }

    @Override
    public File getResellerOutputFolder(String id) {
        return new File("/tmp/prebilling-test/reseller-" + id);
    }

    @Override
    public File getDispatcherOutputFolder() {
        return new File("/tmp/prebilling-test/dispatcher");
    }

    @Override
    public File getTmpFolder() {
        return new File("/tmp/prebilling-test/");
    }

    @Override
    public String getCclettur() {
        return "23";
    }

    @Override
    public boolean hasCrm() {
        return this.crm;
    }

    public void setCrm(boolean crm) {
        this.crm = crm;
    }

    @Override
    public String getCodiceDispatcher() {
        return "dispatcher";
    }

    @Override
    public double getCoeffUMPrezzi() {
        return 2.0;
    }

    @Override
    public Set<String> getTarDisDom() {
        String[] split = "D2,D3,TDR,TDNR,TDPC".split(",");
        return new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public int getLunghezzaMatricola() {
        return 20;
    }

    @Override
    public String getPivaDistributoreVoltureSpeciale() {
        return "pivaEnel";
    }

    @Override
    public boolean isTrunking() {
        return this.trunking;
    }

    @Override
    public String getIdCalendarioArera() {
        return "1";
    }

    @Override
    public CdConMag getCdConMag(String keyCdConMag) {
        CdConMag cdConMag = keyCdConMag.contentEquals("MONO") ? new CdConMag("MONO", "01001", Generazione.G1) : (keyCdConMag.contentEquals("CE") ? new CdConMag("CE", "01002", Generazione.G1) : (keyCdConMag.contentEquals("CEO") ? new CdConMag("CEO", "01009", Generazione.G1) : (keyCdConMag.contentEquals("GME") ? new CdConMag("GME", "01010", Generazione.G1) : new CdConMag("XXX", "00000", Generazione.G1))));
        return cdConMag;
    }

    @Override
    public int getCifreTariffe() {
        return 8;
    }

    @Override
    public int getXmlMaxSize() {
        return 10000000;
    }

    @Override
    public Date getToDay() {
        return new Date();
    }
}

