/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.rilevazioni;

import biz.elabor.misure.model.rilevazioni.RilevazioneOraria;
import biz.elabor.misure.model.rilevazioni.RilevazioneOrariaSolare;
import java.util.Iterator;
import org.homelinux.elabor.arrays.Accumulator;
import org.homelinux.elabor.arrays.AccumulatorSequence;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public class CurvaGiornaliera<Pod>
extends AccumulatorSequence<RilevazioneOraria>
implements Accumulator<CurvaGiornaliera<Pod>> {
    private static final long serialVersionUID = 1L;
    private int anno;
    private Month mese;
    private int giorno;

    public CurvaGiornaliera(int anno, Month mese, int giorno) {
        this.anno = anno;
        this.mese = mese;
        this.giorno = giorno;
        int hours = CalendarTools.getHoursOfDay(anno, mese, giorno);
        this.setup(hours);
    }

    @Override
    public RilevazioneOraria createElement(int index) {
        ElaborCalendar calendar = CalendarTools.getCalendarFromIndex(this.anno, this.mese, this.giorno, index);
        int annoSolare = calendar.getAnnoSolare();
        Month meseSolare = calendar.getMeseSolare();
        int giornoSolare = calendar.getGiornoSolare();
        int oraSolare = calendar.getOraSolare();
        return new RilevazioneOrariaSolare(annoSolare, meseSolare, giornoSolare, oraSolare);
    }

    @Override
    public void addCurva(CurvaGiornaliera<Pod> curva, double mult) {
        super.addCurva(curva, mult);
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
        for (RilevazioneOraria oraria : this) {
            oraria.setAnno(anno);
        }
    }

    public Month getMese() {
        return this.mese;
    }

    public void setMese(Month mese) {
        this.mese = mese;
        for (RilevazioneOraria oraria : this) {
            oraria.setMese(mese);
        }
    }

    public int getGiorno() {
        return this.giorno;
    }

    public void setGiorno(int giorno) {
        this.giorno = giorno;
        for (RilevazioneOraria oraria : this) {
            oraria.setGiorno(giorno);
        }
    }

    public CurvaGiornaliera<Pod> copy() {
        CurvaGiornaliera<Pod> copy = new CurvaGiornaliera<Pod>(this.anno, this.mese, this.giorno);
        Iterator templateIterator = this.iterator();
        Iterator copyIterator = copy.iterator();
        while (templateIterator.hasNext() && copyIterator.hasNext()) {
            RilevazioneOraria template = (RilevazioneOraria)templateIterator.next();
            RilevazioneOraria next = (RilevazioneOraria)copyIterator.next();
            if (!template.getState().isSet()) continue;
            next.setAttiva(template.getAttiva());
            next.setReattiva(template.getReattiva());
        }
        return copy;
    }

    public double getTotal() {
        double total = 0.0;
        for (RilevazioneOraria ro : this) {
            total += ro.getAttiva();
        }
        return total;
    }
}

