/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.fasce;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.misure.model.rilevazioni.CurvaGiornaliera;
import biz.elabor.misure.model.rilevazioni.CurvaMensile;
import biz.elabor.misure.model.rilevazioni.RilevazioneOraria;
import biz.elabor.misure.model.rilevazioni.RilevazionePerFasce;
import org.homelinux.elabor.calendar.Month;

public class FasceAccumulator
extends RilevazionePerFasce {
    private double[] potenze = new double[FasciaOraria.values().length];

    public void add(FasciaOraria fascia, double valoreAttiva, double valoreReattiva) {
        double attiva = this.getAttiva(fascia);
        double reattiva = this.getReattiva(fascia);
        this.setAttiva(fascia, attiva + valoreAttiva);
        this.setReattiva(fascia, reattiva + valoreReattiva);
    }

    public static <Pod> FasceAccumulator sum(CurvaMensile<Pod> curvaMensile, CalendarioFasceMensile mensile) {
        FasceAccumulator result = new FasceAccumulator();
        int anno = curvaMensile.getAnno();
        Month mese = curvaMensile.getMese();
        result.setAnno(anno);
        result.setMese(mese);
        for (CalendarioFasceGiornaliero calendarioFasceGiornaliero : mensile) {
            int giorno = calendarioFasceGiornaliero.getGiorno();
            CurvaGiornaliera curvaGiornaliera = (CurvaGiornaliera)curvaMensile.get(giorno - 1);
            for (RilevazioneOraria rilevazioneOraria : curvaGiornaliera) {
                int ora = rilevazioneOraria.getOraLegale();
                FasciaOraria fascia = calendarioFasceGiornaliero.getFascia(ora);
                double attiva = rilevazioneOraria.getAttiva();
                double reattiva = rilevazioneOraria.getReattiva();
                result.add(fascia, attiva, reattiva);
                double maxPotenza = result.getPotenza(fascia);
                double potenza = rilevazioneOraria.getPotenza();
                if (!(maxPotenza < potenza)) continue;
                result.setPotenza(fascia, potenza);
            }
        }
        return result;
    }

    private void setPotenza(FasciaOraria fascia, double potenza) {
        this.potenze[fascia.ordinal()] = potenza;
    }

    public double getPotenza(FasciaOraria fascia) {
        return this.potenze[fascia.ordinal()];
    }
}

